/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dao.PluginConfigurationFileDao;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dto.UpdateConfigurationFileDto;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PluginConfigurationFileService {
    @Autowired
    private PluginConfigurationFileDao dao;

    @Transactional
    public PluginConfigurationFile get(Long fileId) {
        return (PluginConfigurationFile)this.dao.get(fileId);
    }

    @Transactional
    public Optional<PluginConfigurationFile> getByReadableFileId(String readableFileID) {
        return Optional.ofNullable(this.dao.getByReadableFileId(readableFileID));
    }

    @Transactional
    public List<PluginConfigurationFile> getForPlugin(String pluginId) {
        return this.dao.getForPlugin(pluginId);
    }

    @Transactional
    public long create(String pluginId, UpdateConfigurationFileDto newFileDto) {
        boolean readableFileAlreadyExists = this.getForPlugin(pluginId).stream().anyMatch(file -> file.getReadableFileId().equals(newFileDto.getReadableFileId()));
        Assert.isTrue((!readableFileAlreadyExists ? 1 : 0) != 0, (String)("Configuration " + newFileDto.getReadableFileId() + " for plugin " + pluginId + " already exists"));
        PluginConfigurationFile file2 = PluginConfigurationFile.builder().pluginId(pluginId).readableFileId(newFileDto.getReadableFileId()).fileType(newFileDto.getFileType()).build();
        return (Long)this.dao.save(file2);
    }

    @Transactional
    public void update(Long fileId, UpdateConfigurationFileDto changeFileDto) {
        PluginConfigurationFile configurationFile = (PluginConfigurationFile)this.dao.get(fileId);
        configurationFile.setReadableFileId(changeFileDto.getReadableFileId());
        configurationFile.setFileType(changeFileDto.getFileType());
    }

    @Transactional
    public void delete(Long fileId) {
        PluginConfigurationFile file = (PluginConfigurationFile)this.dao.get(fileId);
        this.dao.delete(file);
    }
}

