/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.graphicschema;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.graphicschema.ConfigurationFileGraphicSchemaProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.graphicschema.GraphicSchema;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service.PluginConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"configuration"})
public class ConfigurationGraphicSchemaController {
    @Autowired
    private PluginConfigurationService configurationService;

    @ResponseBody
    @RequestMapping(value={"plugin/{pluginId}/{fileName}/graphicSchema"})
    public GraphicSchema getGraphicSchema(@PathVariable String pluginId, @PathVariable String fileName) throws IOException {
        PluginConfigurationDefinition definition = this.configurationService.getForPlugin(pluginId);
        ConfigurationFileGraphicSchemaProvider graphicSchemaProvider = definition.getGraphicSchemaProvider();
        if (graphicSchemaProvider != null) {
            InputStream stream = graphicSchemaProvider.readSchemaForFile(fileName);
            if (stream == null) {
                stream = graphicSchemaProvider.readSchema();
            }
            try (InputStream inputStream = stream;){
                String graphicSchemaContent = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                GraphicSchema graphicSchema = new GraphicSchema(graphicSchemaContent);
                return graphicSchema;
            }
        }
        return new GraphicSchema("");
    }
}

