/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.service;

import com.suncode.plugin.organization.structure.service.OsmStructureService;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.PositionAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.PositionNotFoundException;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OsmStructureServiceImpl
implements OsmStructureService {
    private static final Logger log = LoggerFactory.getLogger(OsmStructureServiceImpl.class);
    @Autowired
    private StructureService structureService;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    private OrganizationalUnitFinder ouFinder;

    @Override
    public void updatePosition(Position position) {
        this.structureService.updatePosition(position);
    }

    private Optional<OrganizationalUnit> createOU(String name, String symbol) throws EmptyPropertyException, OrganizationalUnitAlreadyExistException {
        Optional<OrganizationalUnit> organizationalUnit;
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)symbol)) {
            return Optional.empty();
        }
        if (StringUtils.isBlank((CharSequence)symbol)) {
            symbol = this.buildSymbol(name);
        }
        if ((organizationalUnit = Optional.ofNullable(this.ouFinder.findBySymbol(symbol, new String[0]))).isPresent() && StringUtils.isNotBlank((CharSequence)name)) {
            organizationalUnit.get().setName(name);
            this.structureService.updateOrganizationalUnit(organizationalUnit.get());
        } else if (!organizationalUnit.isPresent()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                name = symbol;
            }
            OrganizationalUnit newOU = new OrganizationalUnit(name, symbol);
            this.structureService.validateOrganizationalUnit(newOU);
            this.structureService.createOrganizationalUnit(newOU);
            return Optional.of(newOU);
        }
        return organizationalUnit;
    }

    @Override
    public void deleteAvailablePositions() {
        List availablePositions = this.positionFinder.findAvailablePositions(new String[0]);
        for (Position position : availablePositions) {
            this.structureService.deletePosition(position.getId());
        }
    }

    private String buildSymbol(String name) {
        return this.buildSymbol(name, null);
    }

    private String buildSymbol(String name, Long number) {
        String[] strArray = name.split(" ");
        String symbol = name;
        if (strArray.length > 1) {
            symbol = Arrays.stream(strArray).filter(StringUtils::isNotBlank).map(String::trim).map(s -> s.substring(0, 1)).collect(Collectors.joining());
        }
        return symbol.toUpperCase() + (number != null ? "-" + number : "");
    }

    @Override
    public Optional<OrganizationalUnit> getOU(String ouSymbol, String ouName, String higherOUSymbol, String higherOUName) {
        Optional<Object> organizationalUnit = Optional.empty();
        Optional<Object> higherOrganizationUnit = Optional.empty();
        try {
            organizationalUnit = this.createOU(ouName, ouSymbol);
        }
        catch (OrganizationalUnitAlreadyExistException | EmptyPropertyException e) {
            log.error("Error create ou. ouName: " + ouName + " ,ouSymbol: " + ouSymbol, e);
        }
        try {
            higherOrganizationUnit = this.createOU(higherOUName, higherOUSymbol);
        }
        catch (OrganizationalUnitAlreadyExistException | EmptyPropertyException e) {
            log.error("Error create higher ou. higherOUName: " + higherOUName + " ,higherOUSymbol: " + higherOUSymbol, e);
        }
        if (organizationalUnit.isPresent() && higherOrganizationUnit.isPresent()) {
            ((OrganizationalUnit)organizationalUnit.get()).setHigherOrganizationalUnit((OrganizationalUnit)higherOrganizationUnit.get());
            this.structureService.updateOrganizationalUnit((OrganizationalUnit)organizationalUnit.get());
        }
        return organizationalUnit;
    }

    @Override
    public Optional<Position> getPosition(String name, String symbol, Map<String, Long> positionNamesCount) throws EmptyPropertyException, PositionAlreadyExistException, PositionNotFoundException {
        Optional<Position> position;
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)symbol)) {
            return Optional.empty();
        }
        if (StringUtils.isBlank((CharSequence)symbol)) {
            Long nrPosition = 0L;
            do {
                if (!positionNamesCount.containsKey(name)) {
                    positionNamesCount.put(name, nrPosition);
                }
                nrPosition = positionNamesCount.get(name) + 1L;
                symbol = this.buildSymbol(name, nrPosition);
                positionNamesCount.put(name, nrPosition);
            } while (this.positionFinder.findBySymbol(symbol, new String[0]) != null);
        }
        if ((position = Optional.ofNullable(this.positionFinder.findBySymbol(symbol, new String[0]))).isPresent() && StringUtils.isNotBlank((CharSequence)name)) {
            position.get().setName(name);
            this.structureService.updatePosition(position.get());
        } else if (!position.isPresent()) {
            position = Optional.of(this.createNewPosition(name, symbol));
        }
        return position;
    }

    private Position createNewPosition(String name, String symbol) throws PositionAlreadyExistException, PositionNotFoundException {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = symbol;
        }
        Position position = new Position(name, symbol);
        this.structureService.validatePosition(position);
        this.structureService.createPosition(position);
        return position;
    }

    @Override
    public void updatePositionName(String name, Position position) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            position.setName(name);
            this.structureService.updatePosition(position);
        }
    }

    @Override
    public void detachPositionFromUser(Long positionId) {
        this.structureService.detachPositionFromUser(positionId);
    }
}

