/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.organization.structure.dto.DataSourceUserDto;
import com.suncode.plugin.organization.structure.service.OsmDataSourceService;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OsmDataSourceServiceImpl
implements OsmDataSourceService {
    @Autowired
    private DataSourceService dsService;
    private static final ObjectMapper mapper = new ObjectMapper();

    private DataSourceInstance getDataSourceInstance(String datasourceId) {
        DataSourceInstance dsInstance = this.dsService.getDataSource(datasourceId);
        if (dsInstance == null) {
            throw new RuntimeException("Datasource with id: " + datasourceId + "does not exist");
        }
        return dsInstance;
    }

    @Override
    public List<DataSourceUserDto> readDataSource(String datasourceId) {
        DataSourceInstance dsInstance = this.getDataSourceInstance(datasourceId);
        CountedResult countedResult = dsInstance.execute(new HashMap(), new HashMap(), null);
        return this.toUsersList(countedResult.getData());
    }

    private List<DataSourceUserDto> toUsersList(List<Map<String, Object>> data) {
        return data.stream().map(row -> (DataSourceUserDto)mapper.convertValue(row, DataSourceUserDto.class)).collect(Collectors.toList());
    }
}

