/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.dto;

import com.suncode.plugin.organization.structure.config.dtos.Configuration;
import com.suncode.plugin.organization.structure.config.enums.StructureConfigType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureTableDto {
    private static final Logger log = LoggerFactory.getLogger(StructureTableDto.class);
    private Long id;
    private String userLogin;
    private String userDomain;
    private String userFirstName;
    private String userLastName;
    private String userPassword;
    private String userEmail;
    private String userNumber;
    private List<String> groupNames;
    private List<String> groupDescriptions;
    private List<String> positionNames;
    private List<String> positionSymbols;
    private List<String> roles;
    private List<String> organizationUnitNames;
    private List<String> organizationUnitSymbols;
    private List<String> higherOrganizationUnitSymbols;
    private List<String> higherOrganizationUnitNames;
    private List<String> higherPositionSymbols;
    private List<String> directoryPositionSymbols;
    private String bufor1;
    private String bufor2;
    private String bufor3;
    private String bufor4;
    private String bufor5;
    private List<String> bufor6;
    private List<String> bufor7;
    private List<String> bufor8;

    public void update(String value, StructureConfigType type, Configuration config) {
        log.trace("Update field: " + (Object)((Object)type) + " with value: " + value);
        switch (type) {
            case BUFOR1: {
                if (!StringUtils.isBlank((CharSequence)this.bufor1)) break;
                this.bufor1 = value;
                break;
            }
            case BUFOR2: {
                if (!StringUtils.isBlank((CharSequence)this.bufor2)) break;
                this.bufor2 = value;
                break;
            }
            case BUFOR3: {
                if (!StringUtils.isBlank((CharSequence)this.bufor3)) break;
                this.bufor3 = value;
                break;
            }
            case BUFOR4: {
                if (!StringUtils.isBlank((CharSequence)this.bufor4)) break;
                this.bufor4 = value;
                break;
            }
            case BUFOR5: {
                if (!StringUtils.isBlank((CharSequence)this.bufor5)) break;
                this.bufor5 = value;
                break;
            }
            case BUFOR6_TAB: {
                this.bufor6.add(value);
                break;
            }
            case BUFOR7_TAB: {
                this.bufor7.add(value);
                break;
            }
            case BUFOR8_TAB: {
                this.bufor8.add(value);
                break;
            }
            case DIRECTOR_POSITION_SYMBOL_TAB: {
                this.directoryPositionSymbols.add(value);
                break;
            }
            case DOMAIN: {
                if (!StringUtils.isBlank((CharSequence)this.userDomain)) break;
                this.userDomain = value;
                break;
            }
            case GROUP_NAME_TAB: {
                if (StringUtils.isBlank((CharSequence)config.getSplitGroupNamesCharacter())) {
                    this.groupNames.add(value);
                    break;
                }
                this.groupNames.addAll(Arrays.asList(value.split(config.getSplitGroupNamesCharacter())));
                break;
            }
            case GROUP_DESCRIPTION_TAB: {
                if (StringUtils.isBlank((CharSequence)config.getSplitGroupNamesCharacter())) {
                    this.groupDescriptions.add(value);
                    break;
                }
                this.groupDescriptions.addAll(Arrays.asList(value.split(config.getSplitGroupNamesCharacter())));
                break;
            }
            case HIGHER_ORGANIZATION_UNIT_SYMBOL_TAB: {
                this.higherOrganizationUnitSymbols.add(value);
                break;
            }
            case HIGHER_ORGANIZATION_UNIT_NAME_TAB: {
                this.higherOrganizationUnitNames.add(value);
                break;
            }
            case HIGHER_POSITION_SYMBOL_TAB: {
                this.higherPositionSymbols.add(value);
                break;
            }
            case ORGANIZATION_UNIT_NAME_TAB: {
                this.organizationUnitNames.add(value);
                break;
            }
            case ORGANIZATION_UNIT_SYMBOL_TAB: {
                this.organizationUnitSymbols.add(value);
                break;
            }
            case POSITION_NAME_TAB: {
                this.positionNames.add(value);
                break;
            }
            case POSITION_SYMBOL_TAB: {
                this.positionSymbols.add(value);
                break;
            }
            case ROLE_TAB: {
                if (StringUtils.isBlank((CharSequence)config.getSplitRolesCharacter())) {
                    this.roles.add(value);
                } else {
                    this.roles.addAll(Arrays.asList(value.split(config.getSplitRolesCharacter())));
                }
                this.roles = this.roles.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                break;
            }
            case USER_EMAIL: {
                if (!StringUtils.isBlank((CharSequence)this.userEmail)) break;
                this.userEmail = value;
                break;
            }
            case USER_FIRSTNAME: {
                if (!StringUtils.isBlank((CharSequence)this.userFirstName)) break;
                this.userFirstName = value;
                break;
            }
            case USER_LASTNAME: {
                if (!StringUtils.isBlank((CharSequence)this.userLastName)) break;
                this.userLastName = value;
                break;
            }
            case USER_LOGIN: {
                if (!StringUtils.isBlank((CharSequence)this.userLogin)) break;
                this.userLogin = value;
                break;
            }
            case USER_NUMBER: {
                if (!StringUtils.isBlank((CharSequence)this.userNumber)) break;
                this.userNumber = value;
                break;
            }
            case USER_PASSWORD: {
                if (!StringUtils.isBlank((CharSequence)this.userPassword)) break;
                this.userPassword = value;
            }
        }
    }

    public void clearBufor(StructureConfigType type) {
        log.trace("Clear bufor: " + (Object)((Object)type));
        switch (type) {
            case BUFOR1: {
                this.bufor1 = "";
                break;
            }
            case BUFOR2: {
                this.bufor2 = "";
                break;
            }
            case BUFOR3: {
                this.bufor3 = "";
                break;
            }
            case BUFOR4: {
                this.bufor4 = "";
                break;
            }
            case BUFOR5: {
                this.bufor5 = "";
                break;
            }
            case BUFOR6_TAB: {
                this.bufor6 = new LinkedList<String>();
                break;
            }
            case BUFOR7_TAB: {
                this.bufor7 = new LinkedList<String>();
                break;
            }
            case BUFOR8_TAB: {
                this.bufor8 = new LinkedList<String>();
            }
        }
    }

    private static List<String> $default$groupNames() {
        return new LinkedList<String>();
    }

    private static List<String> $default$groupDescriptions() {
        return new LinkedList<String>();
    }

    private static List<String> $default$positionNames() {
        return new LinkedList<String>();
    }

    private static List<String> $default$positionSymbols() {
        return new LinkedList<String>();
    }

    private static List<String> $default$roles() {
        return new LinkedList<String>();
    }

    private static List<String> $default$organizationUnitNames() {
        return new LinkedList<String>();
    }

    private static List<String> $default$organizationUnitSymbols() {
        return new LinkedList<String>();
    }

    private static List<String> $default$higherOrganizationUnitSymbols() {
        return new LinkedList<String>();
    }

    private static List<String> $default$higherOrganizationUnitNames() {
        return new LinkedList<String>();
    }

    private static List<String> $default$higherPositionSymbols() {
        return new LinkedList<String>();
    }

    private static List<String> $default$directoryPositionSymbols() {
        return new LinkedList<String>();
    }

    private static List<String> $default$bufor6() {
        return new LinkedList<String>();
    }

    private static List<String> $default$bufor7() {
        return new LinkedList<String>();
    }

    private static List<String> $default$bufor8() {
        return new LinkedList<String>();
    }

    StructureTableDto(Long id, String userLogin, String userDomain, String userFirstName, String userLastName, String userPassword, String userEmail, String userNumber, List<String> groupNames, List<String> groupDescriptions, List<String> positionNames, List<String> positionSymbols, List<String> roles, List<String> organizationUnitNames, List<String> organizationUnitSymbols, List<String> higherOrganizationUnitSymbols, List<String> higherOrganizationUnitNames, List<String> higherPositionSymbols, List<String> directoryPositionSymbols, String bufor1, String bufor2, String bufor3, String bufor4, String bufor5, List<String> bufor6, List<String> bufor7, List<String> bufor8) {
        this.id = id;
        this.userLogin = userLogin;
        this.userDomain = userDomain;
        this.userFirstName = userFirstName;
        this.userLastName = userLastName;
        this.userPassword = userPassword;
        this.userEmail = userEmail;
        this.userNumber = userNumber;
        this.groupNames = groupNames;
        this.groupDescriptions = groupDescriptions;
        this.positionNames = positionNames;
        this.positionSymbols = positionSymbols;
        this.roles = roles;
        this.organizationUnitNames = organizationUnitNames;
        this.organizationUnitSymbols = organizationUnitSymbols;
        this.higherOrganizationUnitSymbols = higherOrganizationUnitSymbols;
        this.higherOrganizationUnitNames = higherOrganizationUnitNames;
        this.higherPositionSymbols = higherPositionSymbols;
        this.directoryPositionSymbols = directoryPositionSymbols;
        this.bufor1 = bufor1;
        this.bufor2 = bufor2;
        this.bufor3 = bufor3;
        this.bufor4 = bufor4;
        this.bufor5 = bufor5;
        this.bufor6 = bufor6;
        this.bufor7 = bufor7;
        this.bufor8 = bufor8;
    }

    public static StructureTableDtoBuilder builder() {
        return new StructureTableDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public List<String> getGroupDescriptions() {
        return this.groupDescriptions;
    }

    public List<String> getPositionNames() {
        return this.positionNames;
    }

    public List<String> getPositionSymbols() {
        return this.positionSymbols;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getOrganizationUnitNames() {
        return this.organizationUnitNames;
    }

    public List<String> getOrganizationUnitSymbols() {
        return this.organizationUnitSymbols;
    }

    public List<String> getHigherOrganizationUnitSymbols() {
        return this.higherOrganizationUnitSymbols;
    }

    public List<String> getHigherOrganizationUnitNames() {
        return this.higherOrganizationUnitNames;
    }

    public List<String> getHigherPositionSymbols() {
        return this.higherPositionSymbols;
    }

    public List<String> getDirectoryPositionSymbols() {
        return this.directoryPositionSymbols;
    }

    public String getBufor1() {
        return this.bufor1;
    }

    public String getBufor2() {
        return this.bufor2;
    }

    public String getBufor3() {
        return this.bufor3;
    }

    public String getBufor4() {
        return this.bufor4;
    }

    public String getBufor5() {
        return this.bufor5;
    }

    public List<String> getBufor6() {
        return this.bufor6;
    }

    public List<String> getBufor7() {
        return this.bufor7;
    }

    public List<String> getBufor8() {
        return this.bufor8;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public void setUserDomain(String userDomain) {
        this.userDomain = userDomain;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public void setGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
    }

    public void setGroupDescriptions(List<String> groupDescriptions) {
        this.groupDescriptions = groupDescriptions;
    }

    public void setPositionNames(List<String> positionNames) {
        this.positionNames = positionNames;
    }

    public void setPositionSymbols(List<String> positionSymbols) {
        this.positionSymbols = positionSymbols;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setOrganizationUnitNames(List<String> organizationUnitNames) {
        this.organizationUnitNames = organizationUnitNames;
    }

    public void setOrganizationUnitSymbols(List<String> organizationUnitSymbols) {
        this.organizationUnitSymbols = organizationUnitSymbols;
    }

    public void setHigherOrganizationUnitSymbols(List<String> higherOrganizationUnitSymbols) {
        this.higherOrganizationUnitSymbols = higherOrganizationUnitSymbols;
    }

    public void setHigherOrganizationUnitNames(List<String> higherOrganizationUnitNames) {
        this.higherOrganizationUnitNames = higherOrganizationUnitNames;
    }

    public void setHigherPositionSymbols(List<String> higherPositionSymbols) {
        this.higherPositionSymbols = higherPositionSymbols;
    }

    public void setDirectoryPositionSymbols(List<String> directoryPositionSymbols) {
        this.directoryPositionSymbols = directoryPositionSymbols;
    }

    public void setBufor1(String bufor1) {
        this.bufor1 = bufor1;
    }

    public void setBufor2(String bufor2) {
        this.bufor2 = bufor2;
    }

    public void setBufor3(String bufor3) {
        this.bufor3 = bufor3;
    }

    public void setBufor4(String bufor4) {
        this.bufor4 = bufor4;
    }

    public void setBufor5(String bufor5) {
        this.bufor5 = bufor5;
    }

    public void setBufor6(List<String> bufor6) {
        this.bufor6 = bufor6;
    }

    public void setBufor7(List<String> bufor7) {
        this.bufor7 = bufor7;
    }

    public void setBufor8(List<String> bufor8) {
        this.bufor8 = bufor8;
    }

    public String toString() {
        return "StructureTableDto(id=" + this.getId() + ", userLogin=" + this.getUserLogin() + ", userDomain=" + this.getUserDomain() + ", userFirstName=" + this.getUserFirstName() + ", userLastName=" + this.getUserLastName() + ", userPassword=" + this.getUserPassword() + ", userEmail=" + this.getUserEmail() + ", userNumber=" + this.getUserNumber() + ", groupNames=" + this.getGroupNames() + ", groupDescriptions=" + this.getGroupDescriptions() + ", positionNames=" + this.getPositionNames() + ", positionSymbols=" + this.getPositionSymbols() + ", roles=" + this.getRoles() + ", organizationUnitNames=" + this.getOrganizationUnitNames() + ", organizationUnitSymbols=" + this.getOrganizationUnitSymbols() + ", higherOrganizationUnitSymbols=" + this.getHigherOrganizationUnitSymbols() + ", higherOrganizationUnitNames=" + this.getHigherOrganizationUnitNames() + ", higherPositionSymbols=" + this.getHigherPositionSymbols() + ", directoryPositionSymbols=" + this.getDirectoryPositionSymbols() + ", bufor1=" + this.getBufor1() + ", bufor2=" + this.getBufor2() + ", bufor3=" + this.getBufor3() + ", bufor4=" + this.getBufor4() + ", bufor5=" + this.getBufor5() + ", bufor6=" + this.getBufor6() + ", bufor7=" + this.getBufor7() + ", bufor8=" + this.getBufor8() + ")";
    }

    public static class StructureTableDtoBuilder {
        private Long id;
        private String userLogin;
        private String userDomain;
        private String userFirstName;
        private String userLastName;
        private String userPassword;
        private String userEmail;
        private String userNumber;
        private boolean groupNames$set;
        private List<String> groupNames$value;
        private boolean groupDescriptions$set;
        private List<String> groupDescriptions$value;
        private boolean positionNames$set;
        private List<String> positionNames$value;
        private boolean positionSymbols$set;
        private List<String> positionSymbols$value;
        private boolean roles$set;
        private List<String> roles$value;
        private boolean organizationUnitNames$set;
        private List<String> organizationUnitNames$value;
        private boolean organizationUnitSymbols$set;
        private List<String> organizationUnitSymbols$value;
        private boolean higherOrganizationUnitSymbols$set;
        private List<String> higherOrganizationUnitSymbols$value;
        private boolean higherOrganizationUnitNames$set;
        private List<String> higherOrganizationUnitNames$value;
        private boolean higherPositionSymbols$set;
        private List<String> higherPositionSymbols$value;
        private boolean directoryPositionSymbols$set;
        private List<String> directoryPositionSymbols$value;
        private String bufor1;
        private String bufor2;
        private String bufor3;
        private String bufor4;
        private String bufor5;
        private boolean bufor6$set;
        private List<String> bufor6$value;
        private boolean bufor7$set;
        private List<String> bufor7$value;
        private boolean bufor8$set;
        private List<String> bufor8$value;

        StructureTableDtoBuilder() {
        }

        public StructureTableDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StructureTableDtoBuilder userLogin(String userLogin) {
            this.userLogin = userLogin;
            return this;
        }

        public StructureTableDtoBuilder userDomain(String userDomain) {
            this.userDomain = userDomain;
            return this;
        }

        public StructureTableDtoBuilder userFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
            return this;
        }

        public StructureTableDtoBuilder userLastName(String userLastName) {
            this.userLastName = userLastName;
            return this;
        }

        public StructureTableDtoBuilder userPassword(String userPassword) {
            this.userPassword = userPassword;
            return this;
        }

        public StructureTableDtoBuilder userEmail(String userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        public StructureTableDtoBuilder userNumber(String userNumber) {
            this.userNumber = userNumber;
            return this;
        }

        public StructureTableDtoBuilder groupNames(List<String> groupNames) {
            this.groupNames$value = groupNames;
            this.groupNames$set = true;
            return this;
        }

        public StructureTableDtoBuilder groupDescriptions(List<String> groupDescriptions) {
            this.groupDescriptions$value = groupDescriptions;
            this.groupDescriptions$set = true;
            return this;
        }

        public StructureTableDtoBuilder positionNames(List<String> positionNames) {
            this.positionNames$value = positionNames;
            this.positionNames$set = true;
            return this;
        }

        public StructureTableDtoBuilder positionSymbols(List<String> positionSymbols) {
            this.positionSymbols$value = positionSymbols;
            this.positionSymbols$set = true;
            return this;
        }

        public StructureTableDtoBuilder roles(List<String> roles) {
            this.roles$value = roles;
            this.roles$set = true;
            return this;
        }

        public StructureTableDtoBuilder organizationUnitNames(List<String> organizationUnitNames) {
            this.organizationUnitNames$value = organizationUnitNames;
            this.organizationUnitNames$set = true;
            return this;
        }

        public StructureTableDtoBuilder organizationUnitSymbols(List<String> organizationUnitSymbols) {
            this.organizationUnitSymbols$value = organizationUnitSymbols;
            this.organizationUnitSymbols$set = true;
            return this;
        }

        public StructureTableDtoBuilder higherOrganizationUnitSymbols(List<String> higherOrganizationUnitSymbols) {
            this.higherOrganizationUnitSymbols$value = higherOrganizationUnitSymbols;
            this.higherOrganizationUnitSymbols$set = true;
            return this;
        }

        public StructureTableDtoBuilder higherOrganizationUnitNames(List<String> higherOrganizationUnitNames) {
            this.higherOrganizationUnitNames$value = higherOrganizationUnitNames;
            this.higherOrganizationUnitNames$set = true;
            return this;
        }

        public StructureTableDtoBuilder higherPositionSymbols(List<String> higherPositionSymbols) {
            this.higherPositionSymbols$value = higherPositionSymbols;
            this.higherPositionSymbols$set = true;
            return this;
        }

        public StructureTableDtoBuilder directoryPositionSymbols(List<String> directoryPositionSymbols) {
            this.directoryPositionSymbols$value = directoryPositionSymbols;
            this.directoryPositionSymbols$set = true;
            return this;
        }

        public StructureTableDtoBuilder bufor1(String bufor1) {
            this.bufor1 = bufor1;
            return this;
        }

        public StructureTableDtoBuilder bufor2(String bufor2) {
            this.bufor2 = bufor2;
            return this;
        }

        public StructureTableDtoBuilder bufor3(String bufor3) {
            this.bufor3 = bufor3;
            return this;
        }

        public StructureTableDtoBuilder bufor4(String bufor4) {
            this.bufor4 = bufor4;
            return this;
        }

        public StructureTableDtoBuilder bufor5(String bufor5) {
            this.bufor5 = bufor5;
            return this;
        }

        public StructureTableDtoBuilder bufor6(List<String> bufor6) {
            this.bufor6$value = bufor6;
            this.bufor6$set = true;
            return this;
        }

        public StructureTableDtoBuilder bufor7(List<String> bufor7) {
            this.bufor7$value = bufor7;
            this.bufor7$set = true;
            return this;
        }

        public StructureTableDtoBuilder bufor8(List<String> bufor8) {
            this.bufor8$value = bufor8;
            this.bufor8$set = true;
            return this;
        }

        public StructureTableDto build() {
            List groupNames$value = this.groupNames$value;
            if (!this.groupNames$set) {
                groupNames$value = StructureTableDto.$default$groupNames();
            }
            List groupDescriptions$value = this.groupDescriptions$value;
            if (!this.groupDescriptions$set) {
                groupDescriptions$value = StructureTableDto.$default$groupDescriptions();
            }
            List positionNames$value = this.positionNames$value;
            if (!this.positionNames$set) {
                positionNames$value = StructureTableDto.$default$positionNames();
            }
            List positionSymbols$value = this.positionSymbols$value;
            if (!this.positionSymbols$set) {
                positionSymbols$value = StructureTableDto.$default$positionSymbols();
            }
            List roles$value = this.roles$value;
            if (!this.roles$set) {
                roles$value = StructureTableDto.$default$roles();
            }
            List organizationUnitNames$value = this.organizationUnitNames$value;
            if (!this.organizationUnitNames$set) {
                organizationUnitNames$value = StructureTableDto.$default$organizationUnitNames();
            }
            List organizationUnitSymbols$value = this.organizationUnitSymbols$value;
            if (!this.organizationUnitSymbols$set) {
                organizationUnitSymbols$value = StructureTableDto.$default$organizationUnitSymbols();
            }
            List higherOrganizationUnitSymbols$value = this.higherOrganizationUnitSymbols$value;
            if (!this.higherOrganizationUnitSymbols$set) {
                higherOrganizationUnitSymbols$value = StructureTableDto.$default$higherOrganizationUnitSymbols();
            }
            List higherOrganizationUnitNames$value = this.higherOrganizationUnitNames$value;
            if (!this.higherOrganizationUnitNames$set) {
                higherOrganizationUnitNames$value = StructureTableDto.$default$higherOrganizationUnitNames();
            }
            List higherPositionSymbols$value = this.higherPositionSymbols$value;
            if (!this.higherPositionSymbols$set) {
                higherPositionSymbols$value = StructureTableDto.$default$higherPositionSymbols();
            }
            List directoryPositionSymbols$value = this.directoryPositionSymbols$value;
            if (!this.directoryPositionSymbols$set) {
                directoryPositionSymbols$value = StructureTableDto.$default$directoryPositionSymbols();
            }
            List bufor6$value = this.bufor6$value;
            if (!this.bufor6$set) {
                bufor6$value = StructureTableDto.$default$bufor6();
            }
            List bufor7$value = this.bufor7$value;
            if (!this.bufor7$set) {
                bufor7$value = StructureTableDto.$default$bufor7();
            }
            List bufor8$value = this.bufor8$value;
            if (!this.bufor8$set) {
                bufor8$value = StructureTableDto.$default$bufor8();
            }
            return new StructureTableDto(this.id, this.userLogin, this.userDomain, this.userFirstName, this.userLastName, this.userPassword, this.userEmail, this.userNumber, groupNames$value, groupDescriptions$value, positionNames$value, positionSymbols$value, roles$value, organizationUnitNames$value, organizationUnitSymbols$value, higherOrganizationUnitSymbols$value, higherOrganizationUnitNames$value, higherPositionSymbols$value, directoryPositionSymbols$value, this.bufor1, this.bufor2, this.bufor3, this.bufor4, this.bufor5, bufor6$value, bufor7$value, bufor8$value);
        }

        public String toString() {
            return "StructureTableDto.StructureTableDtoBuilder(id=" + this.id + ", userLogin=" + this.userLogin + ", userDomain=" + this.userDomain + ", userFirstName=" + this.userFirstName + ", userLastName=" + this.userLastName + ", userPassword=" + this.userPassword + ", userEmail=" + this.userEmail + ", userNumber=" + this.userNumber + ", groupNames$value=" + this.groupNames$value + ", groupDescriptions$value=" + this.groupDescriptions$value + ", positionNames$value=" + this.positionNames$value + ", positionSymbols$value=" + this.positionSymbols$value + ", roles$value=" + this.roles$value + ", organizationUnitNames$value=" + this.organizationUnitNames$value + ", organizationUnitSymbols$value=" + this.organizationUnitSymbols$value + ", higherOrganizationUnitSymbols$value=" + this.higherOrganizationUnitSymbols$value + ", higherOrganizationUnitNames$value=" + this.higherOrganizationUnitNames$value + ", higherPositionSymbols$value=" + this.higherPositionSymbols$value + ", directoryPositionSymbols$value=" + this.directoryPositionSymbols$value + ", bufor1=" + this.bufor1 + ", bufor2=" + this.bufor2 + ", bufor3=" + this.bufor3 + ", bufor4=" + this.bufor4 + ", bufor5=" + this.bufor5 + ", bufor6$value=" + this.bufor6$value + ", bufor7$value=" + this.bufor7$value + ", bufor8$value=" + this.bufor8$value + ")";
        }
    }
}

