/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.dto;

import com.suncode.plugin.organization.structure.db.enums.DataType;
import com.suncode.plugin.organization.structure.db.enums.LogStatus;
import com.suncode.plugin.organization.structure.exception.utils.ExceptionTool;
import java.sql.Timestamp;
import org.joda.time.DateTime;

public class LogDto {
    private final DateTime dateTime;
    private final LogStatus status;
    private final DataType type;
    private final String info;

    public LogDto(LogStatus status, DataType type, String info) {
        this.dateTime = DateTime.now();
        this.status = status;
        this.type = type;
        this.info = info;
    }

    public LogDto(String status, String type, String info, Timestamp timestamp) {
        this.dateTime = new DateTime(timestamp.getTime());
        this.status = LogStatus.getEnum(status);
        this.type = DataType.getEnum(type);
        this.info = info;
    }

    public String getStatus() {
        return this.status == null ? "" : this.status.getStatus();
    }

    public String getType() {
        return this.type == null ? "" : this.type.getType();
    }

    public Long getTime() {
        return this.dateTime.getMillis();
    }

    public static LogDto buildErrorLogDto(DataType dataType, Exception e) {
        return new LogDto(LogStatus.ERROR, dataType, ExceptionTool.getStackTrace(e, 4000));
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public String getInfo() {
        return this.info;
    }
}

