/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.task;

import com.suncode.plugin.organization.structure.category.Categories;
import com.suncode.plugin.organization.structure.dto.DataSourceUserDto;
import com.suncode.plugin.organization.structure.enums.SuperiorMappingKey;
import com.suncode.plugin.organization.structure.enums.UserMappingKey;
import com.suncode.plugin.organization.structure.exception.TaskCanceledException;
import com.suncode.plugin.organization.structure.exception.utils.ExceptionTool;
import com.suncode.plugin.organization.structure.service.OsmDataSourceService;
import com.suncode.plugin.organization.structure.service.OsmStructureService;
import com.suncode.plugin.organization.structure.service.OsmUserService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class SyncOrganizationStructureDS {
    @Autowired
    private OsmUserService osmUserService;
    @Autowired
    private OsmDataSourceService osmDataSourceService;
    @Autowired
    private OsmStructureService osmStructureService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("organization.structure.sync-os-ds.scheduledtask")).name("organization.structure.sync-os-ds.name")).description("organization.structure.sync-os-ds.desc")).category(new Category[]{Categories.PLUS_ORGANIZATION_STRUCTURE_MANAGER})).cancelable().parameter().id("datasourceId").name("organization.structure.sync-os-ds.datasourceId.name").description("organization.structure.sync-os-ds.datasourceId.desc").type((Type)Types.STRING).create()).parameter().id("keyMapping").name("organization.structure.sync-os-ds.keyMapping.name").description("organization.structure.sync-os-ds.keyMapping.desc").type((Type)Types.STRING).create()).parameter().id("superiorMappingKey").name("organization.structure.sync-os-ds.superiorMappingKey.name").description("organization.structure.sync-os-ds.superiorMappingKey.desc").type((Type)Types.STRING).optional().create()).parameter().id("isDetachUnsynchronizedPosition").name("organization.structure.sync-os-ds.isDetachUnsynchronizedPosition.name").description("organization.structure.sync-os-ds.isDetachUnsynchronizedPosition.desc").defaultValue((Object)"FALSE").type((Type)Types.STRING).create();
    }

    public String execute(@Param String datasourceId, @Param String keyMapping, @Param String superiorMappingKey, @Param String isDetachUnsynchronizedPosition, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancellation, Logger taskLog) {
        HashMap<String, Long> positionNamesCount = new HashMap<String, Long>();
        UserMappingKey userMappingKey = UserMappingKey.fromKey(keyMapping);
        SuperiorMappingKey supperiorMappingKey = StringUtils.isBlank((CharSequence)superiorMappingKey) ? null : SuperiorMappingKey.fromKey(superiorMappingKey);
        try {
            taskLog.debug((Object)("Start task: " + scheduledTaskInfo.getName()));
            ExceptionTool.checkTaskCancellation(cancellation);
            List<DataSourceUserDto> dsUserDtos = this.osmDataSourceService.readDataSource(datasourceId);
            ExceptionTool.checkTaskCancellation(cancellation);
            Map<String, User> usersMap = this.osmUserService.fetchMappingValueToUserMap(userMappingKey);
            HashMap<String, List<String>> positionNamesPerUser = new HashMap<String, List<String>>();
            taskLog.debug((Object)"delete available positions");
            this.osmStructureService.deleteAvailablePositions();
            Long updatedRowsCount = 0L;
            this.filterAvailableUserDto(userMappingKey, dsUserDtos, usersMap);
            Long dsRowNumber = 0L;
            HashMap<String, Position> superiorsPosition = new HashMap<String, Position>();
            for (DataSourceUserDto dsUserDto : dsUserDtos) {
                ExceptionTool.checkTaskCancellation(cancellation);
                Long l = dsRowNumber;
                Long l2 = dsRowNumber = Long.valueOf(dsRowNumber + 1L);
                String userMappingValue = dsUserDto.getUserMappingValue(userMappingKey);
                User user = usersMap.get(userMappingValue);
                if (user == null) continue;
                this.addPositionNameByUser(positionNamesPerUser, dsUserDto, userMappingValue);
                taskLog.debug((Object)("Processing datasource row: " + dsRowNumber + ": " + dsUserDto.toString()));
                taskLog.debug((Object)this.osmUserService.updateUserData(user, dsUserDto));
                Optional<OrganizationalUnit> ou = this.osmStructureService.getOU(dsUserDto.getOuSymbol(), dsUserDto.getOuName(), dsUserDto.getHigherOUSymbol(), dsUserDto.getHigherOUName());
                Optional<Position> position = this.osmUserService.getUserPosition(dsUserDto.getPositionSymbol(), dsUserDto.getPositionName(), user, positionNamesCount);
                if (position.isPresent()) {
                    String superiorKey;
                    Position pos = position.get();
                    if (ou.isPresent()) {
                        pos.setOrganizationalUnit(ou.get());
                        this.osmStructureService.updatePosition(pos);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(superiorKey = this.buildUserSuperiorKey(dsUserDto, user, supperiorMappingKey))) && !superiorsPosition.containsKey(superiorKey)) {
                        superiorsPosition.put(superiorKey, pos);
                    }
                }
                Long l3 = updatedRowsCount;
                Long l4 = updatedRowsCount = Long.valueOf(updatedRowsCount + 1L);
            }
            if (!superiorsPosition.isEmpty()) {
                taskLog.debug((Object)"Update higherPositions");
                this.updateHigherPositions(userMappingKey, supperiorMappingKey, dsUserDtos, usersMap, superiorsPosition, cancellation);
            }
            if (StringUtils.isNotBlank((CharSequence)isDetachUnsynchronizedPosition) && !isDetachUnsynchronizedPosition.equalsIgnoreCase("FALSE")) {
                taskLog.debug((Object)"Detach unsynchronized positions");
                this.detachUnsynchronizedProstionFromUser(userMappingKey, positionNamesPerUser);
            }
            taskLog.debug((Object)"Delete available positions");
            this.osmStructureService.deleteAvailablePositions();
            String string = "Updated users:" + updatedRowsCount;
            return string;
        }
        catch (TaskCanceledException cancelEx) {
            taskLog.debug((Object)("Cancel task: " + scheduledTaskInfo.getName()));
            String string = "Cancelled";
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            taskLog.debug((Object)("End task: " + scheduledTaskInfo.getName()));
        }
    }

    private void addPositionNameByUser(Map<String, List<String>> positionNamesPerUser, DataSourceUserDto dsUserDto, String userMappingValue) {
        if (!positionNamesPerUser.containsKey(userMappingValue)) {
            positionNamesPerUser.put(userMappingValue, new ArrayList());
        }
        positionNamesPerUser.get(userMappingValue).add(dsUserDto.getPositionName());
    }

    private void detachUnsynchronizedProstionFromUser(UserMappingKey mappingKey, Map<String, List<String>> positionNamesPerUser) {
        for (Map.Entry<String, User> userMapEntry : this.osmUserService.fetchMappingValueToUserMap(mappingKey).entrySet()) {
            for (Position position : userMapEntry.getValue().getPositions()) {
                if (position == null || !positionNamesPerUser.containsKey(userMapEntry.getKey()) || positionNamesPerUser.get(userMapEntry.getKey()).contains(position.getName())) continue;
                this.osmStructureService.detachPositionFromUser(position.getId());
            }
        }
    }

    private String buildUserSuperiorKey(DataSourceUserDto dsMapper, User user, SuperiorMappingKey superiorMappingKey) {
        if (superiorMappingKey == null) {
            if (dsMapper.getSuperiorFullName() != null) {
                return user.getFullName();
            }
            if (dsMapper.getSuperiorFullNameRev() != null) {
                return user.getLastName() + " " + user.getFirstName();
            }
            if (dsMapper.getSuperiorFirstName() != null && dsMapper.getSuperiorLastName() != null) {
                return user.getFullName();
            }
            if (dsMapper.getSuperiorName() != null) {
                return user.getUserName();
            }
            return null;
        }
        switch (superiorMappingKey) {
            case SUPERIOR_NAME: {
                return user.getUserName();
            }
            case SUPERIOR_NUMBER: {
                return user.getNumber();
            }
            case SUPERIOR_FULLNAME: {
                return user.getFullName();
            }
            case SUPERIOR_FULLNAMEREV: {
                return user.getLastName() + " " + user.getFirstName();
            }
        }
        return null;
    }

    private List<DataSourceUserDto> filterAvailableUserDto(UserMappingKey mappingKey, List<DataSourceUserDto> dsUserDtos, Map<String, User> usersMap) {
        return dsUserDtos.stream().filter(dsUserDto -> {
            String searchValue = dsUserDto.getUserMappingValue(mappingKey);
            return !StringUtils.isBlank((CharSequence)searchValue) && usersMap.containsKey(searchValue);
        }).collect(Collectors.toList());
    }

    private void updateHigherPositions(UserMappingKey mappingKey, SuperiorMappingKey superiorMappingKey, List<DataSourceUserDto> dsUserDtos, Map<String, User> usersMap, Map<String, Position> userPositions, CancelationHandler cancellation) throws TaskCanceledException {
        for (DataSourceUserDto dsUserDto : dsUserDtos) {
            ExceptionTool.checkTaskCancellation(cancellation);
            User user = usersMap.get(dsUserDto.getUserMappingValue(mappingKey));
            if (user == null) continue;
            String superiorKey = dsUserDto.getSuperiorMappingValue(superiorMappingKey);
            String userKey = this.buildUserSuperiorKey(dsUserDto, user, superiorMappingKey);
            if (!userPositions.containsKey(userKey)) continue;
            Position pos = userPositions.get(userKey);
            Position higherPos = null;
            if (StringUtils.isNotBlank((CharSequence)superiorKey) && userPositions.containsKey(superiorKey)) {
                higherPos = userPositions.get(superiorKey);
            }
            pos.setHigherPosition(higherPos);
            this.osmStructureService.updatePosition(pos);
        }
    }
}

