/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.service;

import com.suncode.plugin.organization.structure.config.dtos.Configuration;
import com.suncode.plugin.organization.structure.config.dtos.ConfigurationRow;
import com.suncode.plugin.organization.structure.config.dtos.DataSourceInputParam;
import com.suncode.plugin.organization.structure.config.dtos.StructureConfigurationDto;
import com.suncode.plugin.organization.structure.config.enums.StructureConfigType;
import com.suncode.plugin.organization.structure.db.servicies.StructureTableService;
import com.suncode.plugin.organization.structure.ds.servicies.DSService;
import com.suncode.plugin.organization.structure.dto.StructureTableDto;
import com.suncode.plugin.organization.structure.eval.JavaScriptEngine;
import com.suncode.plugin.organization.structure.exception.TaskCanceledException;
import com.suncode.plugin.organization.structure.exception.utils.ExceptionTool;
import com.suncode.plugin.organization.structure.service.StructureTemplateService;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureTemplateServiceImpl
implements StructureTemplateService {
    private static final Logger log = LoggerFactory.getLogger(StructureTemplateServiceImpl.class);
    private static final String SCRIPT_OPTION = "SCRIPT";
    public static final int NUMBER_OF_THREADS = 100;
    @Autowired
    private DSService dsService;
    @Autowired
    private StructureTableService structureTableService;

    @Override
    public void createStructureTemplate(StructureConfigurationDto configDto, CancelationHandler cancellation) throws TaskCanceledException {
        Configuration config = configDto.getConfig();
        List sortedConfigRow = configDto.getRows().stream().sorted(Comparator.comparing(ConfigurationRow::getIndex)).collect(Collectors.toList());
        HashMap<String, List<Map<String, Object>>> cachedDataFromDS = new HashMap<String, List<Map<String, Object>>>();
        boolean createNewRecords = true;
        List<StructureTableDto> dates = new ArrayList<StructureTableDto>();
        for (ConfigurationRow configRow : sortedConfigRow) {
            long start = DateTime.now().getMillis();
            log.debug("Processing:  index " + configRow.getIndex());
            ExceptionTool.checkTaskCancellation(cancellation);
            this.updateCacheDataFromDS(cachedDataFromDS, configRow);
            if (createNewRecords) {
                dates = this.createNewRecords(config, cachedDataFromDS, configRow);
                createNewRecords = false;
            } else {
                this.updateRecords(cancellation, config, cachedDataFromDS, dates, configRow);
            }
            log.debug("End Processing:  index " + configRow.getIndex() + "Time: " + (DateTime.now().getMillis() - start) + " [ms]");
        }
    }

    private List<StructureTableDto> createNewRecords(Configuration config, Map<String, List<Map<String, Object>>> cachedDataFromDS, ConfigurationRow configRow) {
        this.checkIsOneType(configRow);
        this.addNewRecords(configRow, config, cachedDataFromDS);
        return this.structureTableService.getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecords(CancelationHandler cancellation, Configuration config, Map<String, List<Map<String, Object>>> cachedDataFromDS, List<StructureTableDto> dates, ConfigurationRow configRow) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        try {
            dates.parallelStream().forEach(structureTableDto -> {
                ExceptionTool.checkTaskCancellation(cancellation);
                executorService.submit(() -> this.updateRow(config, configRow, (StructureTableDto)structureTableDto, cachedDataFromDS));
            });
            executorService.shutdown();
            while (!executorService.isTerminated()) {
                ExceptionTool.checkTaskCancellation(cancellation);
                Thread.sleep(500L);
            }
        }
        finally {
            this.structureTableService.updateEntities(dates);
            if (!executorService.isShutdown()) {
                executorService.shutdownNow();
            }
        }
    }

    private void checkIsOneType(ConfigurationRow configRow) {
        if (configRow.getTypes().size() != 1) {
            throw new IllegalArgumentException("First index: " + configRow.getIndex() + " must be of only one type to create new records. types: " + configRow.getTypes());
        }
    }

    private void checkIsOneDatasourceOutput(ConfigurationRow configRow) {
        if (configRow.getDataSourceOutputParamIds().size() != 1) {
            throw new IllegalArgumentException("First index: " + configRow.getIndex() + " must be of only one datasourceOutputIds to create new records. datasourceOutputIds: " + configRow.getDataSourceOutputParamIds());
        }
    }

    private void updateCacheDataFromDS(Map<String, List<Map<String, Object>>> cachedDataFromDS, ConfigurationRow configRow) {
        String dataSourceId = configRow.getDataSourceId();
        if (this.isNewDataToCache(cachedDataFromDS, configRow, dataSourceId)) {
            cachedDataFromDS.put(dataSourceId, this.dsService.execute(configRow.getDataSourceId(), new HashMap<String, String>(), null).getData());
        }
    }

    private void updateRow(Configuration config, ConfigurationRow configRow, StructureTableDto structureTableDto, Map<String, List<Map<String, Object>>> cachedDataFromDS) {
        long startRow = DateTime.now().getMillis();
        log.trace("Processing:  index " + configRow.getIndex() + " updateRow");
        String dataSourceId = configRow.getDataSourceId();
        if (dataSourceId.equals(SCRIPT_OPTION)) {
            this.updateByScript(configRow, structureTableDto, config);
        } else if (cachedDataFromDS.containsKey(dataSourceId) && this.isNoDSParameterInput(configRow)) {
            this.updateByDatasource(configRow, structureTableDto, cachedDataFromDS.get(dataSourceId), config);
        } else {
            this.updateByDatasource(configRow, structureTableDto, config);
        }
        log.trace("End Processing:  index " + configRow.getIndex() + "updateRow Time: " + (DateTime.now().getMillis() - startRow) + " [ms]");
    }

    private boolean isNewDataToCache(Map<String, List<Map<String, Object>>> cachedDataFromDS, ConfigurationRow configRow, String dataSourceId) {
        return !dataSourceId.equals(SCRIPT_OPTION) && this.isNoDSParameterInput(configRow) && !cachedDataFromDS.containsKey(dataSourceId);
    }

    private boolean isNoDSParameterInput(ConfigurationRow configRow) {
        boolean noDSParametrInput = true;
        if (configRow.getDataSourceInputParams() != null) {
            noDSParametrInput = configRow.getDataSourceInputParams().stream().noneMatch(item -> item != null && StringUtils.isNotBlank((CharSequence)item.getParamInputId()));
        }
        return noDSParametrInput;
    }

    private void updateByDatasource(ConfigurationRow configRow, StructureTableDto structureTableDto, Configuration config) {
        Map<String, String> parameters = this.buildDsInputParameters(structureTableDto, configRow);
        List dataFromDS = this.dsService.execute(configRow.getDataSourceId(), parameters, null).getData();
        this.updateByDatasource(configRow, structureTableDto, dataFromDS, config);
    }

    private void updateByDatasource(ConfigurationRow configRow, StructureTableDto structureTableDto, List<Map<String, Object>> dataFromDS, Configuration config) {
        this.checkSize(configRow);
        String resultFilter = configRow.getResultFilter();
        List filteredData = dataFromDS.parallelStream().filter(Objects::nonNull).filter(datasourceData -> !datasourceData.isEmpty()).filter(datasourceData -> StringUtils.isBlank((CharSequence)configRow.getResultFilter()) || (Boolean)JavaScriptEngine.eval(structureTableDto, datasourceData, resultFilter) != false).collect(Collectors.toList());
        if (!filteredData.isEmpty()) {
            for (int index = 0; index < configRow.getTypes().size(); ++index) {
                StructureConfigType structureConfigType = configRow.getTypes().get(index);
                String dataSourceOutputId = configRow.getDataSourceOutputParamIds().get(index);
                structureTableDto.clearBufor(structureConfigType);
                if (structureConfigType.isArrayColumn().booleanValue()) {
                    for (Map data : filteredData) {
                        String value = Objects.toString(data.get(dataSourceOutputId), "");
                        structureTableDto.update(value, structureConfigType, config);
                    }
                    continue;
                }
                String value = Objects.toString(((Map)filteredData.get(0)).get(dataSourceOutputId), "");
                structureTableDto.update(value, structureConfigType, config);
            }
        }
    }

    private void checkSize(ConfigurationRow configRow) {
        if (configRow.getTypes().size() != configRow.getDataSourceOutputParamIds().size()) {
            throw new IllegalArgumentException("Table parameters 'types' and 'datasourceOutputIds' must the same length for datasource");
        }
    }

    private void updateByScript(ConfigurationRow configRow, StructureTableDto structureTableDto, Configuration config) {
        for (StructureConfigType structureConfigType : configRow.getTypes()) {
            if (structureConfigType.isArrayColumn().booleanValue()) {
                for (String value : JavaScriptEngine.evalStringArray(structureTableDto, configRow.getScriptValue())) {
                    structureTableDto.update(value, structureConfigType, config);
                }
                continue;
            }
            String result = (String)JavaScriptEngine.eval(structureTableDto, configRow.getScriptValue());
            structureTableDto.update(result, structureConfigType, config);
        }
    }

    private void addNewRecords(ConfigurationRow configRow, Configuration config, Map<String, List<Map<String, Object>>> cachedDataFromDS) {
        String dataSourceId = configRow.getDataSourceId();
        if (dataSourceId.equals(SCRIPT_OPTION)) {
            this.structureTableService.saveNewEntity(JavaScriptEngine.evalStringArray(null, configRow.getScriptValue()), configRow.getTypes().get(0), config);
        } else if (cachedDataFromDS.containsKey(dataSourceId) && this.isNoDSParameterInput(configRow)) {
            this.checkIsOneDatasourceOutput(configRow);
            this.addNewRecordsByDatasource(configRow, config, cachedDataFromDS.get(dataSourceId));
        } else {
            this.checkIsOneDatasourceOutput(configRow);
            StructureTableDto emptyDto = StructureTableDto.builder().build();
            CountedResult<Map<String, Object>> dataFromDS = this.dsService.execute(configRow.getDataSourceId(), this.buildDsInputParameters(emptyDto, configRow), null);
            this.addNewRecordsByDatasource(configRow, config, dataFromDS.getData());
        }
    }

    private void addNewRecordsByDatasource(ConfigurationRow configRow, Configuration config, List<Map<String, Object>> dataFromDS) {
        List<String> dataToDB = dataFromDS.stream().map(entry -> String.valueOf(entry.get(configRow.getDataSourceOutputParamIds().get(0)))).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.structureTableService.saveNewEntity(dataToDB, configRow.getTypes().get(0), config);
    }

    private Map<String, String> buildDsInputParameters(StructureTableDto structureTableDto, ConfigurationRow config) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<DataSourceInputParam> inputParameters = config.getDataSourceInputParams();
        if (inputParameters != null) {
            config.getDataSourceInputParams().stream().filter(dsInputParam -> dsInputParam != null && StringUtils.isNotBlank((CharSequence)dsInputParam.getParamInputId())).forEach(dsInputParam -> result.put(dsInputParam.getParamInputId(), String.valueOf(JavaScriptEngine.eval(structureTableDto, dsInputParam.getParamInputValue()))));
        }
        return result;
    }
}

