/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.service;

import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.cuf.plannedtask.administration.helper.UnusedUserManagement;
import com.suncode.plugin.organization.structure.db.enums.DataType;
import com.suncode.plugin.organization.structure.db.enums.LogStatus;
import com.suncode.plugin.organization.structure.dto.LogDto;
import com.suncode.plugin.organization.structure.dto.UserDto;
import com.suncode.plugin.organization.structure.service.ImportStructureService;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.database.DatabaseType;
import com.suncode.pwfl.database.NativeSqlUtils;
import com.suncode.pwfl.support.hibernate.criterion.Criterion;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteriaExecutor;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.exception.ServiceException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ImportStructureServiceImpl
implements ImportStructureService {
    private static final Logger log = LoggerFactory.getLogger(ImportStructureServiceImpl.class);
    @Autowired
    protected UserService userService;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private StructureService structService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserGroupFinder userGroupFinder;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    protected OrganizationalUnitFinder ouFinder;
    @Autowired
    private HibernateCriteriaExecutor hibernateCriteriaExecutor;

    @Override
    public LogDto importGroupOrUpdateDescription(String name, String desc) {
        if (!this.groupExist(name)) {
            this.createGroup(name, desc);
            log.debug("Group created:" + name);
            return new LogDto(LogStatus.CREATED, DataType.GROUP, name);
        }
        if (desc != null) {
            this.updateGroup(name, desc);
            log.debug("Updated the group:" + name);
            return new LogDto(LogStatus.UPDATED, DataType.GROUP, name);
        }
        log.debug("Skipped updated the group:" + name);
        return new LogDto(LogStatus.SKIPPED, DataType.GROUP, "Skipped update description for group: " + name);
    }

    @Override
    public LogDto createOrUpdateOrganizationUnit(String name, String symbol) {
        if (this.ouExist(symbol)) {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                this.updateOrgUnit(name, symbol);
                return new LogDto(LogStatus.UPDATED, DataType.OU, symbol);
            }
        } else {
            this.createOrgUnit(name, symbol);
            return new LogDto(LogStatus.CREATED, DataType.OU, symbol);
        }
        return null;
    }

    @Override
    public void importOrganizationUnitsAssociations(String symbol, String higherOrgUnit, String directorPosition) {
        OrganizationalUnit organizationalUnit = this.structService.getOrganizationalUnit(symbol, new String[0]);
        if (organizationalUnit == null) {
            return;
        }
        OrganizationalUnit higherOrganizationalUnit = this.structService.getOrganizationalUnit(higherOrgUnit, new String[0]);
        Position position = this.structService.getPosition(directorPosition, new String[0]);
        organizationalUnit.setDirectorPosition(position);
        organizationalUnit.setHigherOrganizationalUnit(higherOrganizationalUnit);
        this.structService.updateOrganizationalUnit(organizationalUnit);
    }

    @Override
    public List<LogDto> removeUnusedUsers(String unusedUsersHandleType, List<String> assignmentUsersList, List<User> unusedUsers) {
        LinkedList<LogDto> listLogDto = new LinkedList<LogDto>();
        String assignmentUsers = assignmentUsersList.stream().filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.joining(";"));
        UnusedUserManagement unusedUserManagement = new UnusedUserManagement(unusedUsers, this.userService);
        if ("DEACTIVATE".equalsIgnoreCase(unusedUsersHandleType)) {
            unusedUsers.forEach(user -> {
                unusedUserManagement.deactivateUser(user, assignmentUsers);
                listLogDto.add(new LogDto(LogStatus.REMOVED, DataType.USER, "Deactivated: " + user.getUserName()));
            });
            log.debug("Deactivated unused users: " + unusedUsers.size());
        } else {
            unusedUsers.forEach(user -> {
                unusedUserManagement.deleteUserIfPossible(user, assignmentUsers);
                listLogDto.add(new LogDto(LogStatus.REMOVED, DataType.USER, "Deleted: " + user.getUserName()));
            });
            log.debug("Deleted unused users: " + unusedUsers.size());
        }
        return listLogDto;
    }

    @Override
    public List<LogDto> removeUnusedOus(Set<String> nonRemovableOUSymbols) {
        LinkedList<LogDto> listLogDto = new LinkedList<LogDto>();
        List organizationalUnits = this.ouFinder.getAll(new String[]{"directorPosition"});
        Set<String> usedOuSymbols = this.findUsedOuSymbols();
        int removedCount = 0;
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (nonRemovableOUSymbols.contains(organizationalUnit.getSymbol()) || usedOuSymbols.contains(organizationalUnit.getSymbol())) continue;
            this.structService.deleteOrganizationalUnit(organizationalUnit.getSymbol());
            ++removedCount;
            listLogDto.add(new LogDto(LogStatus.REMOVED, DataType.OU, organizationalUnit.getSymbol()));
            log.debug("Organizational unit removed:" + organizationalUnit.getSymbol());
        }
        log.debug("Remove organizational units: " + removedCount);
        return listLogDto;
    }

    @Override
    public List<LogDto> removeUnusedGroups(Set<String> nonRemovableGroupNames) {
        String[] ignoredGroups = new String[]{"SharkGroup", "Administrators"};
        List userGroups = this.userGroupFinder.getAll(new String[]{"users"}).stream().filter(userGroup -> !ArrayUtils.contains((Object[])ignoredGroups, (Object)userGroup.getName())).collect(Collectors.toList());
        LinkedList<LogDto> listLogDto = new LinkedList<LogDto>();
        int removedCount = 0;
        for (UserGroup userGroup2 : userGroups) {
            if (nonRemovableGroupNames.contains(userGroup2.getName()) || !userGroup2.getUsers().isEmpty()) continue;
            this.userService.deleteGroup(userGroup2.getName());
            ++removedCount;
            listLogDto.add(new LogDto(LogStatus.REMOVED, DataType.GROUP, userGroup2.getName()));
            log.debug("Group removed: " + userGroup2.getName());
        }
        log.debug("Remove groups: " + removedCount);
        return listLogDto;
    }

    @Override
    public List<LogDto> removeUnusedPositions(Set<String> nonRemovePositionSymbols) {
        LinkedList<LogDto> listLogDto = new LinkedList<LogDto>();
        List positions = this.positionFinder.getAll(new String[]{"user"});
        int removedCount = 0;
        for (Position position : positions) {
            if (nonRemovePositionSymbols.contains(position.getSymbol()) || position.getUser() != null) continue;
            this.structService.deletePosition(position.getSymbol());
            ++removedCount;
            listLogDto.add(new LogDto(LogStatus.REMOVED, DataType.GROUP, position.getSymbol()));
        }
        log.debug("Remove position: " + removedCount);
        return listLogDto;
    }

    @Override
    public List<User> cacheUnusedUsers(Set<String> usersToImport) {
        boolean isNotInClauseAcceptable = !NativeSqlUtils.getDatabaseType().equals((Object)DatabaseType.MSSQL) || usersToImport.size() < NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        HibernateCriteria<User> criteria = isNotInClauseAcceptable ? this.createNotInCriteria(usersToImport, "userName", User.class) : HibernateCriteria.forClass(User.class);
        criteria.add(Restrictions.ne((String)"userName", (Object)"admin"));
        Arrays.stream(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.EMPTY_TASK_USER_NAME).split(";")).filter(userName -> !userName.equals("admin")).map(userName -> Restrictions.ne((String)"userName", (Object)userName)).forEach(arg_0 -> criteria.add(arg_0));
        criteria.join("positions");
        criteria.join("positions.higherPosition");
        criteria.join("positions.higherPosition.user");
        criteria.setDistinct(true);
        List users = this.hibernateCriteriaExecutor.findByCriteria(criteria);
        if (isNotInClauseAcceptable) {
            return users;
        }
        return users.stream().filter(user -> !usersToImport.contains(user.getUserName())).collect(Collectors.toList());
    }

    @Override
    public LogDto importPosition(String name, String symbol, String orgUnit, Set<String> roles) {
        if (this.positionExist(symbol)) {
            if (StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)orgUnit) || roles != null && !roles.isEmpty()) {
                this.updatePosition(name, symbol, orgUnit, roles);
                return new LogDto(LogStatus.UPDATED, DataType.POSITION, symbol);
            }
        } else {
            this.createPosition(name, symbol, orgUnit, roles);
            return new LogDto(LogStatus.CREATED, DataType.POSITION, symbol);
        }
        return null;
    }

    @Override
    public void importPositionsAssociations(String positionSymbol, String higherPositionSymbol) {
        if (this.positionExist(positionSymbol)) {
            Position position = this.structService.getPosition(positionSymbol, new String[0]);
            if (StringUtils.isBlank((CharSequence)higherPositionSymbol)) {
                position.setHigherPosition(null);
            } else {
                Position higherPosition = this.structService.getPosition(higherPositionSymbol, new String[0]);
                position.setHigherPosition(higherPosition);
            }
            this.structService.updatePosition(position);
        }
    }

    @Override
    public LogDto importUser(UserDto userDto, List<String> ignoredGroups) {
        if (this.userExist(userDto.getName())) {
            this.updateUser(userDto, ignoredGroups);
            this.activateUser(userDto.getName());
            log.debug("User imported: " + userDto.getName());
            return new LogDto(LogStatus.UPDATED, DataType.USER, userDto.getName());
        }
        this.createUser(userDto);
        log.debug("Created user: " + userDto.getName());
        return new LogDto(LogStatus.CREATED, DataType.USER, userDto.getName());
    }

    private void activateUser(String userName) {
        if (!this.userService.isActive(userName)) {
            this.userService.activateUser(userName);
            log.debug("User activation: " + userName);
        }
    }

    private void createUser(UserDto userDto) {
        User user = this.buildUser(userDto);
        ArrayList<String> groups = new ArrayList<String>(userDto.getGroupNames());
        this.userService.createUser(user, (String)groups.get(0));
        this.userService.addUserToGroups(userDto.getName(), groups.subList(1, groups.size()));
        this.assignPositionToUser(user, this.getPositions(new ArrayList<String>(userDto.getPositionSymbols())));
    }

    private User buildUser(UserDto userDto) {
        User user = new User(userDto.getName(), userDto.getPassword());
        user.setEmail(userDto.getEmail());
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.setNumber(userDto.getNumber());
        return user;
    }

    @Transactional
    public void assignPositionToUser(User user, List<Position> positions) {
        for (Position position : positions) {
            this.structService.addPositionToUser(user.getUserName(), position.getId());
        }
    }

    private boolean userExist(String userName) {
        return this.userService.getUser(userName, new String[0]) != null;
    }

    private void updateGroup(String name, String desc) {
        UserGroup userGroup = new UserGroup(name);
        userGroup.setDescription(desc);
        this.userService.updateGroup(userGroup);
    }

    private Position createPosition(String name, String symbol, String orgUnit, Set<String> roles) {
        Position position = new Position(name, symbol);
        OrganizationalUnit hou = this.structService.getOrganizationalUnit(orgUnit, new String[0]);
        position.setOrganizationalUnit(hou);
        this.structService.createPosition(position);
        List<Role> roleList = this.getRoles(roles);
        this.addRoles(position, roleList);
        return position;
    }

    private OrganizationalUnit createOrgUnit(String name, String symbol) {
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(name, symbol);
        this.structService.createOrganizationalUnit(organizationalUnit);
        return organizationalUnit;
    }

    private void createGroup(String name, String desc) {
        UserGroup userGroup = new UserGroup(name);
        userGroup.setDescription(desc);
        this.createGroup(userGroup);
    }

    private boolean groupExist(String name) {
        return this.userService.getGroup(name, new String[0]) != null;
    }

    private void updateOrgUnit(String name, String symbol) {
        OrganizationalUnit organizationalUnit = this.structService.getOrganizationalUnit(symbol, new String[0]);
        organizationalUnit.setName(name);
        this.structService.updateOrganizationalUnit(organizationalUnit);
    }

    private boolean ouExist(String symbol) {
        return this.structService.getOrganizationalUnit(symbol, new String[0]) != null;
    }

    private boolean positionExist(String symbol) {
        return this.structService.getPosition(symbol, new String[0]) != null;
    }

    private void createGroup(UserGroup userGroup) {
        this.userService.createGroup(userGroup);
    }

    private void updatePosition(String name, String symbol, String orgUnit, Set<String> roles) {
        Position position = this.structService.getPosition(symbol, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            position.setName(name);
        }
        OrganizationalUnit organizationalUnit = this.structService.getOrganizationalUnit(orgUnit, new String[0]);
        position.setOrganizationalUnit(organizationalUnit);
        this.structService.updatePosition(position);
        List<Role> roleList = this.getRoles(roles);
        this.addRoles(position, roleList);
        this.removePositionFromOtherRoles(position.getSymbol(), roleList);
    }

    private void updateUser(UserDto userDto, List<String> ignoredGroup) {
        User user = this.updateUserInfo(userDto);
        this.userService.addUserToGroups(userDto.getName(), new ArrayList<String>(userDto.getGroupNames()));
        this.removeUserFromOtherGroups(userDto.getName(), new ArrayList<String>(userDto.getGroupNames()), ignoredGroup);
        List<Position> pos = this.getPositions(new ArrayList<String>(userDto.getPositionSymbols()));
        this.assignPositionToUser(user, pos);
        this.removeUserFromOtherPositions(userDto.getName(), pos);
    }

    private User updateUserInfo(UserDto userDto) {
        User user = this.userService.getUser(userDto.getName(), new String[0]);
        user.setEmail(userDto.getEmail());
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.setNumber(userDto.getNumber());
        this.userService.updateUser(user);
        if (StringUtils.isNotBlank((CharSequence)userDto.getPassword())) {
            this.userService.changeUserPassword(userDto.getName(), userDto.getPassword());
        }
        return user;
    }

    private void removeUserFromOtherPositions(String userName, List<Position> positions) {
        User user = this.userFinder.findByUserName(userName, new String[]{"positions"});
        ArrayList toRemove = new ArrayList();
        user.getPositions().forEach(actual -> {
            if (this.isNoneMatch(positions, (Position)actual)) {
                toRemove.add(actual.getId());
            }
        });
        toRemove.forEach(id -> this.structService.detachPositionFromUser(id));
    }

    private boolean isNoneMatch(List<Position> positions, Position actual) {
        return positions.stream().noneMatch(ug -> actual.getSymbol().equals(ug.getSymbol()));
    }

    private void removeUserFromOtherGroups(String userName, List<String> groups, List<String> ignoredGroups) {
        User user = this.userFinder.findByUserName(userName, new String[]{"groups"});
        List toRemove = user.getGroups().stream().filter(actual -> !(groups != null && groups.contains(actual.getName()) || ignoredGroups != null && ignoredGroups.contains(actual.getName()))).map(UserGroup::getName).collect(Collectors.toList());
        this.userService.removeUserFromGroups(userName, toRemove);
    }

    private void removePositionFromOtherRoles(String symbol, List<Role> roleList) {
        Position position = this.structService.getPosition(symbol, new String[]{"roles"});
        List<Long> toRemove = position.getRoles().stream().map(Role::getId).filter(id -> roleList.stream().noneMatch(role -> id.equals(role.getId()))).collect(Collectors.toList());
        toRemove.forEach(id -> this.roleService.detachRole(position.getId(), id));
    }

    private List<Position> getPositions(List<String> symbols) {
        if (symbols == null || symbols.isEmpty()) {
            return new ArrayList<Position>();
        }
        return symbols.stream().map(symbol -> this.structService.getPosition(symbol, new String[0])).collect(Collectors.toList());
    }

    private List<Role> getRoles(Set<String> roleSet) {
        if (roleSet == null || roleSet.isEmpty()) {
            return new ArrayList<Role>();
        }
        return roleSet.stream().map(this::getRole).collect(Collectors.toList());
    }

    private Role getRole(String role) {
        String roleId;
        String packageId;
        String[] tab = role.split(":");
        if (tab.length != 3 && tab.length != 2) {
            throw new ServiceException("Invalid role id format " + role + ". The format should be: packageId:processDefId:roleId");
        }
        String processDefId = null;
        if (tab.length == 2) {
            log.debug("Package role");
            packageId = tab[0];
            roleId = tab[1];
        } else {
            log.debug("Process Role");
            packageId = tab[0];
            processDefId = tab[1];
            roleId = tab[2];
        }
        log.debug("PackageId: " + packageId);
        log.debug("ProcessDefId: " + processDefId);
        log.debug("RoleId: " + roleId);
        return this.roleService.getRole(packageId, processDefId, roleId);
    }

    private void addRoles(Position position, List<Role> roles) {
        this.roleService.detachAllRoles(position.getId());
        roles.forEach(role -> this.roleService.addRole(position.getId(), role.getId()));
    }

    private <T> HibernateCriteria<T> createNotInCriteria(Set<String> elements, String criteria, Class<T> clazz) {
        HibernateCriteria hibernateCriteria = HibernateCriteria.forClass(clazz);
        List parts = Lists.partition((List)Lists.newArrayList(elements), (int)NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters());
        parts.stream().map(part -> Restrictions.not((Criterion)Restrictions.in((String)criteria, (Collection)part))).forEach(arg_0 -> ((HibernateCriteria)hibernateCriteria).add(arg_0));
        return hibernateCriteria;
    }

    private Set<String> findUsedOuSymbols() {
        final HashSet<String> ouSymbols = new HashSet<String>();
        PlatformTransactionManager hibernateTransactionManager = TransactionManagerFactory.getHibernateTransactionManager();
        TransactionTemplate template = new TransactionTemplate(hibernateTransactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ImportStructureServiceImpl.this.positionFinder.getAll(new String[]{"organizationalUnit", "directoredUnits"}).stream().filter(Objects::nonNull).forEach(pos -> {
                    ImportStructureServiceImpl.this.recurrenceSearchOU(pos.getOrganizationalUnit(), ouSymbols);
                    for (OrganizationalUnit dou : pos.getDirectoredUnits()) {
                        ImportStructureServiceImpl.this.recurrenceSearchOU(dou, ouSymbols);
                    }
                });
            }
        });
        return ouSymbols;
    }

    private void recurrenceSearchOU(OrganizationalUnit organizationalUnit, Set<String> ouSymbols) {
        if (organizationalUnit == null || ouSymbols.contains(organizationalUnit.getSymbol())) {
            return;
        }
        ouSymbols.add(organizationalUnit.getSymbol());
        OrganizationalUnit orgUnit = (OrganizationalUnit)this.ouFinder.get((Serializable)organizationalUnit.getId(), new String[]{"higherOrganizationalUnit"});
        this.recurrenceSearchOU(orgUnit.getHigherOrganizationalUnit(), ouSymbols);
    }
}

