/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.dto;

import com.suncode.plugin.organization.structure.dto.PositionDto;
import com.suncode.plugin.organization.structure.dto.StructureTableDto;
import com.suncode.plugin.organization.structure.dto.UserDto;
import com.suncode.pwfl.administration.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class StructureDataDto {
    private Set<String> uniqueGroupNames = new HashSet<String>();
    private Set<String> uniqueOuSymbols = new HashSet<String>();
    private Set<String> uniquePositionSymbols = new HashSet<String>();
    private Set<String> uniqueUserNames = new HashSet<String>();
    private List<User> cachedUnusedUsers = new ArrayList<User>();
    private Map<String, String> organizationUnitsMap = new HashMap<String, String>();
    private Set<String> uniqueUsersToImport = new HashSet<String>();
    private Map<String, UserDto> usersMap = new HashMap<String, UserDto>();
    private Map<String, PositionDto> positionsMap = new HashMap<String, PositionDto>();
    private Map<String, String> groupDescriptionsMap = new HashMap<String, String>();
    private List<String> ignoredGroups = new ArrayList<String>();

    public StructureDataDto(List<StructureTableDto> rawStructureData, List<String> defaultGroups, List<String> ignoredGroups) {
        this.ignoredGroups = ignoredGroups;
        this.buildUniqueUsersToImport(rawStructureData);
        this.buildUserDtoMap(rawStructureData);
        this.buildUniqueGroupNames(rawStructureData, defaultGroups, ignoredGroups);
        this.buildGroupDescriptionMap(rawStructureData);
        this.buildOrganizationUnitsMap(rawStructureData);
        this.buildPositionDtoMap(rawStructureData);
    }

    private void buildOrganizationUnitsMap(List<StructureTableDto> data) {
        data.stream().filter(dto -> dto.getOrganizationUnitSymbols() != null).forEach(dto -> {
            List<String> ouSymbolsFromDto = dto.getOrganizationUnitSymbols();
            List<String> ouNamesFromDto = dto.getOrganizationUnitNames();
            for (int index = 0; index < ouSymbolsFromDto.size(); ++index) {
                this.addToOrganizationUnitsMapAndSymbols(ouSymbolsFromDto, ouNamesFromDto, index);
            }
        });
        data.stream().filter(dto -> dto.getHigherOrganizationUnitSymbols() != null).forEach(dto -> {
            List<String> higherOUSymbolsFromDto = dto.getHigherOrganizationUnitSymbols();
            List<String> higherOUNamesFromDto = dto.getHigherOrganizationUnitNames();
            for (int index = 0; index < higherOUSymbolsFromDto.size(); ++index) {
                this.addToOrganizationUnitsMapAndSymbols(higherOUSymbolsFromDto, higherOUNamesFromDto, index);
            }
        });
    }

    private void addToOrganizationUnitsMapAndSymbols(List<String> ouSymbolsFromDto, List<String> ouNamesFromDto, int index) {
        String symbol = ouSymbolsFromDto.get(index);
        if (StringUtils.isBlank((CharSequence)symbol) || this.organizationUnitsMap.containsKey(symbol)) {
            return;
        }
        String name = ouNamesFromDto == null || index >= ouNamesFromDto.size() ? "" : ouNamesFromDto.get(index);
        this.organizationUnitsMap.put(symbol, name);
        this.uniqueOuSymbols.add(symbol);
    }

    private void buildUniqueGroupNames(List<StructureTableDto> rawStructureData, List<String> defaultGroups, List<String> ignoredGroups) {
        Set groupNames = rawStructureData.stream().map(StructureTableDto::getGroupNames).filter(Objects::nonNull).flatMap(Collection::stream).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        groupNames.addAll(defaultGroups);
        groupNames.addAll(ignoredGroups);
        this.uniqueGroupNames = groupNames.stream().filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toSet());
    }

    private void buildGroupDescriptionMap(List<StructureTableDto> rawStructureData) {
        rawStructureData.stream().filter(dto -> dto.getGroupNames() != null && !dto.getGroupNames().isEmpty()).forEach(dto -> {
            List<String> groupNamesFromDto = dto.getGroupNames();
            List<String> groupDescriptionsFromDto = dto.getGroupDescriptions();
            if (dto.getGroupDescriptions() != null && dto.getGroupDescriptions().isEmpty()) {
                return;
            }
            if (groupNamesFromDto.size() != groupDescriptionsFromDto.size()) {
                throw new IllegalArgumentException("GroupNames and GroupDescription has different length. For id: " + dto.getId());
            }
            Map<String, String> collect = IntStream.range(0, groupNamesFromDto.size()).boxed().filter(index -> StringUtils.isNotBlank((CharSequence)((CharSequence)groupNamesFromDto.get((int)index)))).collect(Collectors.toMap(groupNamesFromDto::get, groupDescriptionsFromDto::get, (existing, replacement) -> existing));
            this.groupDescriptionsMap.putAll(collect);
        });
    }

    private void buildUniqueUsersToImport(List<StructureTableDto> rawStructureData) {
        this.uniqueUsersToImport = rawStructureData.stream().filter(dto -> StringUtils.isNotBlank((CharSequence)dto.getUserLogin())).map(this::prepareUserLogin).collect(Collectors.toSet());
    }

    public void addUserName(String userName) {
        this.uniqueUserNames.add(userName);
    }

    private void buildPositionDtoMap(List<StructureTableDto> rawStructureData) {
        rawStructureData.stream().filter(dto -> dto.getPositionSymbols() != null && !dto.getPositionSymbols().isEmpty()).forEach(dto -> {
            List<String> positionSymbolsFromDto = dto.getPositionSymbols();
            List<String> positionNamesFromDto = dto.getPositionNames();
            List<String> rolesFromDto = dto.getRoles();
            List<String> higherPositionSymbolsFromDto = dto.getHigherPositionSymbols();
            List<String> ouSymbolsFromDto = dto.getOrganizationUnitSymbols();
            List<String> directorySymbolsFromDto = dto.getDirectoryPositionSymbols();
            List<String> higherOUSymbolsFromDto = dto.getHigherOrganizationUnitSymbols();
            for (int index = 0; index < positionSymbolsFromDto.size(); ++index) {
                PositionDto positionDto;
                String positionSymbol = positionSymbolsFromDto.get(index);
                if (StringUtils.isBlank((CharSequence)positionSymbol)) continue;
                if (!this.positionsMap.containsKey(positionSymbol)) {
                    positionDto = new PositionDto();
                    positionDto.setSymbol(positionSymbol);
                    this.positionsMap.put(positionSymbol, positionDto);
                }
                positionDto = this.positionsMap.get(positionSymbol);
                if (positionNamesFromDto != null && positionNamesFromDto.size() > index && StringUtils.isBlank((CharSequence)positionDto.getName())) {
                    positionDto.setName(positionNamesFromDto.get(index));
                }
                if (higherPositionSymbolsFromDto != null && higherPositionSymbolsFromDto.size() > index && StringUtils.isBlank((CharSequence)positionDto.getHigherPositionSymbol())) {
                    positionDto.setHigherPositionSymbol(higherPositionSymbolsFromDto.get(index));
                }
                if (ouSymbolsFromDto != null && ouSymbolsFromDto.size() > index && StringUtils.isBlank((CharSequence)positionDto.getOrgUnitSymbol())) {
                    positionDto.setOrgUnitSymbol(ouSymbolsFromDto.get(index));
                }
                if (directorySymbolsFromDto != null && directorySymbolsFromDto.size() > index && StringUtils.isBlank((CharSequence)positionDto.getDirectorySymbol())) {
                    positionDto.setDirectorySymbol(directorySymbolsFromDto.get(index));
                }
                if (higherOUSymbolsFromDto != null && higherOUSymbolsFromDto.size() > index && StringUtils.isBlank((CharSequence)positionDto.getHigherOUSymbol())) {
                    positionDto.setHigherOUSymbol(higherOUSymbolsFromDto.get(index));
                }
                if (rolesFromDto != null) {
                    positionDto.addRoles(rolesFromDto);
                }
                this.positionsMap.put(positionSymbol, positionDto);
                this.uniquePositionSymbols.add(positionSymbol);
            }
        });
    }

    private void buildUserDtoMap(List<StructureTableDto> data) {
        data.stream().filter(dto -> StringUtils.isNotBlank((CharSequence)dto.getUserLogin())).forEach(dto -> {
            UserDto userDto;
            String userName = this.prepareUserLogin((StructureTableDto)dto);
            if (!this.usersMap.containsKey(userName)) {
                userDto = new UserDto();
                userDto.setName(userName);
                this.usersMap.put(userName, userDto);
            }
            if (StringUtils.isBlank((CharSequence)(userDto = this.usersMap.get(userName)).getFirstName())) {
                userDto.setFirstName(dto.getUserFirstName());
            }
            if (StringUtils.isBlank((CharSequence)userDto.getLastName())) {
                userDto.setLastName(dto.getUserLastName());
            }
            if (StringUtils.isBlank((CharSequence)userDto.getEmail())) {
                userDto.setEmail(dto.getUserEmail());
            }
            if (StringUtils.isBlank((CharSequence)userDto.getNumber())) {
                userDto.setNumber(dto.getUserNumber());
            }
            if (StringUtils.isBlank((CharSequence)userDto.getPassword())) {
                userDto.setPassword(Objects.toString(dto.getUserPassword(), ""));
            }
            userDto.addGroupName(dto.getGroupNames());
            userDto.addPositionSymbols(dto.getPositionSymbols());
            this.usersMap.put(userName, userDto);
        });
    }

    private String prepareUserLogin(StructureTableDto dto) {
        String domain = StringUtils.isBlank((CharSequence)dto.getUserDomain()) ? "" : dto.getUserDomain() + "/";
        return domain + dto.getUserLogin().toLowerCase();
    }

    public Set<String> getUniqueGroupNames() {
        return this.uniqueGroupNames;
    }

    public Set<String> getUniqueOuSymbols() {
        return this.uniqueOuSymbols;
    }

    public Set<String> getUniquePositionSymbols() {
        return this.uniquePositionSymbols;
    }

    public Set<String> getUniqueUserNames() {
        return this.uniqueUserNames;
    }

    public List<User> getCachedUnusedUsers() {
        return this.cachedUnusedUsers;
    }

    public Map<String, String> getOrganizationUnitsMap() {
        return this.organizationUnitsMap;
    }

    public Set<String> getUniqueUsersToImport() {
        return this.uniqueUsersToImport;
    }

    public Map<String, UserDto> getUsersMap() {
        return this.usersMap;
    }

    public Map<String, PositionDto> getPositionsMap() {
        return this.positionsMap;
    }

    public Map<String, String> getGroupDescriptionsMap() {
        return this.groupDescriptionsMap;
    }

    public List<String> getIgnoredGroups() {
        return this.ignoredGroups;
    }

    public void setUniqueGroupNames(Set<String> uniqueGroupNames) {
        this.uniqueGroupNames = uniqueGroupNames;
    }

    public void setUniqueOuSymbols(Set<String> uniqueOuSymbols) {
        this.uniqueOuSymbols = uniqueOuSymbols;
    }

    public void setUniquePositionSymbols(Set<String> uniquePositionSymbols) {
        this.uniquePositionSymbols = uniquePositionSymbols;
    }

    public void setUniqueUserNames(Set<String> uniqueUserNames) {
        this.uniqueUserNames = uniqueUserNames;
    }

    public void setCachedUnusedUsers(List<User> cachedUnusedUsers) {
        this.cachedUnusedUsers = cachedUnusedUsers;
    }

    public void setOrganizationUnitsMap(Map<String, String> organizationUnitsMap) {
        this.organizationUnitsMap = organizationUnitsMap;
    }

    public void setUniqueUsersToImport(Set<String> uniqueUsersToImport) {
        this.uniqueUsersToImport = uniqueUsersToImport;
    }

    public void setUsersMap(Map<String, UserDto> usersMap) {
        this.usersMap = usersMap;
    }

    public void setPositionsMap(Map<String, PositionDto> positionsMap) {
        this.positionsMap = positionsMap;
    }

    public void setGroupDescriptionsMap(Map<String, String> groupDescriptionsMap) {
        this.groupDescriptionsMap = groupDescriptionsMap;
    }

    public void setIgnoredGroups(List<String> ignoredGroups) {
        this.ignoredGroups = ignoredGroups;
    }
}

