/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.config.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.organization.structure.config.adapters.UppercaseEnumAdapter;
import com.suncode.plugin.organization.structure.config.dtos.StructureConfigurationDto;
import com.suncode.plugin.organization.structure.config.enums.UserDetachType;
import com.suncode.plugin.organization.structure.config.services.ConfigurationService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(UserDetachType.class, (Object)new UppercaseEnumAdapter()).create();
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StructureConfigurationDto readServerConfiguration(String configId) {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);){
            StructureConfigurationDto structureConfigurationDto = (StructureConfigurationDto)GSON.fromJson(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), StructureConfigurationDto.class);
            return structureConfigurationDto;
        }
    }

    @Override
    public boolean doesConfigurationExist(String configId) {
        return this.configurationFileService.doesFileExist(this.plugin.getKey(), configId);
    }
}

