/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.task;

import com.suncode.plugin.organization.structure.category.Categories;
import com.suncode.plugin.organization.structure.config.dtos.StructureConfigurationDto;
import com.suncode.plugin.organization.structure.config.dtos.assertions.ConfigAssertions;
import com.suncode.plugin.organization.structure.config.services.ConfigurationService;
import com.suncode.plugin.organization.structure.db.enums.DataType;
import com.suncode.plugin.organization.structure.db.servicies.StructureLogService;
import com.suncode.plugin.organization.structure.db.servicies.StructureTableService;
import com.suncode.plugin.organization.structure.dto.LogDto;
import com.suncode.plugin.organization.structure.exception.TaskCanceledException;
import com.suncode.plugin.organization.structure.exception.utils.ExceptionTool;
import com.suncode.plugin.organization.structure.service.StructureService;
import com.suncode.plugin.organization.structure.service.StructureTemplateService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class ImportOrganizationStructure {
    @Autowired
    private StructureTableService structureTableService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private StructureTemplateService structureTemplateService;
    @Autowired
    private StructureService importStructureService;
    @Autowired
    private StructureLogService structureLogService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("organization.structure.import.scheduledtask")).name("organization.structure.import.name")).description("organization.structure.import.desc")).category(new Category[]{Categories.PLUS_ORGANIZATION_STRUCTURE_MANAGER})).cancelable().parameter().id("configIds").name("organization.structure.import.configIds.name").description("organization.structure.import.configIds.desc").type((Type)Types.STRING).create();
    }

    public String execute(@Param(value="configIds") String configIds, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancellation, Logger taskLog) throws Exception {
        try {
            taskLog.error((Object)("Start task: " + scheduledTaskInfo.getName()));
            this.structureLogService.deleteAll();
            taskLog.debug((Object)"Clear table: plus_osm_structure_log");
            ArrayList configIdsArrayList = Arrays.stream(configIds.split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(ArrayList::new));
            for (String configId : configIdsArrayList) {
                if (this.configService.doesConfigurationExist(configId)) continue;
                throw new Exception("Configuration \"" + configId + "\" does not exist");
            }
            for (String configId : configIdsArrayList) {
                ExceptionTool.checkTaskCancellation(cancellation);
                this.structureTableService.deleteAll();
                taskLog.debug((Object)"Clear table: plus_osm_structure_template");
                ExceptionTool.checkTaskCancellation(cancellation);
                taskLog.debug((Object)("Read configuration from pcm: " + configId + " rows "));
                StructureConfigurationDto configDto = this.configService.readServerConfiguration(configId);
                ConfigAssertions.valid(configDto);
                ExceptionTool.checkTaskCancellation(cancellation);
                taskLog.debug((Object)"Create raw Structure data in table: plus_osm_structure_template");
                this.structureTemplateService.createStructureTemplate(configDto, cancellation);
                ExceptionTool.checkTaskCancellation(cancellation);
                taskLog.debug((Object)"Import structure to system");
                this.importStructureService.importStructure(configDto.getConfig(), cancellation);
            }
            CountedResult<LogDto> errors = this.structureLogService.getErrors();
            if (errors.getTotal() > 0L) {
                this.displayImportErrorsLog(taskLog, errors);
                taskLog.error((Object)("Success task: " + scheduledTaskInfo.getName() + "with errors: " + errors.getTotal()));
                return "Success imported structure with errors: " + errors.getTotal();
            }
            taskLog.error((Object)("Success task: " + scheduledTaskInfo.getName()));
            return "Success imported structure";
        }
        catch (TaskCanceledException cancelEx) {
            this.structureTableService.deleteAll();
            taskLog.debug((Object)"Clear table: plus_osm_structure_template");
            CountedResult<LogDto> errors = this.structureLogService.getErrors();
            if (errors.getTotal() > 0L) {
                this.displayImportErrorsLog(taskLog, errors);
            }
            taskLog.debug((Object)("Cancel task: " + scheduledTaskInfo.getName()));
            this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.TASK, new Exception("Cancel task: " + scheduledTaskInfo.getName(), cancelEx)));
            return "Cancelled";
        }
        catch (Exception e) {
            CountedResult<LogDto> errors = this.structureLogService.getErrors();
            if (errors.getTotal() > 0L) {
                this.displayImportErrorsLog(taskLog, errors);
            }
            taskLog.error((Object)("Error task: " + scheduledTaskInfo.getName()));
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.TASK, e));
            throw e;
        }
    }

    private void displayImportErrorsLog(Logger taskLog, CountedResult<LogDto> errors) {
        errors.getData().forEach(log -> {
            StringBuilder sb = new StringBuilder("\nERROR:\n");
            sb.append("Time:\t").append(log.getDateTime()).append("\n");
            sb.append("DataType:\t").append(log.getType()).append("\n");
            sb.append("Info:\n").append(log.getInfo()).append("\n");
            taskLog.debug((Object)sb.toString());
        });
    }
}

