/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.eval;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.suncode.plugin.organization.structure.dto.StructureTableDto;
import com.suncode.plugin.organization.structure.eval.exception.JavaScriptEngineException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.json.JSONObject;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptEngine {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptEngine.class);
    private static final ScriptEngine JS_ENGINE = new RhinoScriptEngineFactory().getScriptEngine();
    private static final ClassLoader CLASS_LOADER = JavaScriptEngine.class.getClassLoader();
    private static final CompiledScript INIT_JS;
    private static final Gson GSON;
    private static final LoadingCache<String, CompiledScript> compiledScriptsCache;

    private JavaScriptEngine() {
    }

    public static synchronized Object eval(StructureTableDto data, Map<String, Object> datasource, String callback) {
        try {
            SimpleScriptContext context = new SimpleScriptContext();
            Bindings bindings = JS_ENGINE.createBindings();
            bindings.put("data", (Object)JavaScriptEngine.createSafeDataMap(data));
            bindings.put("datasource", (Object)JavaScriptEngine.createSafeMap(datasource));
            context.setBindings(bindings, 100);
            INIT_JS.eval(context);
            CompiledScript compiledCallbackScript = (CompiledScript)compiledScriptsCache.get((Object)callback);
            return compiledCallbackScript.eval(context);
        }
        catch (Exception e) {
            throw new JavaScriptEngineException(data, datasource, callback, e);
        }
    }

    private static Map<String, Object> createSafeDataMap(StructureTableDto data) {
        if (data == null) {
            return new HashMap<String, Object>();
        }
        try {
            String json = GSON.toJson((Object)data);
            Map dataMap = (Map)GSON.fromJson(json, Map.class);
            return JavaScriptEngine.createSafeMap(dataMap);
        }
        catch (Exception e) {
            log.warn("Failed to convert StructureTableDto to safe map, using empty map", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    private static Map<String, Object> createSafeMap(Map<String, Object> originalMap) {
        if (originalMap == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> safeMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : originalMap.entrySet()) {
            Object value = entry.getValue();
            safeMap.put(entry.getKey(), value == null ? "" : value);
        }
        return safeMap;
    }

    public static Object eval(StructureTableDto data, String callback) {
        log.trace("Evaluate JavaScript");
        return JavaScriptEngine.eval(data, new HashMap<String, Object>(), callback);
    }

    public static synchronized List<String> evalStringArray(StructureTableDto data, String callback) {
        try {
            log.trace("Evaluate String Array JavaScript");
            SimpleScriptContext context = new SimpleScriptContext();
            if (data != null) {
                Bindings bindings = JS_ENGINE.createBindings();
                bindings.put("data", (Object)JavaScriptEngine.createSafeDataMap(data));
                context.setBindings(bindings, 100);
                INIT_JS.eval(context);
            }
            CompiledScript compiledCallbackScript = (CompiledScript)compiledScriptsCache.get((Object)callback);
            ArrayList<String> result = new ArrayList<String>();
            Object jsResult = compiledCallbackScript.eval(context);
            if (jsResult == null) {
                return result;
            }
            if (jsResult instanceof List) {
                result.addAll((List)jsResult);
            } else if (jsResult instanceof String[]) {
                result.addAll(Arrays.asList((String[])jsResult));
            } else {
                JSONObject jsonObj = new JSONObject(GSON.toJson(jsResult));
                Iterator iterator = jsonObj.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    result.add(jsonObj.get(key).toString());
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new JavaScriptEngineException(data, null, callback, e);
        }
    }

    private static String initFunctions() {
        URL url = CLASS_LOADER.getResource("scripts/js_engine/init.js");
        return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
    }

    static {
        GSON = new Gson();
        compiledScriptsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, CompiledScript>(){

            @Nonnull
            public CompiledScript load(@Nonnull String script) throws JavaScriptEngineException {
                try {
                    return ((Compilable)((Object)JS_ENGINE)).compile(script);
                }
                catch (ScriptException e) {
                    throw new JavaScriptEngineException("Failed to compile script", e);
                }
            }
        });
        try {
            INIT_JS = ((Compilable)((Object)JS_ENGINE)).compile(JavaScriptEngine.initFunctions());
        }
        catch (ScriptException e) {
            throw new JavaScriptEngineException("Failed to compile init functions", e);
        }
    }
}

