/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.db.servicies;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.organization.structure.config.dtos.Configuration;
import com.suncode.plugin.organization.structure.config.enums.StructureConfigType;
import com.suncode.plugin.organization.structure.db.daos.StructureTableDao;
import com.suncode.plugin.organization.structure.db.entity.StructureTemplateTable;
import com.suncode.plugin.organization.structure.db.servicies.StructureTableService;
import com.suncode.plugin.organization.structure.dto.StructureTableDto;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StructureTableServiceImpl
extends EditableServiceImpl<StructureTemplateTable, Long, StructureTableDao>
implements StructureTableService {
    private static final Logger log = LoggerFactory.getLogger(StructureTableServiceImpl.class);
    private static final Gson GSON = new Gson();

    @Autowired
    public void setDao(StructureTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void deleteAll() {
        try {
            List structureTemplateTables = ((StructureTableDao)this.dao).getAll(new String[0]);
            for (StructureTemplateTable structureTemplateTable : structureTemplateTables) {
                ((StructureTableDao)this.dao).delete(structureTemplateTable);
            }
        }
        catch (Exception e) {
            log.debug("Cannot delete table: plus_osm_structure_template error: " + e.getMessage());
        }
    }

    @Override
    public void saveNewEntity(List<String> values, StructureConfigType type, Configuration config) {
        long startUpdate = DateTime.now().getMillis();
        log.debug("Create new records in  plus_osm_structure_template Numbers of rows: " + values.size());
        values.stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).forEach(value -> {
            Long cfr_ignored_0 = (Long)((StructureTableDao)this.dao).save(this.createEntity((String)value, type, config));
        });
        log.debug("Created time: " + (DateTime.now().getMillis() - startUpdate) + " [ms]");
    }

    @Override
    public void updateEntities(List<StructureTableDto> structureTableDtoList) {
        long startUpdate = DateTime.now().getMillis();
        log.debug("Update plus_osm_structure_template Numbers of rows: " + structureTableDtoList.size());
        structureTableDtoList.forEach(dto -> ((StructureTableDao)this.dao).update(this.buildStructureTemplateTable((StructureTableDto)dto)));
        log.debug("Updated time: " + (DateTime.now().getMillis() - startUpdate) + " [ms]");
    }

    private StructureTemplateTable createEntity(String value, StructureConfigType type, Configuration config) {
        return this.updateEntity(value, type, new StructureTemplateTable(), config);
    }

    @Override
    public List<StructureTableDto> getAll() {
        return ((StructureTableDao)this.dao).getAll(new String[0]).stream().map(this::buildStructureTableDto).sorted(Comparator.comparing(StructureTableDto::getId)).collect(Collectors.toList());
    }

    private StructureTableDto buildStructureTableDto(StructureTemplateTable entity) {
        return StructureTableDto.builder().id(entity.getId()).bufor1(entity.getBufor1()).bufor2(entity.getBufor2()).bufor3(entity.getBufor3()).bufor4(entity.getBufor4()).bufor5(entity.getBufor5()).bufor6(this.fromJson(entity.getJsonBufor6Tab())).bufor7(this.fromJson(entity.getJsonBufor7Tab())).bufor8(this.fromJson(entity.getJsonBufor8Tab())).directoryPositionSymbols(this.fromJson(entity.getJsonDirectoryPositionSymbols())).groupNames(this.fromJson(entity.getJsonGroupNames())).groupDescriptions(this.fromJson(entity.getJsonGroupDescriptions())).higherOrganizationUnitSymbols(this.fromJson(entity.getJsonHigherOrganizationUnitSymbols())).higherOrganizationUnitNames(this.fromJson(entity.getJsonHigherOrganizationUnitNames())).higherPositionSymbols(this.fromJson(entity.getJsonHigherPositionSymbols())).organizationUnitSymbols(this.fromJson(entity.getJsonOrganizationUnitSymbols())).organizationUnitNames(this.fromJson(entity.getJsonOrganizationUnitNames())).positionSymbols(this.fromJson(entity.getJsonPositionSymbols())).positionNames(this.fromJson(entity.getJsonPositionNames())).roles(this.fromJson(entity.getJsonRoles())).userDomain(entity.getUserDomain()).userEmail(entity.getUserEmail()).userFirstName(entity.getUserFirstName()).userLastName(entity.getUserLastName()).userLogin(entity.getUserLogin()).userNumber(entity.getUserNumber()).userPassword(entity.getUserPassword()).build();
    }

    private StructureTemplateTable buildStructureTemplateTable(StructureTableDto dto) {
        StructureTemplateTable entity = new StructureTemplateTable();
        entity.setId(dto.getId());
        entity.setBufor1(dto.getBufor1());
        entity.setBufor2(dto.getBufor2());
        entity.setBufor3(dto.getBufor3());
        entity.setBufor4(dto.getBufor4());
        entity.setBufor5(dto.getBufor5());
        entity.setJsonBufor6Tab(GSON.toJson(dto.getBufor6()));
        entity.setJsonBufor7Tab(GSON.toJson(dto.getBufor7()));
        entity.setJsonBufor8Tab(GSON.toJson(dto.getBufor8()));
        entity.setJsonDirectoryPositionSymbols(GSON.toJson(dto.getDirectoryPositionSymbols()));
        entity.setJsonGroupNames(GSON.toJson(dto.getGroupNames()));
        entity.setJsonGroupDescriptions(GSON.toJson(dto.getGroupDescriptions()));
        entity.setJsonHigherOrganizationUnitSymbols(GSON.toJson(dto.getHigherOrganizationUnitSymbols()));
        entity.setJsonHigherOrganizationUnitNames(GSON.toJson(dto.getHigherOrganizationUnitNames()));
        entity.setJsonHigherPositionSymbols(GSON.toJson(dto.getHigherPositionSymbols()));
        entity.setJsonOrganizationUnitSymbols(GSON.toJson(dto.getOrganizationUnitSymbols()));
        entity.setJsonOrganizationUnitNames(GSON.toJson(dto.getOrganizationUnitNames()));
        entity.setJsonPositionSymbols(GSON.toJson(dto.getPositionSymbols()));
        entity.setJsonPositionNames(GSON.toJson(dto.getPositionNames()));
        entity.setJsonRoles(GSON.toJson(dto.getRoles()));
        entity.setUserDomain(dto.getUserDomain());
        entity.setUserEmail(dto.getUserEmail());
        entity.setUserFirstName(dto.getUserFirstName());
        entity.setUserLastName(dto.getUserLastName());
        entity.setUserLogin(dto.getUserLogin());
        entity.setUserNumber(dto.getUserNumber());
        entity.setUserPassword(dto.getUserPassword());
        return entity;
    }

    private List<String> fromJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<String>();
        }
        return (List)GSON.fromJson(json, new TypeToken<List<String>>(){}.getType());
    }

    private StructureTemplateTable updateEntity(String value, StructureConfigType type, StructureTemplateTable entity, Configuration config) {
        switch (type) {
            case BUFOR1: {
                if (!StringUtils.isBlank((CharSequence)entity.getBufor1())) break;
                entity.setBufor1(value);
                break;
            }
            case BUFOR2: {
                if (!StringUtils.isBlank((CharSequence)entity.getBufor2())) break;
                entity.setBufor2(value);
                break;
            }
            case BUFOR3: {
                if (!StringUtils.isBlank((CharSequence)entity.getBufor3())) break;
                entity.setBufor3(value);
                break;
            }
            case BUFOR4: {
                if (!StringUtils.isBlank((CharSequence)entity.getBufor4())) break;
                entity.setBufor4(value);
                break;
            }
            case BUFOR5: {
                if (!StringUtils.isBlank((CharSequence)entity.getBufor5())) break;
                entity.setBufor5(value);
                break;
            }
            case BUFOR6_TAB: {
                entity.setJsonBufor6Tab(this.addToJsonList(value, entity.getJsonBufor6Tab()));
                break;
            }
            case BUFOR7_TAB: {
                entity.setJsonBufor7Tab(this.addToJsonList(value, entity.getJsonBufor7Tab()));
                break;
            }
            case BUFOR8_TAB: {
                entity.setJsonBufor8Tab(this.addToJsonList(value, entity.getJsonBufor8Tab()));
                break;
            }
            case DIRECTOR_POSITION_SYMBOL_TAB: {
                entity.setJsonDirectoryPositionSymbols(this.addToJsonList(value, entity.getJsonDirectoryPositionSymbols()));
                break;
            }
            case DOMAIN: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserDomain())) break;
                entity.setUserDomain(value);
                break;
            }
            case GROUP_NAME_TAB: {
                entity.setJsonGroupNames(this.addToJsonList(value, entity.getJsonGroupNames(), config.getSplitGroupNamesCharacter()));
                break;
            }
            case GROUP_DESCRIPTION_TAB: {
                entity.setJsonGroupDescriptions(this.addToJsonList(value, entity.getJsonGroupDescriptions(), config.getSplitGroupNamesCharacter()));
                break;
            }
            case HIGHER_ORGANIZATION_UNIT_SYMBOL_TAB: {
                entity.setJsonHigherOrganizationUnitSymbols(this.addToJsonList(value, entity.getJsonHigherOrganizationUnitSymbols()));
                break;
            }
            case HIGHER_ORGANIZATION_UNIT_NAME_TAB: {
                entity.setJsonHigherOrganizationUnitNames(this.addToJsonList(value, entity.getJsonHigherOrganizationUnitNames()));
                break;
            }
            case HIGHER_POSITION_SYMBOL_TAB: {
                entity.setJsonHigherPositionSymbols(this.addToJsonList(value, entity.getJsonHigherPositionSymbols()));
                break;
            }
            case ORGANIZATION_UNIT_NAME_TAB: {
                entity.setJsonOrganizationUnitNames(this.addToJsonList(value, entity.getJsonOrganizationUnitNames()));
                break;
            }
            case ORGANIZATION_UNIT_SYMBOL_TAB: {
                entity.setJsonOrganizationUnitSymbols(this.addToJsonList(value, entity.getJsonOrganizationUnitSymbols()));
                break;
            }
            case POSITION_NAME_TAB: {
                entity.setJsonPositionNames(this.addToJsonList(value, entity.getJsonPositionNames()));
                break;
            }
            case POSITION_SYMBOL_TAB: {
                entity.setJsonPositionSymbols(this.addToJsonList(value, entity.getJsonPositionSymbols()));
                break;
            }
            case ROLE_TAB: {
                entity.setJsonRoles(this.addToJsonUniqueList(value, entity.getJsonRoles(), config.getSplitRolesCharacter()));
                break;
            }
            case USER_EMAIL: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserEmail())) break;
                entity.setUserEmail(value);
                break;
            }
            case USER_FIRSTNAME: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserFirstName())) break;
                entity.setUserFirstName(value);
                break;
            }
            case USER_LASTNAME: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserLastName())) break;
                entity.setUserLastName(value);
                break;
            }
            case USER_LOGIN: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserLogin())) break;
                entity.setUserLogin(value);
                break;
            }
            case USER_NUMBER: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserNumber())) break;
                entity.setUserNumber(value);
                break;
            }
            case USER_PASSWORD: {
                if (!StringUtils.isBlank((CharSequence)entity.getUserPassword())) break;
                entity.setUserPassword(value);
            }
        }
        return entity;
    }

    private String addToJsonList(String value, String jsonList) {
        List<String> list = this.fromJson(jsonList);
        list.add(value);
        return GSON.toJson(list);
    }

    private String addToJsonUniqueList(String value, String jsonList, String splitChar) {
        List<String> list = this.fromJson(jsonList);
        if (value != null) {
            if (StringUtils.isNotBlank((CharSequence)splitChar)) {
                list.addAll(Arrays.asList(value.split(splitChar)));
            } else {
                list.add(value);
            }
        }
        return GSON.toJson(list.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()));
    }

    private String addToJsonList(String value, String jsonList, String splitChar) {
        List<String> list = this.fromJson(jsonList);
        if (value != null) {
            if (StringUtils.isNotBlank((CharSequence)splitChar)) {
                list.addAll(Arrays.asList(value.split(splitChar)));
            } else {
                list.add(value);
            }
        } else {
            list.add("");
        }
        return GSON.toJson(list);
    }
}

