/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.db.servicies;

import com.suncode.plugin.organization.structure.db.daos.StructureLogTableDao;
import com.suncode.plugin.organization.structure.db.entity.StructureLog;
import com.suncode.plugin.organization.structure.db.enums.LogStatus;
import com.suncode.plugin.organization.structure.db.servicies.StructureLogService;
import com.suncode.plugin.organization.structure.dto.LogDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StructureLogServiceImpl
extends EditableServiceImpl<StructureLog, Long, StructureLogTableDao>
implements StructureLogService {
    private static final Logger log = LoggerFactory.getLogger(StructureLogServiceImpl.class);

    @Autowired
    public void setDao(StructureLogTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void deleteAll() {
        try {
            List structureLogs = ((StructureLogTableDao)this.dao).getAll(new String[0]);
            for (StructureLog structureLog : structureLogs) {
                ((StructureLogTableDao)this.dao).delete(structureLog);
            }
        }
        catch (Exception e) {
            log.debug("Cannot delete table: plus_osm_structure_log error: " + e.getMessage());
        }
    }

    @Override
    public void addLog(LogDto dto) {
        if (dto == null) {
            return;
        }
        ((StructureLogTableDao)this.dao).save(this.createEntity(dto));
    }

    @Override
    public CountedResult<LogDto> getErrors() {
        CountedResult returnedData = new CountedResult();
        List result = ((StructureLogTableDao)this.dao).findByProperty("status", LogStatus.ERROR.getStatus(), null, null, new String[0]);
        if (result == null || result.isEmpty()) {
            return returnedData;
        }
        List resultData = result.stream().filter(Objects::nonNull).map(log -> new LogDto(log.getStatus(), log.getDataType(), log.getInfo(), log.getTimestamp())).collect(Collectors.toList());
        returnedData.setTotal((long)resultData.size());
        returnedData.setData(resultData);
        return returnedData;
    }

    private StructureLog createEntity(LogDto dto) {
        return StructureLog.builder().dataType(dto.getType()).info(dto.getInfo().substring(0, Math.min(dto.getInfo().length(), 3999))).timestamp(new Timestamp(dto.getTime())).status(dto.getStatus()).build();
    }
}

