/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.service;

import com.suncode.plugin.organization.structure.config.dtos.Configuration;
import com.suncode.plugin.organization.structure.config.dtos.DetachUnusedUser;
import com.suncode.plugin.organization.structure.config.enums.UserDetachType;
import com.suncode.plugin.organization.structure.db.enums.DataType;
import com.suncode.plugin.organization.structure.db.servicies.StructureLogService;
import com.suncode.plugin.organization.structure.db.servicies.StructureTableService;
import com.suncode.plugin.organization.structure.dto.LogDto;
import com.suncode.plugin.organization.structure.dto.StructureDataDto;
import com.suncode.plugin.organization.structure.dto.UserDto;
import com.suncode.plugin.organization.structure.exception.TaskCanceledException;
import com.suncode.plugin.organization.structure.exception.utils.ExceptionTool;
import com.suncode.plugin.organization.structure.service.ImportStructureService;
import com.suncode.plugin.organization.structure.service.StructureService;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureServiceImpl
implements StructureService {
    private static final Logger log = LoggerFactory.getLogger(StructureServiceImpl.class);
    @Autowired
    private StructureTableService structureTabelService;
    @Autowired
    private ImportStructureService importStructureService;
    @Autowired
    private StructureLogService structureLogService;
    @Autowired
    private UserGroupFinder userGroupFinder;

    @Override
    public void importStructure(Configuration config, CancelationHandler cancellation) throws TaskCanceledException {
        StructureDataDto cacheData = new StructureDataDto(this.structureTabelService.getAll(), config.getDefaultGroups(), this.getIgnoredGroups(config.getIgnoredGroups(), config.getIgnoredGroupsByRegex(), this.userGroupFinder.getAll(new String[0])));
        ExceptionTool.checkTaskCancellation(cancellation);
        this.cacheUnusedUsers(cacheData);
        ExceptionTool.checkTaskCancellation(cancellation);
        this.importGroupOrUpdateDescription(cacheData, config.getSkipImportErrors());
        ExceptionTool.checkTaskCancellation(cancellation);
        this.importOrgUnits(cacheData, config.getSkipImportErrors());
        ExceptionTool.checkTaskCancellation(cancellation);
        this.importPosition(cacheData, config.getSkipImportErrors());
        ExceptionTool.checkTaskCancellation(cancellation);
        this.importPositionsAssociations(cacheData);
        ExceptionTool.checkTaskCancellation(cancellation);
        this.importOrgUnitAssociations(cacheData);
        ExceptionTool.checkTaskCancellation(cancellation);
        this.importUsers(cacheData, config);
        ExceptionTool.checkTaskCancellation(cancellation);
        this.removeUnusedUsers(cacheData, config);
        this.removeUnusedGroups(cacheData, config);
        this.removeUnusedPositions(cacheData, config);
        this.removeUnusedOus(cacheData, config);
        log.info("Structure import complete.");
    }

    private List<String> getIgnoredGroups(List<String> ignoredGroups, List<String> ignoredGroupsByRegExp, List<UserGroup> allUserGroups) {
        Set groupNames = allUserGroups.stream().map(UserGroup::getName).filter(ignoredGroups::contains).collect(Collectors.toSet());
        ignoredGroupsByRegExp.forEach(pattern -> groupNames.addAll(this.filterUserGroups((String)pattern, allUserGroups)));
        return new ArrayList<String>(groupNames);
    }

    private Collection<String> filterUserGroups(String regexPattern, List<UserGroup> allUserGroups) {
        return allUserGroups.stream().map(UserGroup::getName).filter(groupName -> groupName.matches(regexPattern)).collect(Collectors.toList());
    }

    private void cacheUnusedUsers(StructureDataDto cacheData) {
        cacheData.setCachedUnusedUsers(this.importStructureService.cacheUnusedUsers(cacheData.getUniqueUsersToImport()));
    }

    private void importGroupOrUpdateDescription(StructureDataDto cacheData, Boolean skipImportErrors) {
        Map<String, String> groupDescriptionsMap = cacheData.getGroupDescriptionsMap();
        cacheData.getUniqueGroupNames().forEach(groupName -> {
            block2: {
                try {
                    LogDto logDto = this.importStructureService.importGroupOrUpdateDescription((String)groupName, groupDescriptionsMap.getOrDefault(groupName, null));
                    this.structureLogService.addLog(logDto);
                }
                catch (Exception e) {
                    log.error("Error import group: " + groupName, (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.GROUP, e));
                    if (skipImportErrors.booleanValue()) break block2;
                    throw e;
                }
            }
        });
        log.info("Groups imported: " + cacheData.getUniqueGroupNames().size());
    }

    private void importOrgUnits(StructureDataDto cacheData, Boolean skipImportErrors) {
        cacheData.getOrganizationUnitsMap().forEach((key, value) -> {
            block2: {
                try {
                    LogDto logDto = this.importStructureService.createOrUpdateOrganizationUnit((String)value, (String)key);
                    this.structureLogService.addLog(logDto);
                }
                catch (Exception e) {
                    log.error("Error import organization unit: " + value, (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.OU, e));
                    if (skipImportErrors.booleanValue()) break block2;
                    throw e;
                }
            }
        });
    }

    private void importPosition(StructureDataDto cacheData, Boolean skipImportErrors) {
        cacheData.getPositionsMap().forEach((key, dto) -> {
            block2: {
                try {
                    LogDto logDto = this.importStructureService.importPosition(dto.getName(), dto.getSymbol(), dto.getOrgUnitSymbol(), dto.getRoles());
                    this.structureLogService.addLog(logDto);
                }
                catch (Exception e) {
                    log.error("Error import position: " + dto.getSymbol(), (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.POSITION, e));
                    if (skipImportErrors.booleanValue()) break block2;
                    throw e;
                }
            }
        });
    }

    private void importPositionsAssociations(StructureDataDto cacheData) {
        cacheData.getPositionsMap().forEach((key, dto) -> this.importStructureService.importPositionsAssociations(dto.getSymbol(), dto.getHigherPositionSymbol()));
    }

    private void importOrgUnitAssociations(StructureDataDto cacheData) {
        cacheData.getPositionsMap().forEach((key, dto) -> this.importStructureService.importOrganizationUnitsAssociations(dto.getOrgUnitSymbol(), dto.getHigherOUSymbol(), dto.getDirectorySymbol()));
    }

    private void importUsers(StructureDataDto cacheData, Configuration config) {
        cacheData.getUsersMap().forEach((key, userDto) -> {
            block2: {
                userDto.addGroupName(config.getDefaultGroups());
                try {
                    LogDto logDto = this.importStructureService.importUser((UserDto)userDto, cacheData.getIgnoredGroups());
                    cacheData.addUserName(userDto.getName());
                    this.structureLogService.addLog(logDto);
                }
                catch (Exception e) {
                    log.error("Error import user: " + userDto.getName(), (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.USER, e));
                    if (config.getSkipImportErrors().booleanValue()) break block2;
                    throw e;
                }
            }
        });
    }

    private void removeUnusedGroups(StructureDataDto cacheData, Configuration config) {
        block3: {
            if (config.getDeleteUnusedGroups().booleanValue()) {
                try {
                    List<LogDto> listLogDto = this.importStructureService.removeUnusedGroups(cacheData.getUniqueGroupNames());
                    listLogDto.forEach(item -> this.structureLogService.addLog((LogDto)item));
                }
                catch (Exception e) {
                    log.error("Error remove unused groups ", (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.GROUP, e));
                    if (config.getSkipImportErrors().booleanValue()) break block3;
                    throw e;
                }
            }
        }
    }

    private void removeUnusedPositions(StructureDataDto cacheData, Configuration config) {
        block3: {
            if (config.getDeleteUnusedPositions().booleanValue()) {
                try {
                    List<LogDto> listLogDto = this.importStructureService.removeUnusedPositions(cacheData.getUniquePositionSymbols());
                    listLogDto.forEach(item -> this.structureLogService.addLog((LogDto)item));
                }
                catch (Exception e) {
                    log.error("Error remove unused positions ", (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.POSITION, e));
                    if (config.getSkipImportErrors().booleanValue()) break block3;
                    throw e;
                }
            }
        }
    }

    private void removeUnusedUsers(StructureDataDto cacheData, Configuration config) {
        block3: {
            DetachUnusedUser detachUnusedUsers = config.getDetachUnusedUsers();
            if (this.isDetachUnusedUsers(detachUnusedUsers)) {
                try {
                    List<LogDto> listLogDto = this.importStructureService.removeUnusedUsers(detachUnusedUsers.getType().name(), detachUnusedUsers.getAssignmentUsers(), cacheData.getCachedUnusedUsers());
                    listLogDto.forEach(item -> this.structureLogService.addLog((LogDto)item));
                }
                catch (Exception e) {
                    log.error("Error remove unused groups ", (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.USER, e));
                    if (config.getSkipImportErrors().booleanValue()) break block3;
                    throw e;
                }
            }
        }
    }

    private boolean isDetachUnusedUsers(DetachUnusedUser detachUnusedUsers) {
        return detachUnusedUsers != null && detachUnusedUsers.getAssignmentUsers() != null && !detachUnusedUsers.getAssignmentUsers().isEmpty() && detachUnusedUsers.getType() != null && detachUnusedUsers.getType() != UserDetachType.NONE;
    }

    private void removeUnusedOus(StructureDataDto cacheData, Configuration config) {
        block3: {
            if (config.getDeleteUnusedOrganizationUnits().booleanValue()) {
                try {
                    List<LogDto> listLogDto = this.importStructureService.removeUnusedOus(cacheData.getUniqueOuSymbols());
                    listLogDto.forEach(item -> this.structureLogService.addLog((LogDto)item));
                }
                catch (Exception e) {
                    log.error("Error remove unused organization units ", (Throwable)e);
                    this.structureLogService.addLog(LogDto.buildErrorLogDto(DataType.OU, e));
                    if (config.getSkipImportErrors().booleanValue()) break block3;
                    throw e;
                }
            }
        }
    }
}

