/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.service;

import com.suncode.plugin.organization.structure.dto.DataSourceUserDto;
import com.suncode.plugin.organization.structure.enums.UserMappingKey;
import com.suncode.plugin.organization.structure.service.OsmStructureService;
import com.suncode.plugin.organization.structure.service.OsmUserService;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.exception.PositionAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.PositionNotFoundException;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OsmUserServiceImpl
implements OsmUserService {
    private static final Logger log = LoggerFactory.getLogger(OsmUserServiceImpl.class);
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private OsmStructureService osmStructureService;

    @Override
    public Map<String, User> fetchMappingValueToUserMap(UserMappingKey mappingKey) {
        List users = this.userFinder.getAll(new String[]{"positions.organizationalUnit", "positions", "groups"});
        switch (mappingKey) {
            case USER_NAME: {
                return users.stream().filter(user -> StringUtils.isNotBlank((CharSequence)user.getUserName())).collect(Collectors.toMap(User::getUserName, user -> user));
            }
            case USER_NUMBER: {
                return users.stream().filter(user -> StringUtils.isNotBlank((CharSequence)user.getNumber())).collect(Collectors.toMap(User::getNumber, user -> user));
            }
            case USER_EMAIL: {
                return users.stream().filter(user -> StringUtils.isNotBlank((CharSequence)user.getEmail())).collect(Collectors.toMap(User::getEmail, user -> user));
            }
        }
        throw new RuntimeException("Invalid mapping key: " + (Object)((Object)mappingKey));
    }

    @Override
    public String updateUserData(User user, DataSourceUserDto dsUserDto) {
        if (StringUtils.isNotBlank((CharSequence)dsUserDto.getUserFirstName())) {
            log.info("Update firstName: " + dsUserDto.getUserFirstName());
            user.setFirstName(dsUserDto.getUserFirstName());
        }
        if (StringUtils.isNotBlank((CharSequence)dsUserDto.getUserLastName())) {
            log.info("Update LastName: " + dsUserDto.getUserLastName());
            user.setLastName(dsUserDto.getUserLastName());
        }
        if (StringUtils.isNotBlank((CharSequence)dsUserDto.getUserNumber())) {
            log.info("Update number: " + dsUserDto.getUserNumber());
            user.setNumber(dsUserDto.getUserNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)dsUserDto.getUserEmail())) {
            log.info("Update email: " + dsUserDto.getUserEmail());
            user.setEmail(dsUserDto.getUserEmail());
        }
        if (dsUserDto.getIsAnonymousUser() != null) {
            log.info("Update is anonymous user: " + dsUserDto.getIsAnonymousUser());
            user.setAnonymous(dsUserDto.getIsAnonymousUser().booleanValue());
        }
        if (dsUserDto.getSsoLoginOnly() != null) {
            log.info("Update only SSO login: " + dsUserDto.getSsoLoginOnly());
            user.setOnlySsoLogin(dsUserDto.getSsoLoginOnly().booleanValue());
        }
        this.userService.updateUser(user);
        return "Updated user: " + user.getUserName();
    }

    @Override
    public Optional<Position> getUserPosition(String symbol, String name, User user, Map<String, Long> namesCount) {
        Optional<Position> position = this.getUserPositionBySymbol(symbol, user);
        if (position.isPresent()) {
            this.osmStructureService.updatePositionName(name, position.get());
            return position;
        }
        if (StringUtils.isBlank((CharSequence)symbol)) {
            position = this.getUserPositionByName(name, user);
        }
        if (!position.isPresent()) {
            position = this.createNewUserPosition(symbol, name, user, namesCount);
        }
        return position;
    }

    private Optional<Position> getUserPositionByName(String name, User user) {
        return user.getPositions().stream().filter(position -> position.getName().equals(name)).findFirst();
    }

    private Optional<Position> getUserPositionBySymbol(String symbol, User user) {
        return user.getPositions().stream().filter(position -> position.getSymbol().equals(symbol)).findFirst();
    }

    private Optional<Position> createNewUserPosition(String symbol, String name, User user, Map<String, Long> namesCount) {
        Optional<Object> positionOptional = Optional.empty();
        try {
            positionOptional = this.osmStructureService.getPosition(name, symbol, namesCount);
            positionOptional.ifPresent(position -> position.setUser(user));
            return positionOptional;
        }
        catch (PositionAlreadyExistException | PositionNotFoundException | EmptyPropertyException e) {
            log.error("Error get Position. positionName: " + name + " , positionSymbol: " + symbol, e);
            return positionOptional;
        }
    }
}

