/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.organization.structure.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.suncode.plugin.organization.structure.enums.SuperiorMappingKey;
import com.suncode.plugin.organization.structure.enums.UserMappingKey;
import com.suncode.plugin.organization.structure.exception.InvalidMappingKeyException;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataSourceUserDto {
    private String userNumber;
    private String userFirstName;
    private String userLastName;
    private String userName;
    private String userEmail;
    private String superiorFullNameRev;
    private String superiorFullName;
    private String superiorFirstName;
    private String superiorLastName;
    private String superiorName;
    private String superiorNumber;
    private String positionName;
    private String positionSymbol;
    private String ouName;
    private String ouSymbol;
    private String higherOUSymbol;
    private String higherOUName;
    private Boolean ssoLoginOnly;
    private Boolean isAnonymousUser;

    public String getUserMappingValue(UserMappingKey mappingKey) {
        switch (mappingKey) {
            case USER_NAME: {
                return this.userName;
            }
            case USER_NUMBER: {
                return this.userNumber;
            }
            case USER_EMAIL: {
                return this.userEmail;
            }
        }
        throw new InvalidMappingKeyException(mappingKey.name());
    }

    public String getSuperiorMappingValue(SuperiorMappingKey mappingKey) {
        if (mappingKey == null) {
            return this.getSuperior();
        }
        switch (mappingKey) {
            case SUPERIOR_NAME: {
                return this.superiorName;
            }
            case SUPERIOR_NUMBER: {
                return this.superiorNumber;
            }
            case SUPERIOR_FULLNAME: {
                if (StringUtils.isBlank((CharSequence)this.superiorFullName)) {
                    return this.concatString(this.superiorFirstName, this.superiorLastName);
                }
                return this.superiorFullName;
            }
            case SUPERIOR_FULLNAMEREV: {
                if (StringUtils.isBlank((CharSequence)this.superiorFullNameRev)) {
                    return this.concatString(this.superiorLastName, this.superiorFirstName);
                }
                return this.superiorFullNameRev;
            }
        }
        throw new RuntimeException("Invalid mapping key: " + (Object)((Object)mappingKey));
    }

    private String concatString(String str1, String str2) {
        return (StringUtils.defaultString((String)str1) + " " + StringUtils.defaultString((String)str2)).trim();
    }

    private String getSuperior() {
        if (StringUtils.isNotBlank((CharSequence)this.superiorFullName)) {
            return this.superiorFullName;
        }
        if (StringUtils.isNotBlank((CharSequence)this.superiorFullNameRev)) {
            return this.superiorFullNameRev;
        }
        if (StringUtils.isNotBlank((CharSequence)this.superiorFirstName) && StringUtils.isNotBlank((CharSequence)this.superiorLastName)) {
            return this.superiorFirstName + " " + this.superiorLastName;
        }
        if (StringUtils.isNotBlank((CharSequence)this.superiorName)) {
            return this.superiorName;
        }
        return "";
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getSuperiorFullNameRev() {
        return this.superiorFullNameRev;
    }

    public String getSuperiorFullName() {
        return this.superiorFullName;
    }

    public String getSuperiorFirstName() {
        return this.superiorFirstName;
    }

    public String getSuperiorLastName() {
        return this.superiorLastName;
    }

    public String getSuperiorName() {
        return this.superiorName;
    }

    public String getSuperiorNumber() {
        return this.superiorNumber;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public String getPositionSymbol() {
        return this.positionSymbol;
    }

    public String getOuName() {
        return this.ouName;
    }

    public String getOuSymbol() {
        return this.ouSymbol;
    }

    public String getHigherOUSymbol() {
        return this.higherOUSymbol;
    }

    public String getHigherOUName() {
        return this.higherOUName;
    }

    public Boolean getSsoLoginOnly() {
        return this.ssoLoginOnly;
    }

    public Boolean getIsAnonymousUser() {
        return this.isAnonymousUser;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public void setSuperiorFullNameRev(String superiorFullNameRev) {
        this.superiorFullNameRev = superiorFullNameRev;
    }

    public void setSuperiorFullName(String superiorFullName) {
        this.superiorFullName = superiorFullName;
    }

    public void setSuperiorFirstName(String superiorFirstName) {
        this.superiorFirstName = superiorFirstName;
    }

    public void setSuperiorLastName(String superiorLastName) {
        this.superiorLastName = superiorLastName;
    }

    public void setSuperiorName(String superiorName) {
        this.superiorName = superiorName;
    }

    public void setSuperiorNumber(String superiorNumber) {
        this.superiorNumber = superiorNumber;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public void setPositionSymbol(String positionSymbol) {
        this.positionSymbol = positionSymbol;
    }

    public void setOuName(String ouName) {
        this.ouName = ouName;
    }

    public void setOuSymbol(String ouSymbol) {
        this.ouSymbol = ouSymbol;
    }

    public void setHigherOUSymbol(String higherOUSymbol) {
        this.higherOUSymbol = higherOUSymbol;
    }

    public void setHigherOUName(String higherOUName) {
        this.higherOUName = higherOUName;
    }

    public void setSsoLoginOnly(Boolean ssoLoginOnly) {
        this.ssoLoginOnly = ssoLoginOnly;
    }

    public void setIsAnonymousUser(Boolean isAnonymousUser) {
        this.isAnonymousUser = isAnonymousUser;
    }

    public String toString() {
        return "DataSourceUserDto(userNumber=" + this.getUserNumber() + ", userFirstName=" + this.getUserFirstName() + ", userLastName=" + this.getUserLastName() + ", userName=" + this.getUserName() + ", userEmail=" + this.getUserEmail() + ", superiorFullNameRev=" + this.getSuperiorFullNameRev() + ", superiorFullName=" + this.getSuperiorFullName() + ", superiorFirstName=" + this.getSuperiorFirstName() + ", superiorLastName=" + this.getSuperiorLastName() + ", superiorName=" + this.getSuperiorName() + ", superiorNumber=" + this.getSuperiorNumber() + ", positionName=" + this.getPositionName() + ", positionSymbol=" + this.getPositionSymbol() + ", ouName=" + this.getOuName() + ", ouSymbol=" + this.getOuSymbol() + ", higherOUSymbol=" + this.getHigherOUSymbol() + ", higherOUName=" + this.getHigherOUName() + ", ssoLoginOnly=" + this.getSsoLoginOnly() + ", isAnonymousUser=" + this.getIsAnonymousUser() + ")";
    }
}

