PW.FormActions.create('check-nip-action', {
    init: function () {
    },
    defaultActions: {
        button: function (button) {
            this.getOneStatus();
        },
        variable: function (variable, newValue, oldValue) {
            this.getOneStatus();
        },
        variableSet: function (variableSet, added, updated, removed) {
        }
    },
    getOneStatus: function () {
        FormService.mask("Sprowadzanie statusu podatnika VAT");
        const statusVar = this.get("status");
        const controlVar = this.get("controller-var");
        const isOnComment = this.get("on-off-comment");
        const requestIdVar = this.get("request-id");
        const requestDateTimeVar = this.get("request-date-time");
        const showMessage = this.get("show-message");
        const nip = this.get("nip");
        const date = Ext4.Date.format(this.get('date'), "Y-m-d");
        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-nipchecker/status/one',
            type: "GET",
            data: {
                nip: nip,
                date: date
            },
            success: function (data) {
                let info = data.status;
                const statusCode = data.statusCode;
                let requestId = data.requestId;
                let requestDateTime = data.requestDateTime;
                if(showMessage == true || (showMessage == null && statusVar == null))
                {
                    MessageService.show(info.replace("\n", "<br><br>"), {hideAfter: 15000});
                }
                if (statusVar != null)
                {
                    VariableService.setValue(statusVar.getId(), info);

                    if (controlVar != null) {
                        VariableService.setValue(controlVar.getId(), statusCode);
                    }
                    if (requestIdVar != null) {
                        VariableService.setValue(requestIdVar.getId(), requestId);
                    }
                    if (requestDateTimeVar != null) {
                        VariableService.setValue(requestDateTimeVar.getId(), requestDateTime == null ? null : new Date(requestDateTime));
                    }
                }
                if (isOnComment) {
                    if (statusCode === "STRONA_NIEDOSTEPNA") {
                        info = "Brak połączenia z Ministerstwem finansów – kontrahent nie został zweryfikowany w bazie MF. <br>" +
                            "W celu rozwiązania problemu skontaktuj się z administratorem.";
                    }
                    CommentService.add("NIP: " + nip + "<br>Status: " + info.replace("\n", "<br>,<br>"));
                }
                return true;
            },
            error: function () {
                Log.error("error ajax check-nip-action");
                return false;
            },
            complete: function () {
                FormService.unmask();
            }
        });
    }
});