PW.FormActions.create('check-nip-action-tab', {
    init: function () {
        this.nipVar = this.get("nip");
        this.dateVar = this.get("date");
    },
    variableSetInit: function (table) {
        this.variableSet = VariableSetService.get(table.getId());
    },
    dtButtonInit: function (button) {
        this.variableSet = VariableSetService.get(button.variableSet.getId());
    },
    enable: function () {
        if (this.get("on-init")) {
            this.getAllStatus();
        }
    },
    defaultActions: {
        variableSet: function (variableSet, added, updated, removed) {
            if (this.get("on-updated")) {
                if (updated.length > 0) {
                    for (let index = 0; index < updated.length; index++) {
                        for (let indexChanges = 0; indexChanges < updated[index].changes.length; indexChanges++) {
                            if (this.nipVar.getId() === updated[index].changes[indexChanges] || this.dateVar.getId() === updated[index].changes[indexChanges]) {
                                const recordData = updated[index].record.record.data;
                                const currentIndex = updated[index].index;
                                const nips = [];
                                const dateValue = this.dateVar ? recordData[this.dateVar.getId()] : null;
                                nips.push(this.buildNipsObj(currentIndex, recordData[this.nipVar.getId()], dateValue));
                                this.getStatuses(nips);
                            }
                        }
                    }
                }
            }
        },
        dtButton: function (button) {
            this.getAllStatus();
        }
    },
    getAllStatus: function () {
        const nips = [];
        const rawNips = this.nipVar.getValue();
        const rawDates = this.dateVar ? this.dateVar.getValue() : new Array(rawNips.length).fill(null);
        for (let index = 0; index < rawNips.length; index++) {
            nips.push(this.buildNipsObj(index, rawNips[index], rawDates[index]));
        }
        this.getStatuses(nips);
    },
    buildNipsObj: function (currentRow, nip, date) {
        const obj = {};
        obj.row = currentRow;
        obj.nip = nip;
        obj.date = Ext4.Date.format(date, "Y-m-d");
        return obj;
    },
    getStatuses: function (nips) {
        FormService.mask("Sprwadzanie statusów podatnika VAT");
        const me = this;
        const statusVar = this.get("status");
        const controlVar = this.get("controller-var");
        const skipEmptyValue = this.get("skip-empty-value");
        const requestIdVar = this.get("request-id");
        const requestDateTimeVar = this.get("request-date-time");
        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-nipchecker/status/multi?skipEmptyValue=' + skipEmptyValue,
            type: "POST",
            data: JSON.stringify(nips),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success: function (result) {
                const data = result.data;
                for (let i = 0; i < data.length; i++) {
                    VariableSetService.setValue(me.variableSet, data[i].row, statusVar.getId(), data[i].status);

                    if (requestIdVar != null) {
                        VariableSetService.setValue(me.variableSet, data[i].row, requestIdVar.getId(), data[i].requestId);
                    }

                    if (requestDateTimeVar != null) {
                        VariableSetService.setValue(me.variableSet, data[i].row, requestDateTimeVar.getId(), data[i].requestDateTime == null ? null : (requestDateTimeVar.type.name == 'date[]' ? new Date(data[i].requestDateTime) : new Date(data[i].requestDateTime).format("Y-m-d H:i:s")));
                    }
                }

                if (controlVar != null) {
                    for (let i = 0; i < data.length; i++) {
                        VariableSetService.setValue(me.variableSet, data[i].row, controlVar.getId(), data[i].statusCode);
                    }
                }

                return true;
            },
            error: function () {
                Logger.error("error check-nip-action-tab");
                return false;
            },
            complete: function () {
                FormService.unmask();
            }
        });
    },
});