/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.validator;

import com.suncode.plugin.check_status_vat.categories.Categories;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPTabDto;
import com.suncode.plugin.check_status_vat.schemas.ValidInfo;
import com.suncode.plugin.check_status_vat.schemas.ValidNipStatus;
import com.suncode.plugin.check_status_vat.service.CommentMsgService;
import com.suncode.plugin.check_status_vat.service.StatusService;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
public class StatusVatValidatorTab {
    private static final String CONFIRMATION_QUESTION = "Czy faktura jest poprawna?";
    private static final String CONFIRMATION_TITLE = "Ostrze\u017cenie: Sprawd\u017a fakture";
    @Autowired
    private CommentMsgService commentMsgService;
    @Autowired
    private StatusService statusService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("status-vat-validator-tab")).name("validator.status-vat-tab.name")).description("validator.status-vat-tab.desc")).category(new Category[]{Categories.NIPCHECKER})).parameter().id("nip").name("nip-checker.param.nip.name").type((Type)Types.VARIABLE).create()).parameter().id("date").name("nip-checker.param.date.name").description("nip-checker.param.date.desc").type((Type)Types.DATE_ARRAY).optional().create()).parameter().id("nip-released-check").name("nip-checker.param.nip-released-check.name").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("nip-released-msg").name("nip-checker.param.nip-released-msg.name").type((Type)Types.STRING).optional().create()).parameter().id("nip-blocked-check").name("nip-checker.param.nip-blocked-check.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("skip-empty-value").name("nip-checker.param.skip-empty-value.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create();
    }

    public void validate(@Param(value="nip") Variable nipVar, @Param(value="nip-released-check") Boolean isNipReleased, @Param(value="nip-released-msg") String msg, @Param(value="nip-blocked-check") Boolean isNipBlocked, @Param(value="skip-empty-value") Boolean skipEmptyValue, @Param(value="date") LocalDate[] date, ValidationErrors errors, UserInfo userInfo, ValidationContext validationContext) {
        ValidInfo validInfo = new ValidInfo();
        validInfo.setIsArray(nipVar.isArray());
        List<StatusNIPTabDto> statusesNipTab = this.convertToListDto((String[])nipVar.getValue(), date).stream().filter(nip -> skipEmptyValue == false || skipEmptyValue != false && StringUtils.isNotBlank((String)nip.getNip())).collect(Collectors.toList());
        this.statusService.fillStatuses(statusesNipTab);
        List<ValidNipStatus> validNipStatuses = statusesNipTab.stream().map(statusNIpTabDto -> {
            ValidNipStatus validNipStatus = new ValidNipStatus((StatusNIPTabDto)statusNIpTabDto);
            validNipStatus.setNipId(nipVar.getId());
            this.valid(isNipReleased, isNipBlocked, validNipStatus, validInfo);
            return validNipStatus;
        }).collect(Collectors.toList());
        validInfo.setValidedData(validNipStatuses);
        this.errorsAdd(msg, errors, validInfo);
    }

    private void valid(Boolean isNipReleased, Boolean isNipBlocked, ValidNipStatus validNipStatus, ValidInfo validInfo) {
        Boolean errorFlag = validInfo.getErrorVar();
        validNipStatus.setConfirm(true);
        validNipStatus.setError(false);
        switch (validNipStatus.getStatusCode()) {
            case RELEASED: {
                if (!isNipReleased.booleanValue()) break;
                validNipStatus.setError(true);
                break;
            }
            case UNREGISTERED: {
                validNipStatus.setConfirm(isNipBlocked);
                validNipStatus.setError(true);
                if (isNipBlocked.booleanValue()) break;
                errorFlag = true;
                break;
            }
            case INCORRECT: {
                validNipStatus.setConfirm(false);
                validNipStatus.setError(true);
                errorFlag = true;
                break;
            }
            case UNKNOWN: 
            case OUTSIDE_THE_EU: 
            case NOT_FIGURED: 
            case INACTIVE_VIES: 
            case WEBSITE_IS_UNAVAILABLE: {
                validNipStatus.setError(true);
                break;
            }
        }
        validInfo.setErrorVar(errorFlag);
        validInfo.getValidedData().add(validNipStatus);
    }

    private void errorsAdd(String msg, ValidationErrors errors, ValidInfo validInfo) {
        List errorNips = validInfo.getValidedData().stream().filter(ValidNipStatus::isError).collect(Collectors.toList());
        if (errorNips.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.commentMsgService.createTabMessage(new LinkedList<StatusNIPTabDto>(errorNips)));
        if (validInfo.getErrorVar().booleanValue()) {
            for (ValidNipStatus validError : errorNips) {
                errors.add(validError.getStatus(), validError.getNipId(), validError.getRow().intValue());
            }
            errors.add(sb.toString());
        } else {
            sb.append("<br><br>").append(CONFIRMATION_QUESTION);
            errors.addConfirmation(msg != null ? msg : sb.toString(), CONFIRMATION_TITLE);
        }
    }

    private List<StatusNIPTabDto> convertToListDto(String[] nips, LocalDate[] date) {
        List<StatusNIPTabDto> statusNipTabDto = IntStream.range(0, nips.length).mapToObj(index -> {
            StatusNIPTabDto obj = new StatusNIPTabDto();
            obj.setNip(nips[index]);
            obj.setDate(date != null && date.length > index ? date[index] : DateTime.now().toLocalDate());
            obj.setRow(index);
            return obj;
        }).collect(Collectors.toList());
        return statusNipTabDto;
    }
}

