/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.servlet;

import com.suncode.plugin.check_status_vat.schemas.StatusNIPDto;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPTabDto;
import com.suncode.plugin.check_status_vat.service.StatusService;
import com.suncode.pwfl.search.CountedResult;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"status"})
public class StatusController {
    @Autowired
    private StatusService statusService;

    @RequestMapping(value={"one"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusNIPDto getOneStatus(@RequestParam(value="nip") String nip, @RequestParam(value="date") String date) {
        return this.statusService.getOne(nip, StringUtils.isBlank((CharSequence)date) ? null : LocalDate.parse((String)date, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd")));
    }

    @RequestMapping(value={"multi"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<StatusNIPTabDto> getStatuses(@RequestParam(value="skipEmptyValue") Boolean skipEmptyValue, @RequestBody List<StatusNIPTabDto> nips) {
        Boolean skip = skipEmptyValue;
        CountedResult result = new CountedResult();
        this.statusService.fillStatuses(nips, skip);
        result.setData(nips);
        result.setTotal((long)nips.size());
        return result;
    }
}

