/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.engine;

import com.suncode.plugin.check_status_vat.engine.CountryCode;
import org.apache.log4j.Logger;

public class VerificationNIP {
    public static final String NIEPOPRAWNY_NR_NIP = "Niepoprawny nr NIP";
    public static final String NIP_POZA_UE = "NIP spoza PL i UE \u2013 nie podlega weryfikacji";
    public static final String NIP_UE = "NIP z UE - weryfikacja nie dost\u0119pna w tej wersji wtyczki";
    public static Logger log = Logger.getLogger(VerificationNIP.class);

    public static CountryCode getCountry(String nip) {
        log.debug((Object)("Analiza nr nip\t" + nip));
        if (nip.length() < 2) {
            return CountryCode.SPOZA_UE;
        }
        String code = nip.substring(0, 2).toUpperCase();
        log.debug((Object)"Wykrywanie kraju pochodzenia");
        if (CountryCode.hasCode(code).booleanValue()) {
            log.debug((Object)("Wykryto kraj: " + CountryCode.getCountryCode(code).getName()));
            return CountryCode.getCountryCode(code);
        }
        try {
            log.debug((Object)"Sprawdzanie czy kraj to POLSKA");
            Long.parseLong(code);
            String nipTemp = nip.replaceAll("\\D", "");
            if (nipTemp.length() == 10) {
                log.debug((Object)"Kraj pochodzenia to PL");
                return CountryCode.PL;
            }
            log.debug((Object)"Kraj pochodzenia to Poza Ue");
            return CountryCode.SPOZA_UE;
        }
        catch (Exception e) {
            log.debug((Object)"B\u0142\u0105d sprawdzania czy ktaj to PL czy Poza UE");
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)"Ustawiam ze poza UE");
            return CountryCode.SPOZA_UE;
        }
    }

    public static Boolean verifyPL(String nip) {
        log.debug((Object)"Weryfikacja NIP");
        log.debug((Object)("Tekst\t" + nip));
        String nipDigit = nip.replaceAll("\\D", "");
        log.debug((Object)("Tekst\t" + nipDigit));
        if (nipDigit.length() == 10) {
            return VerificationNIP.verifyPL(Long.parseLong(nipDigit));
        }
        log.debug((Object)"Nieprawidlowa d\u0142ugo\u015b\u0107 liczb");
        return false;
    }

    public static Boolean verifyPL(Long nip) {
        log.debug((Object)("Liczba\t" + nip));
        String number = String.valueOf(nip);
        char[] nipSplit = number.toCharArray();
        log.debug((Object)("Osobno cyfry\t" + String.valueOf(nipSplit)));
        if (nipSplit.length == 10) {
            Long sum = 0L;
            log.debug((Object)"Przeliczanie posczeg\u00f3lnych wag");
            sum = sum + (long)(6 * Character.getNumericValue(nipSplit[0]));
            sum = sum + (long)(5 * Character.getNumericValue(nipSplit[1]));
            sum = sum + (long)(7 * Character.getNumericValue(nipSplit[2]));
            sum = sum + (long)(2 * Character.getNumericValue(nipSplit[3]));
            sum = sum + (long)(3 * Character.getNumericValue(nipSplit[4]));
            sum = sum + (long)(4 * Character.getNumericValue(nipSplit[5]));
            sum = sum + (long)(5 * Character.getNumericValue(nipSplit[6]));
            sum = sum + (long)(6 * Character.getNumericValue(nipSplit[7]));
            sum = sum + (long)(7 * Character.getNumericValue(nipSplit[8]));
            log.debug((Object)"Sprawdzanie sumy kontrolnej");
            if (sum % 11L == (long)Character.getNumericValue(nipSplit[9])) {
                log.debug((Object)"Prawidlowa suma kontrolna");
                return true;
            }
            log.debug((Object)"Nieprawid\u0142owa suma kontrolna");
        } else {
            log.debug((Object)"ilo\u015b\u0107 cyfr NIPu rozna od 10");
        }
        return false;
    }
}

