/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.engine;

import com.fasterxml.jackson.annotation.JsonValue;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum StatusCode {
    ACTIVE("czynny", "CZYNNY"),
    RELEASED("zwolniony", "ZWOLNIONY"),
    INCORRECT("Niepoprawny nr NIP", "NIEPOPRAWNY"),
    UNREGISTERED("NIP nie jest zarejestrowany", "NIEZAREJESTROWANY"),
    WEBSITE_IS_UNAVAILABLE("Brak po\u0142\u0105czenia z Internetem", "STRONA_NIEDOSTEPNA"),
    ACTIVE_VIES("Tak, numer VAT aktywny", "VIES_AKTYWNY"),
    INACTIVE_VIES("Nie, numer VAT nieaktywny", "VIES_NIEAKTYWNY"),
    OUTSIDE_THE_EU("NIP spoza PL i UE", "POZA_UE"),
    UNKNOWN("NIEZNANY_STATUS", "NIEZNANY"),
    NOT_FIGURED("NIP nie figuruje w rejestrze VAT", "NIE_FIGURUJE");

    private final String pattern;
    private final String code;

    public static StatusCode getCode(String status) {
        return Arrays.stream(StatusCode.values()).filter(statusCode -> statusCode.match(status)).findFirst().orElse(UNKNOWN);
    }

    public Boolean match(String status) {
        Pattern pattern = Pattern.compile(this.pattern);
        Matcher matcher = pattern.matcher(status);
        return matcher.find();
    }

    @JsonValue
    public String getCode() {
        return this.code;
    }

    @ConstructorProperties(value={"pattern", "code"})
    private StatusCode(String pattern, String code) {
        this.pattern = pattern;
        this.code = code;
    }
}

