/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.engine;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.suncode.plugin.check_status_vat.exception.UnknownStatusException;
import com.suncode.plugin.check_status_vat.schemas.Entity;
import com.suncode.plugin.check_status_vat.schemas.EntityException;
import com.suncode.plugin.check_status_vat.schemas.EntityResponse;
import com.suncode.plugin.check_status_vat.schemas.Entry;
import com.suncode.plugin.check_status_vat.schemas.EntryListResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EngineMFWebAPI {
    private static final Logger log = LoggerFactory.getLogger(EngineMFWebAPI.class);
    private final Object $lock = new Object[0];
    private static final String URL = "https://wl-api.mf.gov.pl/";
    private static final String CONNECTION_ERROR_MESSAGE = "Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF";
    private static final String SERVICE_UNAVAILABLE_MESSAGE = "Serwis Ministerstwa Finans\u00f3w jest chwilowo niedost\u0119pny \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF";
    private static final HttpRequestFactory REQUEST_FACTORY = new NetHttpTransport().createRequestFactory();
    private long connectionCounter = 0L;
    private String lastResetDate = "";
    private final LoadingCache<Pair<String, String>, Map<String, Object>> empCache = CacheBuilder.newBuilder().maximumSize(12000L).expireAfterWrite(12L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Pair<String, String>, Map<String, Object>>(){

        public Map<String, Object> load(Pair<String, String> key) throws IOException, UnknownStatusException {
            log.debug("No data in cache, fetching new data");
            return EngineMFWebAPI.this.connectionProcedure((String)key.getLeft(), (String)key.getRight());
        }
    });

    public Map<String, Object> getStatusDataByNip(String nip, String date) {
        String status;
        String tempNIP = nip.replaceAll("\\D", "");
        Map<String, Object> data = new HashMap();
        try {
            log.debug("Attempting to read data from cache");
            date = StringUtils.isBlank((CharSequence)date) ? this.currentDate() : date;
            Pair key = Pair.of((Object)tempNIP, (Object)date);
            data = (Map)this.empCache.get((Object)key);
            status = data.get("status").toString();
        }
        catch (ExecutionException ee) {
            log.debug(ee.getMessage(), (Throwable)ee);
            if (ee.getCause() instanceof UnknownStatusException) {
                UnknownStatusException uSE = (UnknownStatusException)ee.getCause();
                log.debug("Don't save to cache");
                status = uSE.getStatus();
                log.debug(UnknownStatusException.class.getSimpleName() + ":" + status);
            }
            log.error(CONNECTION_ERROR_MESSAGE, (Throwable)ee);
            status = CONNECTION_ERROR_MESSAGE;
        }
        data.put("status", status.replace(";", ","));
        return data;
    }

    public Map<String, Map<String, Object>> getStatusDataByNips(List<String> nips, String date) {
        HashMap<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();
        ArrayList<String> nipsToFetch = new ArrayList<String>();
        String normalizedDate = StringUtils.isBlank((CharSequence)date) ? this.currentDate() : date;
        for (String nip : nips) {
            String string = nip.trim();
            Pair key = Pair.of((Object)string, (Object)normalizedDate);
            Map cachedData = (Map)this.empCache.getIfPresent((Object)key);
            if (cachedData != null) {
                results.put(string, cachedData);
                continue;
            }
            nipsToFetch.add(string);
        }
        if (nipsToFetch.isEmpty()) {
            return results;
        }
        List batches = this.partitionList(nipsToFetch, 30);
        for (List<String> list : batches) {
            String batchString = String.join((CharSequence)",", list);
            this.logConnectionWithMF("BATCH:" + batchString);
            try {
                EntryListResponse entryListResponse;
                String urlApi = "https://wl-api.mf.gov.pl/api/search/nips/" + batchString;
                GenericUrl genericUrl = new GenericUrl(urlApi);
                genericUrl.put("date", (Object)normalizedDate);
                HttpRequest requestGET = REQUEST_FACTORY.buildGetRequest(genericUrl);
                log.debug("REQUEST URL\t" + genericUrl.build());
                requestGET.setConnectTimeout(180000);
                requestGET.setReadTimeout(180000);
                requestGET.setNumberOfRetries(100);
                HttpResponse response = requestGET.execute();
                int statusCode = response.getStatusCode();
                log.debug("StatusCode " + statusCode);
                String responseJSON = EngineMFWebAPI.readResponseContent(response.getContent());
                log.debug(responseJSON);
                Gson gson = new Gson();
                try {
                    entryListResponse = (EntryListResponse)gson.fromJson(responseJSON, EntryListResponse.class);
                }
                catch (JsonSyntaxException jsonException) {
                    log.error("Error parsing response from MF API for batch: " + batchString + ". Response is not valid JSON. Possible service access issue.", (Throwable)jsonException);
                    this.addServiceUnavailableErrorForBatch(list, results);
                    continue;
                }
                if (entryListResponse != null && entryListResponse.getResult() != null) {
                    Entry[] entries;
                    String requestId = entryListResponse.getResult().getRequestId();
                    String requestDateTimeString = entryListResponse.getResult().getRequestDateTime();
                    Timestamp requestDateTime = null;
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                        Date requestDateTimeDate = simpleDateFormat.parse(requestDateTimeString);
                        requestDateTime = new Timestamp(requestDateTimeDate.getTime());
                    }
                    catch (ParseException parseException) {
                        log.debug("ParseException while parsing date for batch", (Throwable)parseException);
                    }
                    if ((entries = entryListResponse.getResult().getEntries()) == null) continue;
                    for (Entry entry : entries) {
                        HashMap<String, Object> nipData = new HashMap<String, Object>();
                        String cleanNip = entry.getIdentifier();
                        boolean shouldCache = true;
                        if (entry.getError() != null) {
                            String errorMessage = entry.getError().getMessage();
                            log.debug("Error for NIP {}: {}", (Object)cleanNip, (Object)errorMessage);
                            nipData.put("status", errorMessage.replace(";", ","));
                            nipData.put("requestId", requestId);
                            nipData.put("requestDateTime", requestDateTime);
                            shouldCache = false;
                        } else if (entry.getSubjects() != null && entry.getSubjects().length > 0) {
                            Entity subject = entry.getSubjects()[0];
                            String status = subject.getStatusVat();
                            log.debug("NIP: {}\tStatus: {}", (Object)cleanNip, (Object)status);
                            nipData.put("status", this.statusMapper(status).replace(";", ","));
                            nipData.put("requestId", requestId);
                            nipData.put("requestDateTime", requestDateTime);
                        } else {
                            log.debug("No data for NIP: {}", (Object)cleanNip);
                            nipData.put("status", this.statusMapper(null).replace(";", ","));
                            nipData.put("requestId", requestId);
                            nipData.put("requestDateTime", requestDateTime);
                        }
                        results.put(cleanNip, nipData);
                        if (!shouldCache) continue;
                        Pair cacheKey = Pair.of((Object)cleanNip, (Object)normalizedDate);
                        this.empCache.put((Object)cacheKey, nipData);
                    }
                    continue;
                }
                log.warn("Invalid batch API response - missing result data");
                this.addConnectionErrorForBatch(list, results);
            }
            catch (Exception e) {
                log.error("Error during batch NIP status retrieval for batch: " + batchString, (Throwable)e);
                this.addConnectionErrorForBatch(list, results);
            }
        }
        return results;
    }

    public Map<String, Object> connectionProcedure(String nipRaw, String date) throws IOException, UnknownStatusException {
        log.debug("Connection procedure to Ministry of Finance API");
        this.logConnectionWithMF(nipRaw);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        String status = "";
        String requestId = "";
        Timestamp requestDateTime = null;
        Gson gson = new Gson();
        try {
            EntityResponse entityResponse;
            String urlApi = "https://wl-api.mf.gov.pl/api/search/nip/" + nipRaw;
            GenericUrl genericUrl = new GenericUrl(urlApi);
            genericUrl.put("date", (Object)date);
            HttpRequest requestGET = REQUEST_FACTORY.buildGetRequest(genericUrl);
            log.debug("REQUEST URL\t" + genericUrl.build());
            requestGET.setConnectTimeout(180000);
            requestGET.setReadTimeout(180000);
            requestGET.setNumberOfRetries(100);
            HttpResponse response = requestGET.execute();
            int statusCode = response.getStatusCode();
            log.debug("StatusCode " + statusCode);
            String responseJSON = EngineMFWebAPI.readResponseContent(response.getContent());
            log.debug(responseJSON);
            try {
                entityResponse = (EntityResponse)gson.fromJson(responseJSON, EntityResponse.class);
            }
            catch (JsonSyntaxException jsonException) {
                log.error("Error parsing response from MF API. Response is not valid JSON. Possible service access issue.", (Throwable)jsonException);
                throw new UnknownStatusException(SERVICE_UNAVAILABLE_MESSAGE);
            }
            if (entityResponse == null || entityResponse.getResult() == null) {
                log.error("MF API returned empty response");
                throw new UnknownStatusException(SERVICE_UNAVAILABLE_MESSAGE);
            }
            Entity subject = entityResponse.getResult().getSubject();
            status = subject == null ? null : subject.getStatusVat();
            requestId = entityResponse.getResult().getRequestId();
            String requestDateTimeString = entityResponse.getResult().getRequestDateTime();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            Date requestDateTimeDate = simpleDateFormat.parse(requestDateTimeString);
            requestDateTime = new Timestamp(requestDateTimeDate.getTime());
            log.debug("RequestID:\t" + entityResponse.getResult().getRequestId() + "\tRequestDateTime:\t" + entityResponse.getResult().getRequestDateTime() + "\tNIP:\t" + nipRaw + "\tDate:\t" + date + "\tStatus:\t" + status);
        }
        catch (HttpResponseException httpException) {
            int statusCode = httpException.getStatusCode();
            log.error("HttpResponseException - HTTP status code: " + statusCode);
            if (statusCode >= 400 && statusCode < 500) {
                try {
                    EntityException entityException = (EntityException)gson.fromJson(httpException.getContent(), EntityException.class);
                    log.debug(entityException.toString());
                    throw new UnknownStatusException(entityException.getMessage());
                }
                catch (JsonSyntaxException jsonException) {
                    log.error("Cannot parse error response from MF API", (Throwable)jsonException);
                    throw new UnknownStatusException(SERVICE_UNAVAILABLE_MESSAGE);
                }
            }
            log.error("Undocumented HTTP status code from MF API: " + statusCode);
            throw new UnknownStatusException(SERVICE_UNAVAILABLE_MESSAGE);
        }
        catch (ParseException parseException) {
            log.debug("ParseException");
        }
        returnData.put("status", this.statusMapper(status));
        returnData.put("requestId", requestId);
        returnData.put("requestDateTime", requestDateTime);
        return returnData;
    }

    private String currentDate() {
        return DateTime.now().toLocalDate().toString();
    }

    private String statusMapper(String status) {
        if (status == null) {
            return "Podmiot o podanym identyfikatorze podatkowym NIP nie figuruje w rejestrze VAT";
        }
        switch (status) {
            case "Czynny": {
                return "Podmiot o podanym identyfikatorze podatkowym NIP jest zarejestrowany jako podatnik VAT czynny";
            }
            case "Zwolniony": {
                return "Podmiot o podanym identyfikatorze podatkowym NIP jest zarejestrowany jako podatnik VAT zwolniony";
            }
            case "Niezarejestrowany": {
                return "Podmiot o podanym identyfikatorze podatkowym NIP nie jest zarejestrowany jako podatnik VAT";
            }
        }
        return status;
    }

    private static String readResponseContent(InputStream is) {
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);
        while (true) {
            int rsz = 0;
            try {
                rsz = ((Reader)in).read(buffer, 0, buffer.length);
                if (rsz < 0) break;
                out.append(buffer, 0, rsz);
            }
            catch (IOException e) {
                out.append(e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                break;
            }
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long logConnectionWithMF(String nipRaw) {
        Object object = this.$lock;
        synchronized (object) {
            String currentDate = this.currentDate();
            if (!currentDate.equals(this.lastResetDate)) {
                this.connectionCounter = 0L;
                this.lastResetDate = currentDate;
            }
            long currentConnectionNumber = ++this.connectionCounter;
            log.info("Connection #{} with MF for NIP: {} (day: {})", new Object[]{currentConnectionNumber, nipRaw, currentDate});
            return currentConnectionNumber;
        }
    }

    private <T> List<List<T>> partitionList(List<T> list, int batchSize) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += batchSize) {
            partitions.add(list.subList(i, Math.min(i + batchSize, list.size())));
        }
        return partitions;
    }

    private void addErrorEntity(List<String> nips, Map<String, Map<String, Object>> results, String errorMessage) {
        for (String nip : nips) {
            HashMap<String, String> errorData = new HashMap<String, String>();
            errorData.put("status", errorMessage);
            errorData.put("requestId", "");
            errorData.put("requestDateTime", null);
            results.put(nip, errorData);
        }
    }

    private void addConnectionErrorForBatch(List<String> nips, Map<String, Map<String, Object>> results) {
        this.addErrorEntity(nips, results, CONNECTION_ERROR_MESSAGE);
    }

    private void addServiceUnavailableErrorForBatch(List<String> nips, Map<String, Map<String, Object>> results) {
        this.addErrorEntity(nips, results, SERVICE_UNAVAILABLE_MESSAGE);
    }
}

