/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.engine;

public enum CountryCode {
    AT("AT", "Austria"),
    BE("BE", "Belgia"),
    BG("BG", "Bu\u0142garia"),
    CY("CY", "Cypr"),
    CZ("CZ", "Czechy"),
    DE("DE", "Niemcy"),
    DK("DK", "Dania"),
    EE("EE", "Estonia"),
    EL("EL", "Grecja"),
    ES("ES", "Hiszpania"),
    FI("FI", "Finlandia"),
    FR("FR", "Francja"),
    HR("HR", "Chorwacja"),
    HU("HU", "W\u0119gry"),
    IE("IE", "Irlandia"),
    IT("IT", "W\u0142ochy"),
    LT("LT", "Litwa"),
    LU("LU", "Luksemburg"),
    LV("LV", "\u0141otwa"),
    MT("MT", "Malta"),
    NL("NL", "Holandia"),
    PL("PL", "Polska"),
    PT("PT", "Portugalia"),
    RO("RO", "Rumunia"),
    SE("SE", "Szwecja"),
    SI("SI", "S\u0142owenia"),
    SK("SK", "S\u0142owacja"),
    SPOZA_UE("SPOZA_UE", "Spoza UE");

    private String code;
    private String name;

    private CountryCode(String code, String name) {
        this.name = name.trim();
        this.code = code.trim();
    }

    public String getName() {
        return this.name.trim();
    }

    public String getCode() {
        return this.code.trim();
    }

    public static CountryCode getCountryCode(String code) {
        if (code != null) {
            for (CountryCode countryCode : CountryCode.values()) {
                if (!code.trim().equalsIgnoreCase(countryCode.code)) continue;
                return countryCode;
            }
        }
        return null;
    }

    public static String getNameFromCode(String code) {
        if (code != null) {
            for (CountryCode countryCode : CountryCode.values()) {
                if (!code.equalsIgnoreCase(countryCode.code)) continue;
                return countryCode.name;
            }
        }
        return "Unknow Country";
    }

    public static Boolean hasCode(String code) {
        if (code != null) {
            for (CountryCode countryCode : CountryCode.values()) {
                if (!code.equalsIgnoreCase(countryCode.code)) continue;
                return true;
            }
        }
        return false;
    }
}

