/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.application;

import com.suncode.plugin.check_status_vat.categories.Categories;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPDto;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPTabDto;
import com.suncode.plugin.check_status_vat.service.StatusService;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class StatusVatTabApp {
    @Autowired
    private StatusService statusService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("status-vat-tab-app")).name("application.status-vat-tab.name")).description("application.status-vat-tab.desc")).category(new Category[]{Categories.NIPCHECKER})).icon((Icon)SilkIconPack.LORRY_LINK)).parameter().id("nips").name("nip-checker.param.nip.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("date").name("nip-checker.param.date.name").description("nip-checker.param.date.desc").type((Type)Types.DATE_ARRAY).optional().create()).parameter().id("controller-var").name("nip-checker.param.controller-var-tab.name").description("nip-checker.param.controller-var-tab.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("status").name("nip-checker.param.status-tab.name").description("nip-checker.param.status-tab.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("skip-empty-value").name("nip-checker.param.skip-empty-value.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("request-id").name("nip-checker.param.request-id.name").description("nip-checker.param.request-id.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("request-date-time").name("nip-checker.param.request-date-time.name").description("nip-checker.param.request-date-time.desc").type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param(value="nips") String[] nips, @Param(value="status") Variable statusVar, @Param(value="controller-var") Variable controllerVar, @Param(value="skip-empty-value") Boolean skipEmptyValue, @Param(value="request-id") Variable requestIdVar, @Param(value="request-date-time") Variable requestDateTimeVar, @Param(value="date") LocalDate[] date, ApplicationContext context, UserInfo userInfo) {
        this.getStatus(nips, statusVar, controllerVar, (WorkflowContext)context, userInfo, skipEmptyValue, requestIdVar, requestDateTimeVar, date);
    }

    public void set(@Param(value="nips") String[] nips, @Param(value="status") Variable statusVar, @Param(value="controller-var") Variable controllerVar, @Param(value="skip-empty-value") Boolean skipEmptyValue, @Param(value="request-id") Variable requestIdVar, @Param(value="request-date-time") Variable requestDateTimeVar, @Param(value="date") LocalDate[] date, AcceptanceContext context, UserInfo userInfo) {
        this.getStatus(nips, statusVar, controllerVar, (WorkflowContext)context, userInfo, skipEmptyValue, requestIdVar, requestDateTimeVar, date);
    }

    private void getStatus(String[] nips, Variable statusVar, Variable controllerVar, WorkflowContext workflowContext, UserInfo userInfo, Boolean skipEmptyValue, Variable requestIdVar, Variable requestDateTimeVar, LocalDate[] date) {
        List<StatusNIPTabDto> statusNipTabDto = this.convertToListDto(nips, date);
        this.statusService.fillStatuses(statusNipTabDto, skipEmptyValue);
        if (statusVar != null) {
            List statuses = statusNipTabDto.stream().map(StatusNIPDto::getStatus).collect(Collectors.toList());
            this.setVariableValue(statusVar, statuses, String.class);
        }
        if (controllerVar != null) {
            List statusCode = statusNipTabDto.stream().map(item -> this.getValidStatusCode((StatusNIPTabDto)item)).collect(Collectors.toList());
            this.setVariableValue(controllerVar, statusCode, String.class);
        }
        if (requestIdVar != null) {
            List requestIds = statusNipTabDto.stream().map(StatusNIPDto::getRequestId).collect(Collectors.toList());
            this.setVariableValue(requestIdVar, requestIds, String.class);
        }
        if (requestDateTimeVar != null) {
            if (requestDateTimeVar.getType() == Types.DATE_ARRAY) {
                List requestDateTimes = statusNipTabDto.stream().map(StatusNIPDto::getRequestDateTime).map(timestamp -> timestamp == null ? null : new LocalDate(timestamp)).collect(Collectors.toList());
                this.setVariableValue(requestDateTimeVar, requestDateTimes, LocalDate.class);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List requestDateTimes = statusNipTabDto.stream().map(StatusNIPDto::getRequestDateTime).map(timestamp -> timestamp == null ? null : simpleDateFormat.format((Date)timestamp)).collect(Collectors.toList());
                this.setVariableValue(requestDateTimeVar, requestDateTimes, String.class);
            }
        }
    }

    private List<StatusNIPTabDto> convertToListDto(String[] nips, LocalDate[] date) {
        return IntStream.range(0, nips.length).mapToObj(index -> {
            StatusNIPTabDto obj = new StatusNIPTabDto();
            obj.setNip(nips[index]);
            obj.setDate(date != null && date.length > index ? date[index] : DateTime.now().toLocalDate());
            obj.setRow(index);
            return obj;
        }).collect(Collectors.toList());
    }

    private <T> void setVariableValue(Variable variable, List<T> list, Class<T> clazz) {
        if (variable.isArray()) {
            variable.setValue((Object)list.toArray((Object[])Array.newInstance(clazz, list.size())));
        } else {
            variable.setValue((Object)list.stream().map(value -> value == null ? "null" : value.toString()).collect(Collectors.joining(",")));
        }
    }

    private String getValidStatusCode(StatusNIPTabDto item) {
        if (item.getStatusCode() == null) {
            return "";
        }
        return item.getStatusCode().getCode();
    }
}

