/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.application;

import com.suncode.plugin.check_status_vat.categories.Categories;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPDto;
import com.suncode.plugin.check_status_vat.service.CommentMsgService;
import com.suncode.plugin.check_status_vat.service.StatusService;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class StatusVatApp {
    @Autowired
    private StatusService statusService;
    @Autowired
    private CommentMsgService commentMsgService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("status-vat-app")).name("application.status-vat.name")).description("application.status-vat.desc")).category(new Category[]{Categories.NIPCHECKER})).icon((Icon)SilkIconPack.LORRY_LINK)).parameter().id("nip").name("nip-checker.param.nip.name").type((Type)Types.STRING).create()).parameter().id("date").name("nip-checker.param.date.name").description("nip-checker.param.date.desc").type((Type)Types.DATE).optional().create()).parameter().id("controller-var").name("nip-checker.param.controller-var.name").description("nip-checker.param.controller-var.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("status").name("nip-checker.param.status.name").description("nip-checker.param.status.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("on-off-comment").name("nip-checker.param.on-off-comment.name").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("request-id").name("nip-checker.param.request-id.name").description("nip-checker.param.request-id.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("request-date-time").name("nip-checker.param.request-date-time.name").description("nip-checker.param.request-date-time.desc").type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param(value="nip") String nip, @Param(value="status") Variable statusVar, @Param(value="controller-var") Variable controllerVar, @Param(value="on-off-comment") Boolean isOnComment, @Param(value="request-id") Variable requestIdVar, @Param(value="request-date-time") Variable requestDateTimeVar, @Param(value="date") LocalDate date, ApplicationContext context, UserInfo userInfo) {
        this.getStatus(nip, statusVar, controllerVar, isOnComment, requestIdVar, requestDateTimeVar, (WorkflowContext)context, userInfo, date);
    }

    public void set(@Param(value="nip") String nip, @Param(value="status") Variable statusVar, @Param(value="controller-var") Variable controllerVar, @Param(value="on-off-comment") Boolean isOnComment, @Param(value="request-id") Variable requestIdVar, @Param(value="request-date-time") Variable requestDateTimeVar, @Param(value="date") LocalDate date, AcceptanceContext context, UserInfo userInfo) {
        this.getStatus(nip, statusVar, controllerVar, isOnComment, requestIdVar, requestDateTimeVar, (WorkflowContext)context, userInfo, date);
    }

    private void getStatus(String nip, Variable statusVar, Variable controllerVar, Boolean isOnComment, Variable requestIdVar, Variable requestDateTimeVar, WorkflowContext workflowContext, UserInfo userInfo, LocalDate date) {
        StatusNIPDto statusNipDto = this.statusService.getOne(nip, date);
        if (isOnComment.booleanValue()) {
            String msg = this.commentMsgService.createMessage(statusNipDto.getNip(), this.commentMsgService.commentWhenConnectionWithMFIsUnavailable(statusNipDto.getStatus()));
            this.commentMsgService.comment(msg, userInfo != null ? userInfo.getUserName() : null, workflowContext.getActivityId(), workflowContext.getProcessId());
        }
        this.setVariable(controllerVar, statusNipDto.getStatusCode().getCode());
        this.setVariable(statusVar, statusNipDto.getStatus());
        this.setVariable(requestIdVar, statusNipDto.getRequestId());
        this.setVariable(requestDateTimeVar, statusNipDto.getRequestDateTime());
    }

    private void setVariable(Variable controllerVar, Object value) {
        if (controllerVar != null) {
            controllerVar.setValue(value);
        }
    }
}

