PWE.integrationComponent.registerValidator('status-vat-validator', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField('nip');
        form.addField('date');
        form.addField('nip-released-check');
        form.addField('nip-released-msg');
        form.addField('nip-blocked-check');
        form.addField({
            id: 'on-off-comment',
            hidden: true
        });
        form.addCombobox({
            id: "comment-type",
            values: [
                { id: "ALL", display: NIPCHECKER.t("dpwe.comment.all.name"), description: NIPCHECKER.t("dpwe.comment.all.desc") },
                { id: "NONE", display: NIPCHECKER.t("dpwe.comment.none.name"), description: NIPCHECKER.t("dpwe.comment.none.desc") },
                { id: "CONFIRM", display: NIPCHECKER.t("dpwe.comment.confirm.name"), description: NIPCHECKER.t("dpwe.comment.confirm.desc") },

            ]
        });
        if (form.getValue('comment-type') == 'UNSET') {
            var onOffComment = form.getValue('on-off-comment', false);
            form.setValue('comment-type', onOffComment ? 'ALL' : 'NONE');
        }
    }
});