/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.validator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.plugin.check_status_vat.categories.Categories;
import com.suncode.plugin.check_status_vat.enums.CommentType;
import com.suncode.plugin.check_status_vat.schemas.MessageConfirm;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPTabDto;
import com.suncode.plugin.check_status_vat.schemas.ValidInfo;
import com.suncode.plugin.check_status_vat.schemas.ValidNipStatus;
import com.suncode.plugin.check_status_vat.service.CommentMsgService;
import com.suncode.plugin.check_status_vat.service.StatusService;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ValidatorsScript(value="scripts/validators-callbacks/status-vat-validator-callback.js")
@ComponentsFormScript(value="scripts/dpwe/dpwe-check-nip-validator-form.js")
public class StatusVatValidator {
    private static final String CONFIRMATION_QUESTION = "Czy faktura jest poprawna?";
    private static final String CONFIRMATION_TITLE = "Ostrze\u017cenie: Sprawd\u017a fakture";
    private static final Cache<String, String> ADDED_COMMENTS_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @Autowired
    private CommentMsgService commentMsgService;
    @Autowired
    private StatusService statusService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("status-vat-validator")).name("validator.status-vat.name")).description("validator.status-vat.desc")).category(new Category[]{Categories.NIPCHECKER})).parameter().id("nip").name("nip-checker.param.nip.name").type((Type)Types.VARIABLE).create()).parameter().id("date").name("nip-checker.param.date.name").description("nip-checker.param.date.desc").type((Type)Types.DATE).optional().create()).parameter().id("nip-released-check").name("nip-checker.param.nip-released-check.name").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("nip-released-msg").name("nip-checker.param.nip-released-msg.name").type((Type)Types.STRING).optional().create()).parameter().id("nip-blocked-check").name("nip-checker.param.nip-blocked-check.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("on-off-comment").name("nip-checker.param.on-off-comment.name").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("comment-type").name("nip-checker.param.on-off-comment.name").type((Type)Types.STRING).defaultValue((Object)"UNSET").create();
    }

    public void validate(@Param(value="nip") Variable nipVar, @Param(value="nip-released-check") Boolean isNipReleased, @Param(value="nip-released-msg") String msg, @Param(value="nip-blocked-check") Boolean isNipBlocked, @Param(value="on-off-comment") Boolean isOnComment, @Param(value="comment-type") String commentTypeStr, @Param(value="date") LocalDate date, ValidationErrors errors, UserInfo userInfo, ValidationContext validationContext) {
        CommentType commentType = CommentType.valueOf(commentTypeStr.toUpperCase());
        ValidInfo validInfo = new ValidInfo();
        validInfo.setIsArray(nipVar.isArray());
        String nipValue = (String)nipVar.getValue();
        if (!nipVar.isArray()) {
            ValidNipStatus validNipStatus = new ValidNipStatus(this.statusService.getOne(nipValue, date));
            validNipStatus.setNipId(nipVar.getId());
            this.valid(isNipReleased, isNipBlocked, validNipStatus, validInfo);
        }
        this.addCommentAndErrors(msg, isOnComment, commentType, errors, userInfo, validationContext, validInfo, nipValue, date);
    }

    private void addCommentAndErrors(String msg, Boolean isOnComment, CommentType commentType, ValidationErrors errors, UserInfo userInfo, ValidationContext validationContext, ValidInfo validInfo, String nipValue, LocalDate date) {
        String comment = this.buildComment(validInfo);
        List<ValidNipStatus> errorNips = this.selectErrorNips(validInfo);
        String key = this.buildKey(validationContext, nipValue, date);
        if (errorNips.isEmpty()) {
            if (commentType != CommentType.CONFIRM && this.shouldAddComment(key)) {
                this.addStandardComment(isOnComment, commentType, userInfo, validationContext, comment);
                this.rememberComment(key, comment);
            }
        } else if (validInfo.getErrorVar().booleanValue()) {
            if (commentType != CommentType.CONFIRM && this.shouldAddComment(key)) {
                this.addStandardComment(isOnComment, commentType, userInfo, validationContext, comment);
                this.rememberComment(key, comment);
            }
            this.addErrors(errors, errorNips);
        } else {
            MessageConfirm msgConfirm = this.buildMsgConfirm(msg, this.commentMsgService.commentWhenConnectionWithMFIsUnavailable(comment), errorNips);
            if (this.isStandardCommentOn(isOnComment, commentType) && this.shouldAddComment(key)) {
                this.addComment(comment, userInfo, validationContext);
                this.rememberComment(key, comment);
            } else if (commentType == CommentType.CONFIRM) {
                msgConfirm.setAddComment(true);
            }
            errors.invokeCallback((Object)msgConfirm);
        }
    }

    private void addErrors(ValidationErrors errors, List<ValidNipStatus> errorNips) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.commentMsgService.createMessage(new LinkedList<StatusNIPTabDto>(errorNips)));
        for (ValidNipStatus validError : errorNips) {
            errors.add(validError.getStatus(), validError.getNipId());
        }
        errors.add(sb.toString());
    }

    private void addStandardComment(Boolean isOnComment, CommentType commentType, UserInfo userInfo, ValidationContext validationContext, String comment) {
        if (this.isStandardCommentOn(isOnComment, commentType)) {
            this.addComment(comment, userInfo, validationContext);
        }
    }

    private boolean isStandardCommentOn(Boolean isOnComment, CommentType commentType) {
        return commentType == CommentType.UNSET && isOnComment != false || commentType == CommentType.ALL;
    }

    private MessageConfirm buildMsgConfirm(String msg, String comment, List<ValidNipStatus> errorNips) {
        MessageConfirm msgConfirm = new MessageConfirm();
        StringBuilder sb = new StringBuilder();
        sb.append(this.commentMsgService.createMessage(new LinkedList<StatusNIPTabDto>(errorNips)));
        sb.append("<br><br>").append(CONFIRMATION_QUESTION);
        msgConfirm.setCommentMsg(comment);
        msgConfirm.setTitle(CONFIRMATION_TITLE);
        msgConfirm.setMsg(StringUtils.isNotBlank((CharSequence)msg) ? msg : sb.toString());
        return msgConfirm;
    }

    private void addComment(String comment, UserInfo userInfo, ValidationContext validationContext) {
        this.commentMsgService.comment(comment, userInfo != null ? userInfo.getUserName() : null, validationContext.getActivityId(), validationContext.getProcessId());
    }

    private String buildComment(ValidInfo validInfo) {
        List<ValidNipStatus> validInfos = validInfo.getValidedData();
        if (validInfo.getIsArray().booleanValue()) {
            return this.commentMsgService.createMessage(new LinkedList<StatusNIPTabDto>(validInfos));
        }
        return this.commentMsgService.createMessage(validInfos.get(0).getNip(), validInfos.get(0).getStatus());
    }

    private void valid(Boolean isNipReleased, Boolean isNipBlocked, ValidNipStatus validNipStatus, ValidInfo validInfo) {
        Boolean errorFlag = validInfo.getErrorVar();
        validNipStatus.setConfirm(true);
        validNipStatus.setError(false);
        switch (validNipStatus.getStatusCode()) {
            case RELEASED: {
                if (!isNipReleased.booleanValue()) break;
                validNipStatus.setError(true);
                break;
            }
            case UNREGISTERED: {
                validNipStatus.setConfirm(isNipBlocked);
                validNipStatus.setError(true);
                if (isNipBlocked.booleanValue()) break;
                errorFlag = true;
                break;
            }
            case INCORRECT: {
                validNipStatus.setConfirm(false);
                validNipStatus.setError(true);
                errorFlag = true;
                break;
            }
            case UNKNOWN: 
            case OUTSIDE_THE_EU: 
            case NOT_FIGURED: 
            case INACTIVE_VIES: 
            case WEBSITE_IS_UNAVAILABLE: {
                validNipStatus.setError(true);
                break;
            }
        }
        validInfo.setErrorVar(errorFlag);
        validInfo.getValidedData().add(validNipStatus);
    }

    private List<ValidNipStatus> selectErrorNips(ValidInfo validInfo) {
        return validInfo.getValidedData().stream().filter(ValidNipStatus::isError).collect(Collectors.toList());
    }

    private String buildKey(ValidationContext validationContext, String nipValue, LocalDate date) {
        String dateString = date != null ? date.toString() : null;
        return String.format("%s|%s|%s|%s", validationContext.getProcessId(), validationContext.getActivityId(), nipValue, dateString);
    }

    private boolean shouldAddComment(String key) {
        return ADDED_COMMENTS_CACHE.getIfPresent((Object)key) == null;
    }

    private void rememberComment(String key, String comment) {
        ADDED_COMMENTS_CACHE.put((Object)key, (Object)comment);
    }
}

