/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.service;

import com.suncode.plugin.check_status_vat.engine.CountryCode;
import com.suncode.plugin.check_status_vat.engine.EngineMFWebAPI;
import com.suncode.plugin.check_status_vat.engine.StatusCode;
import com.suncode.plugin.check_status_vat.engine.VerificationNIP;
import com.suncode.plugin.check_status_vat.engine.vies.service.VIESService;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPDto;
import com.suncode.plugin.check_status_vat.schemas.StatusNIPTabDto;
import com.suncode.plugin.check_status_vat.service.StatusService;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatusServiceImpl
implements StatusService {
    @Autowired
    private VIESService engineVies;
    @Autowired
    private EngineMFWebAPI engineMF;

    @Override
    public void fillStatuses(List<StatusNIPTabDto> nips) {
        for (StatusNIPTabDto nipStatus : nips) {
            StatusNIPDto statusNIP = this.getOne(nipStatus.getNip(), nipStatus.getDate());
            nipStatus.setStatus(statusNIP.getStatus());
            nipStatus.setStatusCode(statusNIP.getStatusCode());
            nipStatus.setRequestId(statusNIP.getRequestId());
            nipStatus.setRequestDateTime(statusNIP.getRequestDateTime());
        }
    }

    @Override
    public StatusNIPDto getOne(String nip, LocalDate date) {
        String dateString = date == null ? "" : date.toString();
        Map<String, Object> data = this.getStatus(nip, dateString);
        String status = data.get("status").toString();
        String requestId = data.get("requestId") == null ? "" : data.get("requestId").toString();
        Timestamp requestDateTime = (Timestamp)data.get("requestDateTime");
        StatusNIPDto statusNip = new StatusNIPDto();
        statusNip.setNip(nip);
        statusNip.setStatus(status);
        statusNip.setStatusCode(StatusCode.getCode(status));
        statusNip.setRequestId(requestId);
        statusNip.setRequestDateTime(requestDateTime);
        return statusNip;
    }

    private Map<String, Object> getStatus(String nip, String date) {
        Map<String, Object> data = new HashMap<String, Object>();
        String status = "Niepoprawny nr NIP";
        if (StringUtils.isNotBlank((String)nip)) {
            switch (VerificationNIP.getCountry(nip)) {
                case PL: {
                    if (VerificationNIP.verifyPL(nip).booleanValue()) {
                        data = this.engineMF.getStatusDataByNip(nip, date);
                        status = data.get("status").toString();
                        break;
                    }
                    status = "Niepoprawny nr NIP";
                    break;
                }
                case SPOZA_UE: {
                    status = "NIP spoza PL i UE \u2013 nie podlega weryfikacji";
                    break;
                }
                default: {
                    data = this.engineVies.getStatusVatDataByNip(nip);
                    status = data.get("status").toString();
                }
            }
        }
        data.put("status", status);
        return data;
    }

    @Override
    public void fillStatuses(List<StatusNIPTabDto> nips, Boolean skipEmptyValue) {
        String currentDate = DateTime.now().toLocalDate().toString();
        Map<String, List<StatusNIPTabDto>> nipsByDate = nips.stream().filter(nip -> StringUtils.isNotBlank((String)nip.getNip())).collect(Collectors.groupingBy(nip -> nip.getDate() != null ? nip.getDate().toString() : currentDate));
        for (Map.Entry<String, List<StatusNIPTabDto>> entry : nipsByDate.entrySet()) {
            String date = entry.getKey();
            List<StatusNIPTabDto> nipsForDate = entry.getValue();
            this.fillStatusesForDate(nipsForDate, date);
        }
        for (StatusNIPTabDto nipStatus : nips) {
            if (!StringUtils.isBlank((String)nipStatus.getNip())) continue;
            if (skipEmptyValue.booleanValue()) {
                nipStatus.setStatus("");
                continue;
            }
            nipStatus.setStatus("Niepoprawny nr NIP");
            nipStatus.setStatusCode(StatusCode.getCode("Niepoprawny nr NIP"));
        }
    }

    private void fillStatusesForDate(List<StatusNIPTabDto> nips, String date) {
        if (nips.isEmpty()) {
            return;
        }
        List polishValidNips = nips.stream().filter(nip -> VerificationNIP.getCountry(nip.getNip()) == CountryCode.PL).filter(nip -> VerificationNIP.verifyPL(nip.getNip())).collect(Collectors.toList());
        List otherNips = nips.stream().filter(nip -> {
            CountryCode country = VerificationNIP.getCountry(nip.getNip());
            return country != CountryCode.PL || VerificationNIP.verifyPL(nip.getNip()) == false;
        }).collect(Collectors.toList());
        if (!polishValidNips.isEmpty()) {
            List<String> cleanNips = polishValidNips.stream().map(StatusNIPDto::getNip).map(nip -> nip.replaceAll("\\D", "")).collect(Collectors.toList());
            Map<String, Map<String, Object>> results = this.engineMF.getStatusDataByNips(cleanNips, date);
            for (StatusNIPTabDto nipStatus : polishValidNips) {
                String cleanNip = nipStatus.getNip().replaceAll("\\D", "");
                Map<String, Object> data = results.get(cleanNip);
                if (data == null) continue;
                this.mapDataToDto(nipStatus, data);
            }
        }
        for (StatusNIPTabDto nipStatus : otherNips) {
            StatusNIPDto statusNIP = this.getOne(nipStatus.getNip(), nipStatus.getDate());
            this.mapStatusNIPToDto(nipStatus, statusNIP);
        }
    }

    private void mapDataToDto(StatusNIPTabDto nipStatus, Map<String, Object> data) {
        String status = data.get("status").toString();
        String requestId = data.get("requestId") == null ? "" : data.get("requestId").toString();
        Timestamp requestDateTime = (Timestamp)data.get("requestDateTime");
        nipStatus.setStatus(status);
        nipStatus.setStatusCode(StatusCode.getCode(status));
        nipStatus.setRequestId(requestId);
        nipStatus.setRequestDateTime(requestDateTime);
    }

    private void mapStatusNIPToDto(StatusNIPTabDto nipStatus, StatusNIPDto statusNIP) {
        nipStatus.setStatus(statusNIP.getStatus());
        nipStatus.setStatusCode(statusNIP.getStatusCode());
        nipStatus.setRequestId(statusNIP.getRequestId());
        nipStatus.setRequestDateTime(statusNIP.getRequestDateTime());
    }
}

