/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.service;

import com.suncode.plugin.check_status_vat.schemas.StatusNIPTabDto;
import com.suncode.plugin.check_status_vat.service.CommentMsgService;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentMsgServiceImpl
implements CommentMsgService {
    @Autowired
    private CommentService commentService;

    @Override
    public String createMessage(String nip, String status) {
        return "NIP: " + nip + "<br>Status: " + status;
    }

    @Override
    public String createMessage(List<StatusNIPTabDto> statusesNipTabDto) {
        if (statusesNipTabDto.size() == 1) {
            return this.createMessage(statusesNipTabDto.get(0).getNip(), statusesNipTabDto.get(0).getStatus());
        }
        return this.createTabMessage(statusesNipTabDto);
    }

    @Override
    public String createTabMessage(List<StatusNIPTabDto> statusesNipTabDto) {
        String msg = "";
        StringBuilder sb = new StringBuilder();
        Boolean firstLoop = true;
        for (StatusNIPTabDto statusNIPTabDto : statusesNipTabDto) {
            if (!firstLoop.booleanValue()) {
                sb.append("<br>");
            }
            sb.append("[").append(statusNIPTabDto.getRow() + 1).append("]");
            sb.append(" NIP: ").append(statusNIPTabDto.getNip());
            sb.append(" Status: ").append(statusNIPTabDto.getStatus());
            firstLoop = false;
        }
        msg = sb.toString();
        return msg;
    }

    @Override
    public String commentWhenConnectionWithMFIsUnavailable(String msg) {
        if (msg.contains("Brak po\u0142\u0105czenia z Internetem")) {
            msg = "Brak po\u0142\u0105czenia z Ministerstwem finans\u00f3w\u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF. W celu rozwi\u0105zania problemu skontaktuj si\u0119 z administratorem sieci";
        }
        return msg;
    }

    @Override
    public void comment(String msg, String userName, String activityId, String processId) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        if (msg.length() > 3900) {
            msg = msg.substring(0, 3900) + "...";
        }
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setTimestamp(Long.valueOf(new DateTime().getMillis()));
        comment.setUserId(StringUtils.isBlank((CharSequence)userName) ? "admin" : userName);
        comment.setComment(msg);
        this.commentService.createComment(comment);
    }
}

