/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.engine.vies.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.suncode.plugin.check_status_vat.engine.vies.model.ViesVatStatus;
import com.suncode.plugin.check_status_vat.engine.vies.service.VIESService;
import com.suncode.plugin.check_status_vat.exception.InvalidStatusReceivedException;
import com.suncode.plugin.check_status_vat.exception.UnknownStatusException;
import com.suncode.plugin.check_status_vat.exception.ViesUserErrorException;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VIESServiceImpl
implements VIESService {
    private static final Logger log = LoggerFactory.getLogger(VIESServiceImpl.class);
    private static final Gson GSON;
    private static final OkHttpClient CLIENT;
    private static final List<String> ALLOWED_USER_ERROR_STATUS;
    private static final String STATUS_VALID = "VALID";
    private static final String STATUS_INVALID = "INVALID";
    private static final String NOT_CACHING_MSG = "Don't save to cache";
    private static final String STATUS_VALID_MSG = "Tak, numer VAT aktywny";
    private static final String STATUS_INVALID_MSG = "Nie, numer VAT nieaktywny";
    private static final String VIES_URL = "https://ec.europa.eu/taxation_customs/vies/rest-api/ms/";
    private final LoadingCache<String, Map<String, Object>> empCache = CacheBuilder.newBuilder().maximumSize(12000L).expireAfterWrite(12L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Map<String, Object>>(){

        public Map<String, Object> load(@NotNull String nip) throws IOException, UnknownStatusException, ViesUserErrorException, InvalidStatusReceivedException {
            log.info("Brak danych w cache. Pobieranie nowych danych dla NIP: " + nip);
            ViesVatStatus nipStatus = VIESServiceImpl.this.loadNipStatusFromVIES(nip);
            String status = nipStatus.isValid() ? VIESServiceImpl.STATUS_VALID_MSG : VIESServiceImpl.STATUS_INVALID_MSG;
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("status", status);
            returnData.put("requestId", nipStatus.getRequestIdentifier());
            Timestamp requestDateTime = this.covertStringToTimestamp(nipStatus.getRequestDate());
            returnData.put("requestDateTime", requestDateTime);
            VIESServiceImpl.this.checkToCache(status);
            return returnData;
        }

        private Timestamp covertStringToTimestamp(String requestDate) {
            Timestamp requestDateTime = null;
            try {
                String requestDateTimeString = requestDate;
                ZonedDateTime requestDateTimeZonedDateTime = ZonedDateTime.parse(requestDateTimeString);
                ZoneId zone = ZoneId.of(ZoneId.systemDefault().getId());
                ZonedDateTime destrequestDateTimeZonedDateTime = requestDateTimeZonedDateTime.withZoneSameInstant(zone);
                requestDateTime = Timestamp.from(destrequestDateTimeZonedDateTime.toInstant());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return requestDateTime;
        }
    });

    private void checkToCache(String status) throws UnknownStatusException {
        Pattern pViesYes = Pattern.compile(STATUS_VALID_MSG);
        Matcher mViesYes = pViesYes.matcher(status);
        Pattern pViesNo = Pattern.compile(STATUS_INVALID_MSG);
        Matcher mViesNo = pViesNo.matcher(status);
        if (!mViesYes.find() && !mViesNo.find()) {
            throw new UnknownStatusException(status);
        }
        log.trace("Status VIES: " + status);
    }

    private ViesVatStatus loadNipStatusFromVIES(String nip) throws IOException, ViesUserErrorException, InvalidStatusReceivedException {
        String countryCode = nip.substring(0, 2);
        String nipNumber = nip.substring(2);
        String endpoint = String.format("%s/vat/%s", countryCode, nipNumber);
        Request request = new Request.Builder().url(VIES_URL + endpoint).build();
        ViesVatStatus response = this.executeRequest(request, ViesVatStatus.class);
        if (!ALLOWED_USER_ERROR_STATUS.contains(response.getUserError())) {
            throw new ViesUserErrorException("Response failed with: " + response.getUserError());
        }
        if (Objects.equals(response.getUserError(), STATUS_INVALID)) {
            throw new InvalidStatusReceivedException(STATUS_INVALID_MSG);
        }
        return response;
    }

    @NotNull
    private <T> T executeRequest(Request request, Class<T> classOfResponse) throws IOException, ViesUserErrorException {
        log.info(GSON.toJson((Object)request));
        try (Response response = CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn("Response code: " + response.code());
                throw new ViesUserErrorException("Response failed with code: " + response.code());
            }
            String responseStr = Objects.requireNonNull(response.body()).string();
            log.info(responseStr);
            log.info("ClassName: " + classOfResponse.getName());
            Object object = GSON.fromJson(responseStr, classOfResponse);
            return (T)object;
        }
    }

    @Override
    public Map<String, Object> getStatusVatDataByNip(String nip) {
        String status;
        String tempNIP = nip.toUpperCase().replaceAll("\\W", "");
        Map<String, Object> data = new HashMap();
        try {
            data = (Map)this.empCache.get((Object)tempNIP);
            status = data.get("status").toString();
        }
        catch (ExecutionException ex) {
            log.info(NOT_CACHING_MSG);
            Throwable cause = ex.getCause();
            if (cause instanceof ExecutionException) {
                status = cause.getMessage();
                log.warn(cause.getClass().getSimpleName() + ": " + status);
            }
            status = "Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent europejski nie zosta\u0142 zweryfikowany w systemie VIES.";
        }
        status = status.replace(";", ",");
        log.info(status);
        data.put("status", status);
        return data;
    }

    static {
        ALLOWED_USER_ERROR_STATUS = new ArrayList<String>(Arrays.asList(STATUS_VALID, STATUS_INVALID));
        CLIENT = new OkHttpClient.Builder().connectTimeout(40L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
        GSON = new Gson();
    }
}

