/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.check_status_vat.engine;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.pwfl.util.SpringContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class EngineMF
extends CacheLoader<String, String> {
    public static Logger log = Logger.getLogger(EngineMF.class);
    private final LoadingCache<String, String> empCache = CacheBuilder.newBuilder().maximumSize(8000L).expireAfterWrite(12L, TimeUnit.HOURS).build((CacheLoader)this);
    private CookieManager cookieManagegr;
    private HttpRequestFactory requestFactory;
    private HttpHeaders lastResponseHeader;

    public static EngineMF get() {
        return (EngineMF)((Object)SpringContext.getBean(EngineMF.class));
    }

    public String getStatusVat(String nip) {
        String tempNIP = nip.replaceAll("\\D", "");
        String status = "";
        try {
            log.debug((Object)"Pr\u00f3ba odczytu danych z cache");
            status = (String)this.empCache.get((Object)tempNIP);
        }
        catch (Exception e) {
            log.error((Object)e);
            status = "Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF";
        }
        return status.replace(";", ",");
    }

    private void firstConnection() throws IOException {
        String url = "https://ppuslugi.mf.gov.pl/";
        log.debug((Object)("Pierwsze poloczenia na adres:" + url));
        HttpRequest requestGET = this.requestFactory.buildGetRequest(new GenericUrl(url));
        HttpHeaders requestHeaders = requestGET.getHeaders();
        requestHeaders.setUserAgent("Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, likeGecko) Chrome/59.0.3071.115 Safari/537.36");
        requestHeaders.setAcceptEncoding("gzip, deflate, br");
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("accept-language", new String("pl-PL,pl;q=0.8,en-US;q=0.6,en;q=0.4"));
        mapHead.put("connection", new String("keep-alive"));
        mapHead.put("host", new String("ppuslugi.mf.gov.pl"));
        mapHead.put("upgrade-insecure-requests", new String("1"));
        requestHeaders.setUnknownKeys(mapHead);
        requestGET.setHeaders(requestHeaders);
        HttpResponse response = requestGET.execute();
        this.lastResponseHeader = response.getHeaders();
    }

    private void secondConnection() throws IOException {
        String url = "https://ppuslugi.mf.gov.pl/_/ExecuteAction";
        log.debug((Object)("Drugie poloczenia na adres:" + url));
        List fast_verlast = (List)this.lastResponseHeader.getUnknownKeys().get("fast-ver-last");
        List fast_verlast_source = (List)this.lastResponseHeader.getUnknownKeys().get("fast-ver-source");
        String fast_when = String.valueOf(DateTime.now().getMillis());
        String fast_verlast_source_uri = URLEncoder.encode(fast_verlast_source.get(0).toString());
        String fast_verlast_uri = URLEncoder.encode(fast_verlast.get(0).toString());
        StringBuilder sb = new StringBuilder();
        sb.append("ACTION__=1005&FLOW__=&TYPE__=FLOW&CLOSECONFIRMED__=false&FAST_VERLAST__=").append(fast_verlast_uri).append("&FAST_VERLAST_SOURCE__=").append(fast_verlast_source_uri).append("&FAST_CLIENT_WHEN__=").append(fast_when).append("&FAST_CLIENT_WINDOW__=FWDC.WND-3956-bd75-cce0&FAST_CLIENT_AJAX_ID__=1");
        ByteArrayContent httpContent = ByteArrayContent.fromString((String)"application/x-www-form-urlencoded", (String)sb.toString());
        HttpRequest requestPOST = this.requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)httpContent);
        StringBuilder sbCookies = new StringBuilder("");
        for (HttpCookie cookie : this.cookieManagegr.getCookieStore().getCookies()) {
            sbCookies.append(cookie.getName()).append("=").append(cookie.getValue()).append(" ; ");
        }
        HttpHeaders requestHeaders = requestPOST.getHeaders();
        requestHeaders.setCookie(sbCookies.toString());
        requestHeaders.setAccept("application/json, text/javascript, */*; q=0.01");
        requestHeaders.setAcceptEncoding("gzip, deflate, br");
        requestHeaders.setContentType("application/x-www-form-urlencoded");
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("origin", new String("https://ppuslugi.mf.gov.pl"));
        mapHead.put("connection", new String("keep-alive"));
        mapHead.put("host", new String("ppuslugi.mf.gov.pl"));
        mapHead.put("referer", new String("https://ppuslugi.mf.gov.pl/_/"));
        mapHead.put("x-requested-with", new String("XMLHttpRequest"));
        requestHeaders.setUnknownKeys(mapHead);
        requestPOST.setHeaders(requestHeaders);
        this.lastResponseHeader = requestPOST.execute().getHeaders();
    }

    private String lastConnection(String nip) throws IOException {
        String url = "https://ppuslugi.mf.gov.pl/_/EventOccurred";
        log.debug((Object)("Ostatnie poloczenia na adres:" + url));
        log.debug((Object)("Sprawdzanie NIP: \t" + nip));
        List fast_verlast = (List)this.lastResponseHeader.getUnknownKeys().get("fast-ver-last");
        List fast_verlast_source = (List)this.lastResponseHeader.getUnknownKeys().get("fast-ver-source");
        String fast_when = String.valueOf(DateTime.now().getMillis());
        String fast_verlast_source_uri = URLEncoder.encode(fast_verlast_source.get(0).toString());
        String fast_verlast_uri = URLEncoder.encode(fast_verlast.get(0).toString());
        StringBuilder sb = new StringBuilder();
        sb.append("b-6=NIP&b-7=").append(nip).append("&LASTFOCUSFIELD__=b-7&DOC_MODAL_ID__=0&EVENT__=b-8&TYPE__=0&CLOSECONFIRMED__=false&FAST_VERLAST__=").append(fast_verlast_uri).append("&FAST_VERLAST_SOURCE__=").append(fast_verlast_source_uri).append("&FAST_CLIENT_WHEN__=").append(fast_when).append("&FAST_CLIENT_WINDOW__=FWDC.WND-3956-bd75-cce0&FAST_CLIENT_AJAX_ID__=1");
        ByteArrayContent httpContent = ByteArrayContent.fromString((String)"application/x-www-form-urlencoded", (String)sb.toString());
        HttpRequest requestPOST = this.requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)httpContent);
        StringBuilder sbCookies = new StringBuilder("");
        for (HttpCookie cookie : this.cookieManagegr.getCookieStore().getCookies()) {
            sbCookies.append(cookie.getName()).append("=").append(cookie.getValue()).append(" ; ");
        }
        HttpHeaders requestHeaders = requestPOST.getHeaders();
        requestHeaders.setCookie(sbCookies.toString());
        requestHeaders.setAccept("application/json, text/javascript, */*; q=0.01");
        requestHeaders.setAcceptEncoding("gzip, deflate, br");
        requestHeaders.setContentType("application/x-www-form-urlencoded");
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("origin", new String("https://ppuslugi.mf.gov.pl"));
        mapHead.put("connection", new String("keep-alive"));
        mapHead.put("host", new String("ppuslugi.mf.gov.pl"));
        mapHead.put("referer", new String("https://ppuslugi.mf.gov.pl/_/"));
        mapHead.put("x-requested-with", new String("XMLHttpRequest"));
        mapHead.put("post", new String("/_/EventOccurred HTTP/1.1"));
        requestHeaders.setUnknownKeys(mapHead);
        requestPOST.setHeaders(requestHeaders);
        HttpResponse response = requestPOST.execute();
        this.lastResponseHeader = response.getHeaders();
        return this.getStatusFromResponse(response.getContent());
    }

    private String getStatusFromResponse(InputStream is) {
        String status = "";
        log.debug((Object)"Odczytywanie statusu nip z otrzymanej strony");
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);
        while (true) {
            int rsz = 0;
            try {
                rsz = ((Reader)in).read(buffer, 0, buffer.length);
            }
            catch (IOException e) {
                out.append(e.getMessage());
                log.error((Object)e);
            }
            if (rsz < 0) break;
            out.append(buffer, 0, rsz);
        }
        try {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map map = new HashMap();
            map = (Map)new Gson().fromJson(out.toString(), type);
            Document doc = Jsoup.parse((String)((String)map.get("html")));
            Elements info = doc.select("#caption2_b-3");
            if (info != null && !info.isEmpty()) {
                String infoString = info.html().replaceAll("<br><br>", "\n");
                status = infoString.trim();
            } else {
                status = "Nieznany satus";
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        log.debug((Object)("Status podatnika VAT: " + status));
        return status;
    }

    public String connectionProcedure(String nipRaw) throws IOException {
        log.debug((Object)"Procedura po\u0142\u0105czenia z Ministerstwem Finas\u00f3w:");
        this.init();
        String status = "";
        this.firstConnection();
        this.secondConnection();
        String nip = nipRaw.replaceAll("\\D", "");
        status = this.lastConnection(nip);
        return status;
    }

    private void init() {
        log.debug((Object)"Inicjalizacja CookieManager oraz NetHttpTransport");
        this.cookieManagegr = new CookieManager();
        CookieHandler.setDefault(this.cookieManagegr);
        this.requestFactory = new NetHttpTransport().createRequestFactory();
    }

    public String load(String nip) throws IOException {
        log.debug((Object)"Brak danych w cache, pobieranie nowych");
        return this.connectionProcedure(nip);
    }
}

