/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.system.tools.external.users;

import com.plusmpm.util.Tools;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.cuf.mail.TemplateMailContent;
import com.suncode.cuf.util.CufComponentFactory;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.util.extension.P0015.userAuthentication.UserAuthenticationData;
import com.suncode.util.extension.P0015.userAuthentication.dao.UserAuthenticationDao;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UsersImport {
    public static Logger sysTaskLog = Logger.getLogger(UsersImport.class);
    @Autowired
    private UserAuthenticationDao userAuthenticationDao;

    public void ImportUsersFromXLSUnix(String sXlsPath, String sXlsFileName) {
        sysTaskLog.trace((Object)"************ ImportUsersFromXLS *************");
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            Object wb = null;
            Path path = Paths.get(sXlsPath + sXlsFileName, new String[0]);
            InputStream is = Files.newInputStream(path, StandardOpenOption.READ);
            String fileName = path.getFileName().toString().toLowerCase();
            sysTaskLog.debug((Object)("Try to get connection with XLS: " + sXlsPath + ", " + sXlsFileName));
            wb = fileName.endsWith("xlsx") ? new XSSFWorkbook(is) : new HSSFWorkbook(is);
            ArrayList<String> loginWithDiacriticCharArray = new ArrayList<String>();
            Sheet sheet = wb.getSheetAt(0);
            int noOfColumns = sheet.getRow(0).getPhysicalNumberOfCells();
            for (int i = 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                Row row = sheet.getRow(i);
                if (row == null || row.getPhysicalNumberOfCells() < 1) continue;
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int j = 0; j < noOfColumns; ++j) {
                    String columnName = sheet.getRow(0).getCell(j).toString().toUpperCase();
                    Cell value = row.getCell(j);
                    String valueStr = "";
                    valueStr = value == null ? "" : value.toString().trim();
                    sysTaskLog.trace((Object)(columnName + ":" + String.valueOf(value)));
                    oneRow.put(columnName, valueStr);
                }
                sysTaskLog.debug((Object)"UpdateDataInRow");
                this.UpdateDataInRow(uga, oneRow, loginWithDiacriticCharArray);
            }
            if (loginWithDiacriticCharArray.size() > 0) {
                String loginWithDiacriticCharString = String.join((CharSequence)", ", loginWithDiacriticCharArray);
                sysTaskLog.debug((Object)("Loginy z zakazanymi znakami: " + loginWithDiacriticCharString));
                SystemParameterService systemParameterService = ServiceFactory.getSystemParameterService();
                SystemParameter emailAddressParam = systemParameterService.getParameter("EmailAdressToSendInfoAboutIncorrectLogins");
                SystemParameter emailTemplateParam = systemParameterService.getParameter("TemplateToSendInfoAboutIncorrectLogins");
                if (emailAddressParam != null && emailTemplateParam != null) {
                    String emailAddress = emailAddressParam.getValueString();
                    String emailTemplate = emailTemplateParam.getValueString();
                    if (StringUtils.isNotBlank((CharSequence)emailAddress) && StringUtils.isNotBlank((CharSequence)emailTemplate)) {
                        HashMap<String, String> putInTemplateMap = new HashMap<String, String>();
                        putInTemplateMap.put("loginWithDiacriticChar", loginWithDiacriticCharString);
                        TemplateMailContent content = new TemplateMailContent();
                        content.setTemplatePath(emailTemplate);
                        content.setSubject("[PlusWorkflow][Import u\u017cytkownik\u00f3w] - niew\u0142a\u015bciwe loginy");
                        content.setVariables(putInTemplateMap);
                        String[] emailAddresses = emailAddress.split(";", -1);
                        List<String> recipientsEmailsList = Arrays.asList(emailAddresses);
                        MailSender sender = CufComponentFactory.getMailSender();
                        SystemMailConfiguration cfg = SystemMailConfiguration.getInstance();
                        SendReport sendReport = sender.send((MailConfiguration)cfg, (MailContent)content, recipientsEmailsList);
                        if (sendReport.getFailedEmails().size() > 0) {
                            throw new Exception("b\u0142\u0105d skrzynki nadawczej.");
                        }
                    } else {
                        sysTaskLog.info((Object)"Brak uzupe\u0142nionych parametr\u00f3w: EmailAdressToSendInfoAboutIncorrectLogins oraz TemplateToSendInfoAboutIncorrectLogins");
                    }
                } else {
                    sysTaskLog.info((Object)"Brak parametr\u00f3w: EmailAdressToSendInfoAboutIncorrectLogins oraz TemplateToSendInfoAboutIncorrectLogins");
                }
            }
        }
        catch (Exception e) {
            sysTaskLog.debug((Object)e.getMessage(), (Throwable)e);
            sysTaskLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void UpdateDataInRow(UserGroupAdministration uga, Map<String, String> oneRow, List<String> loginWithDiacriticCharArray) {
        RoleService roleService = ServiceFactory.getRoleService();
        UserService userService = ServiceFactory.getUserService();
        try {
            String sEmail;
            String sFamilyName;
            String sName;
            String sPassword;
            String sUser = oneRow.get("LOGIN").toString();
            String sGroups = oneRow.get("GRUPY").toString();
            String[] asGroups = new String[]{""};
            if (sGroups != null && sGroups.compareToIgnoreCase("") != 0) {
                asGroups = sGroups.split(";");
                for (int i = 0; i < asGroups.length; ++i) {
                    if (uga.doesGroupExist(asGroups[i])) continue;
                    uga.createGroup(asGroups[i], asGroups[i]);
                    System.out.println("Grupa " + asGroups[i] + " zosta\u0142a utworzona");
                }
            }
            if ((sPassword = oneRow.get("HASLO").toString()) == null || sPassword.compareToIgnoreCase("") == 0) {
                sPassword = "";
            }
            if ((sName = oneRow.get("NAME").toString()) == null) {
                sName = "";
            }
            if ((sFamilyName = oneRow.get("NAZWISKO").toString()) == null) {
                sFamilyName = "";
            }
            if ((sEmail = oneRow.get("EMAIL").toString()) == null) {
                sEmail = "test";
            }
            if (!Tools.isNullOrEmpty((String)sUser)) {
                if (!StringUtils.stripAccents((String)sUser).equals(sUser)) {
                    loginWithDiacriticCharArray.add(sUser);
                } else {
                    String sUserNumber;
                    if (!uga.doesUserExist(sUser)) {
                        uga.createUser(asGroups[0], sUser, sPassword, sName, sFamilyName, sEmail);
                        for (i = 1; i < asGroups.length; ++i) {
                            uga.addUserToGroup(asGroups[i], sUser);
                        }
                        sysTaskLog.info((Object)("Dodano u\u017cytkownika: " + sUser));
                    } else {
                        uga.updateUser(sUser, sName, sFamilyName, sEmail);
                        if (sPassword != null && sPassword.compareToIgnoreCase("") != 0) {
                            uga.setPassword(sUser, sPassword);
                        }
                        for (i = 0; i < asGroups.length; ++i) {
                            if (uga.doesUserBelongToGroup(asGroups[i], sUser)) continue;
                            uga.addUserToGroup(asGroups[i], sUser);
                        }
                        sysTaskLog.info((Object)("U\u017cytkownik " + sUser + " ju\u017c istnieje - dane zaktualizowane"));
                    }
                    User user = null;
                    if (uga.doesUserExist(sUser) && (sUserNumber = oneRow.get("NR").toString()) != null && sUserNumber.compareToIgnoreCase("") != 0 && (user = userService.getUser(sUser, new String[]{"positions"})) != null) {
                        String userNumber = user.getNumber();
                        if (userNumber == null || userNumber.isEmpty()) {
                            user.setNumber(sUserNumber);
                            userService.updateUser(user);
                            sysTaskLog.info((Object)("Dodano numer u\u017cytkownika " + sUser + " : " + sUserNumber));
                        } else {
                            user.setNumber(sUserNumber);
                            userService.updateUser(user);
                            sysTaskLog.info((Object)("Zmieniono numer u\u017cytkownika " + sUser + " : " + sUserNumber));
                        }
                    }
                    OrganizationalUnitFinder organizationalUnitFinder = FinderFactory.getOrganizationalUnitFinder();
                    StructureService structureService = ServiceFactory.getStructureService();
                    PositionFinder positionFinder = FinderFactory.getPositionFinder();
                    String sOrganizationalUnitSymbol = oneRow.get("SYMBOL JEDNOSTKI ORGANIZACYJNEJ").toString();
                    boolean bOrganizationalUnitExist = true;
                    OrganizationalUnit oOrganizationalUnitsTable = null;
                    if (sOrganizationalUnitSymbol != null && sOrganizationalUnitSymbol.compareToIgnoreCase("") != 0) {
                        String sDirectorPositionSymbol;
                        String sOrganizationalUnitName;
                        oOrganizationalUnitsTable = organizationalUnitFinder.findBySymbol(sOrganizationalUnitSymbol, new String[]{"higherOrganizationalUnit", "directorPosition", "subOus"});
                        if (oOrganizationalUnitsTable == null) {
                            bOrganizationalUnitExist = false;
                            oOrganizationalUnitsTable = new OrganizationalUnit("", sOrganizationalUnitSymbol);
                            structureService.createOrganizationalUnit(oOrganizationalUnitsTable);
                            sysTaskLog.info((Object)("Dodawanie nowej jednostki organizacyjnej: " + sOrganizationalUnitSymbol));
                        }
                        if ((sOrganizationalUnitName = oneRow.get("NAZWA JEDNOSTKI ORGANIZACYJNEJ").toString()) != null) {
                            oOrganizationalUnitsTable.setName(sOrganizationalUnitName);
                        } else {
                            oOrganizationalUnitsTable.setName("");
                        }
                        structureService.updateOrganizationalUnit(oOrganizationalUnitsTable);
                        String sHigherOrganizationalUnitSymbol = oneRow.get("SYMBOL JEDNOSTKI NADRZEDNEJ").toString();
                        if (sHigherOrganizationalUnitSymbol != null) {
                            OrganizationalUnit oHigherOrganizationalUnit = organizationalUnitFinder.findBySymbol(sHigherOrganizationalUnitSymbol, new String[0]);
                            if (oHigherOrganizationalUnit == null) {
                                if (sHigherOrganizationalUnitSymbol.compareToIgnoreCase(sOrganizationalUnitSymbol) == 0) {
                                    oHigherOrganizationalUnit = oOrganizationalUnitsTable;
                                    bOrganizationalUnitExist = true;
                                } else {
                                    oHigherOrganizationalUnit = new OrganizationalUnit("", sHigherOrganizationalUnitSymbol);
                                    structureService.createOrganizationalUnit(oHigherOrganizationalUnit);
                                }
                                sysTaskLog.info((Object)("Brak jednostki nadrzednej. Dodano: " + sHigherOrganizationalUnitSymbol));
                                if (sHigherOrganizationalUnitSymbol.compareToIgnoreCase(sOrganizationalUnitSymbol) == 0) {
                                    oOrganizationalUnitsTable = oHigherOrganizationalUnit;
                                    sysTaskLog.info((Object)"Jednostka nadrzedna rowna obecnej.");
                                }
                            }
                            oOrganizationalUnitsTable.setHigherOrganizationalUnit(oHigherOrganizationalUnit);
                            structureService.updateOrganizationalUnit(oOrganizationalUnitsTable);
                        }
                        if ((sDirectorPositionSymbol = oneRow.get("SYMBOL STANOWISKA KIEROWNICZEGO").toString()) != null) {
                            Position oPositionTable = positionFinder.findBySymbol(sDirectorPositionSymbol, new String[0]);
                            if (oPositionTable == null) {
                                oPositionTable = new Position("", sDirectorPositionSymbol);
                                structureService.createPosition(oPositionTable);
                                sysTaskLog.info((Object)("Brak podanego stanowiska kierowniczego. Dodano stanowisko: " + sDirectorPositionSymbol));
                            }
                            oOrganizationalUnitsTable.setDirectorPosition(oPositionTable);
                        }
                        if (bOrganizationalUnitExist) {
                            structureService.updateOrganizationalUnit(oOrganizationalUnitsTable);
                            sysTaskLog.info((Object)("Zmieniono dane jednostki organizacyjnej: " + sOrganizationalUnitSymbol));
                        } else {
                            structureService.updateOrganizationalUnit(oOrganizationalUnitsTable);
                            sysTaskLog.info((Object)("Dodano nowa jednostke organizacyjna: " + sOrganizationalUnitSymbol));
                        }
                    }
                    String sPositionSymbol = oneRow.get("SYMBOL STANOWISKA").toString();
                    Position oPositionsTable = null;
                    boolean bPositionExist = true;
                    if (sPositionSymbol != null && sPositionSymbol.compareToIgnoreCase("") != 0) {
                        String sPositionsName;
                        oPositionsTable = positionFinder.findBySymbol(sPositionSymbol, new String[]{"higherPosition", "organizationalUnit", "roles"});
                        if (oPositionsTable == null) {
                            bPositionExist = false;
                            oPositionsTable = new Position("", sPositionSymbol);
                            structureService.createPosition(oPositionsTable);
                            sysTaskLog.info((Object)("Dodawanie nowego stanowiska: " + sPositionSymbol));
                        }
                        if ((sPositionsName = oneRow.get("NAZWA STANOWISKA").toString()) != null) {
                            oPositionsTable.setName(sPositionsName);
                        } else {
                            oPositionsTable.setName("");
                        }
                        structureService.updatePosition(oPositionsTable);
                        String sHigherPositionsSymbol = oneRow.get("SYMBOL STANOWISKA NADRZEDNEGO").toString();
                        if (sHigherPositionsSymbol != null) {
                            Position oHigherPositions = positionFinder.findBySymbol(sHigherPositionsSymbol, new String[0]);
                            if (oHigherPositions == null) {
                                if (sHigherPositionsSymbol.compareToIgnoreCase(sPositionSymbol) == 0) {
                                    oHigherPositions = oPositionsTable;
                                    bPositionExist = true;
                                } else {
                                    oHigherPositions = new Position("", sHigherPositionsSymbol);
                                    structureService.createPosition(oHigherPositions);
                                }
                                sysTaskLog.info((Object)("Brak podanego stanowiska nadrzednego. Dodanie stanowiska: " + sHigherPositionsSymbol));
                                if (sHigherPositionsSymbol.compareToIgnoreCase(sPositionSymbol) == 0) {
                                    oPositionsTable = oHigherPositions;
                                    sysTaskLog.info((Object)"Stanowisko nadrzedne rowne obecnemu.");
                                }
                            }
                            oPositionsTable.setHigherPosition(oHigherPositions);
                            structureService.updatePosition(oPositionsTable);
                        }
                        if (oOrganizationalUnitsTable != null) {
                            oPositionsTable.setOrganizationalUnit(oOrganizationalUnitsTable);
                            structureService.updatePosition(oPositionsTable);
                            sysTaskLog.info((Object)("Powiazano jednostke : " + sOrganizationalUnitSymbol + " ze stanowiskiem: " + sPositionSymbol));
                        }
                        if (bPositionExist) {
                            structureService.updatePosition(oPositionsTable);
                            sysTaskLog.info((Object)("Zmieniono dane stanowiska: " + sPositionSymbol));
                        } else {
                            structureService.updatePosition(oPositionsTable);
                            sysTaskLog.info((Object)("Dodano nowe stanowisko: " + sPositionSymbol));
                        }
                        String sRolesId = oneRow.get("ROLA").toString();
                        if (sRolesId != null) {
                            String[] asRolesId = sRolesId.split(";");
                            for (int i = 0; i < asRolesId.length; ++i) {
                                List<Map<String, Object>> rolesData = this.getRolesDataByRoleId(asRolesId[i]);
                                for (int j = 0; j < rolesData.size(); ++j) {
                                    Map<String, Object> oneRoleData = rolesData.get(j);
                                    Role role = roleService.getRole(Long.valueOf(Long.parseLong(oneRoleData.get("id").toString())));
                                    oPositionsTable.addRole(role);
                                }
                                structureService.updatePosition(oPositionsTable);
                            }
                        }
                    }
                    if (uga.doesUserExist(sUser) && oPositionsTable != null) {
                        Set positions = user.getPositions();
                        positions.add(oPositionsTable);
                        user.setPositions(positions);
                        userService.updateUser(user);
                        sysTaskLog.info((Object)("Powiazano uzytkownika: " + sUser + " ze stanowiskiem: " + sPositionSymbol));
                    }
                    sysTaskLog.info((Object)"Uzupelniam tabele UserAuthentication");
                    String cid = oneRow.get("CID").toString();
                    boolean updateUserAuthentication = true;
                    UserAuthenticationData userAuthentication = this.userAuthenticationDao.getByCid(cid);
                    if (userAuthentication == null) {
                        userAuthentication = new UserAuthenticationData();
                        userAuthentication.setCid(cid);
                        updateUserAuthentication = false;
                    }
                    userAuthentication.setDistinguished_name(oneRow.get("NR").toString());
                    userAuthentication.setPosition(oneRow.get("NAZWA STANOWISKA").toString());
                    userAuthentication.setOrg_unit(oneRow.get("NR JO").toString().replace(".0", ""));
                    userAuthentication.setLogin(sUser);
                    Date currentDate = new Date();
                    String sysDateFormat = "yyyy-MM-dd";
                    SimpleDateFormat sdf = new SimpleDateFormat(sysDateFormat);
                    currentDate = sdf.parse(sdf.format(currentDate));
                    userAuthentication.setDate_of_update(currentDate);
                    if (updateUserAuthentication) {
                        this.userAuthenticationDao.updateUserAuthentication(userAuthentication);
                        sysTaskLog.info((Object)("Aktualizuje dane do autoryzacji uzytkownika " + sUser));
                    } else {
                        this.userAuthenticationDao.addUserAuthentication(userAuthentication);
                        sysTaskLog.info((Object)("Dodaje dane do autoryzacji uzytkownika " + sUser));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sysTaskLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<Map<String, Object>> getRolesDataByRoleId(String roleid) {
        SQLFinder sqlFinder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select id, roleid from pm_roles where UPPER(roleid)=:textvalue");
        builder.setParameter("textvalue", (Object)roleid.toUpperCase());
        builder.addScalar("id", (Type)StandardBasicTypes.LONG);
        builder.addScalar("roleid", (Type)StandardBasicTypes.STRING);
        List records = sqlFinder.find(builder);
        return records;
    }
}

