/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.util.extension.P0015.getDataMethods;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.extension.P0015.Functions;
import com.suncode.plugin.lm.DirectDB.copyInitData.Addresses;
import com.suncode.plugin.lm.DirectDB.copyInitData.Category;
import com.suncode.plugin.lm.DirectDB.copyInitData.Currency;
import com.suncode.plugin.lm.DirectDB.copyInitData.Jednostki;
import com.suncode.plugin.lm.DirectDB.copyInitData.KodProjektu;
import com.suncode.plugin.lm.DirectDB.copyInitData.MPK;
import com.suncode.plugin.lm.DirectDB.copyInitData.OpisyPBU;
import com.suncode.plugin.lm.DirectDB.copyInitData.PlanKontWF;
import com.suncode.plugin.lm.DirectDB.copyInitData.Projekt;
import com.suncode.plugin.lm.DirectDB.copyInitData.Sklepy;
import com.suncode.plugin.lm.DirectDB.copyInitData.VAT;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.AddressesDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.CategoryDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.CurrencyDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.JednostkiDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.KodProjektuDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.MPKDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.OpisyPBUDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.PlanKontWFDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.ProjektDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SklepyDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.VATDao;
import com.suncode.plugin.lm.util.extension.P0015.getDataMethods.DBPlanKontWF;
import com.suncode.plugin.lm.util.extension.P0015.getDataMethods.DBUserInitData;
import com.suncode.plugin.lm.util.extension.P0015.getDataMethods.ReadData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataMethods {
    public static Logger log = Logger.getLogger(DataMethods.class);
    @Autowired
    private SklepyDao sklepyDao;
    @Autowired
    private VATDao vatDao;
    @Autowired
    private CurrencyDao currencyDao;
    @Autowired
    private JednostkiDao jednostkiDao;
    @Autowired
    private AddressesDao addressesDao;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private KodProjektuDao kodProjektuDao;
    @Autowired
    private MPKDao mpkDao;
    @Autowired
    private OpisyPBUDao opisyPBUDao;
    @Autowired
    private ProjektDao projektDao;
    @Autowired
    private PlanKontWFDao planKontWFDao;
    @Autowired
    private DBUserInitData dbUserInitDataService;
    @Autowired
    private DBPlanKontWF dbPlanKontWFService;

    private static void saveDataInPlanKontWF(String sFileName) {
        if (DataMethods.checkIfFileExists(sFileName)) {
            try {
                String sLine;
                String[] tab = null;
                int iLine = 0;
                BufferedReader in = new BufferedReader(new FileReader(sFileName));
                while ((sLine = in.readLine()) != null) {
                    tab = ReadData.readLineFromFile(sLine, "\\|", 4);
                    DBPlanKontWF dbplanKontWF = new DBPlanKontWF();
                    dbplanKontWF.saveToDB(++iLine, tab);
                }
                in.close();
            }
            catch (IOException exc) {
                log.error((Object)exc.getMessage());
            }
        } else {
            log.error((Object)("Plik o nazwie: " + sFileName + " nie istnieje"));
        }
    }

    private static int updateDataInPlanKontWF(String sFileName) {
        int iLineNr = -1;
        if (DataMethods.checkIfFileExists(sFileName)) {
            try {
                String sLine;
                iLineNr = 0;
                String[] rTab = null;
                BufferedReader in = new BufferedReader(new FileReader(sFileName));
                while ((sLine = in.readLine()) != null) {
                    if (++iLineNr <= 1) continue;
                    rTab = ReadData.readLineFromFile(sLine, "\\|", 4);
                    DBPlanKontWF dbplanKontWF = new DBPlanKontWF();
                    dbplanKontWF.updateDB(iLineNr - 1, rTab);
                }
                in.close();
            }
            catch (IOException exc) {
                log.error((Object)exc.getMessage());
            }
        } else {
            log.error((Object)("Plik o nazwie: " + sFileName + " nie istnieje"));
        }
        return iLineNr;
    }

    private int deleteDataFromPlanKontWF(int iNr) {
        if (iNr > 0) {
            try {
                this.dbPlanKontWFService.deleteElementFromDB(iNr);
            }
            catch (Exception exc) {
                log.error((Object)exc.getMessage());
            }
        }
        return 1;
    }

    private static int updateDataInUserInitData(String sFileName) {
        int iLineNr = -1;
        if (DataMethods.checkIfFileExists(sFileName)) {
            try {
                String sLine;
                iLineNr = 0;
                String[] rTab = null;
                BufferedReader in = new BufferedReader(new FileReader(sFileName));
                while ((sLine = in.readLine()) != null) {
                    if (++iLineNr <= 1) continue;
                    rTab = ReadData.readLineFromFile(sLine, "\\|", 3);
                    DBUserInitData dbUserInitData = new DBUserInitData();
                    dbUserInitData.updateDB(iLineNr - 1, rTab);
                }
                in.close();
            }
            catch (IOException exc) {
                log.error((Object)exc.getMessage());
            }
        } else {
            log.error((Object)("Plik o nazwie: " + sFileName + " nie istnieje"));
        }
        return iLineNr;
    }

    private int deleteDataFromUserInitData(int iNr) {
        if (iNr > 0) {
            try {
                this.dbUserInitDataService.deleteElementFromDB(iNr);
            }
            catch (Exception exc) {
                log.error((Object)exc.getMessage());
            }
        }
        return 1;
    }

    private static boolean checkIfFileExists(String sFileName) {
        File f = new File(sFileName);
        boolean bResult = f.exists();
        if (!bResult) {
            log.debug((Object)("Check " + sFileName + " - file not exists"));
        }
        return bResult;
    }

    private static String getLastModified(String sFileName) {
        File f = new File(sFileName);
        long lLastModified = f.lastModified();
        String sDate = Functions.getDate("yyyy-mm-dd", lLastModified);
        log.debug((Object)("Check " + sFileName + " - file not exists"));
        return sDate;
    }

    public static List<String> getAccountForOUList(String sOU, String sLokalizacja, String sParam) {
        if (sOU != null) {
            if (sLokalizacja.compareToIgnoreCase("SKLEP") == 0) {
                sOU = "S999000";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("C");
                sb.append(sOU.substring(2, sOU.length()));
                sOU = sb.toString();
            }
        }
        List<String> list = DataMethods.getPlanKontWFForOU(sOU, sParam);
        return list;
    }

    public static String getAccountForOU(String sOU, String sLokalizacja, String sParam) {
        List<String> list = DataMethods.getAccountForOUList(sOU, sLokalizacja, sParam);
        String sResult = Functions.changeListToString(list);
        return sResult;
    }

    public static List<String> getPlanKontWFForOU(String sOU, String sParam) {
        Session session = null;
        Transaction transaction = null;
        List result = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            String sQuery = "select pk.description || ' - ' || pk.code from PlanKontWF pk where pk.code in ( select zk.code2 from ZestawKontJO zk where zk.code = :sOU )";
            if (sParam != null && sParam.compareToIgnoreCase("invoice") == 0) {
                sQuery = "select pk.description || ' - ' || pk.code from PlanKontWF pk where pk.code in ( select zk.code2 from ZestawKontJOF zk where zk.code = :sOU )";
            }
            log.debug((Object)("Query: " + sQuery));
            result = session.createQuery(sQuery).setParameter("sOU", (Object)sOU).list();
            transaction.commit();
        }
        catch (HibernateException he) {
            try {
                transaction.rollback();
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
        }
        return result;
    }

    public static String getGetPBUForPlanKontWF(String sKonto) {
        Session session = null;
        Transaction transaction = null;
        String result = "";
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            String sQuery = "select zk.code from  ZestawKontPBU zk where zk.code2 = :value ";
            log.debug((Object)("Query: " + sQuery));
            result = (String)session.createQuery(sQuery).setParameter("value", (Object)sKonto).uniqueResult();
            transaction.commit();
        }
        catch (HibernateException he) {
            try {
                transaction.rollback();
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
        }
        return result;
    }

    public List<String> getAllSklepyCode() {
        ArrayList<String> list = new ArrayList<String>();
        List<Sklepy> allSklepyList = this.sklepyDao.getAllSklepy();
        int iSize = allSklepyList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allSklepyList.get(i).getSklep().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public List<String> getAllSklepy() {
        ArrayList<String> list = new ArrayList<String>();
        List<Sklepy> allSklepyList = this.sklepyDao.getAllSklepy();
        int iSize = allSklepyList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allSklepyList.get(i).getOpis().toString() + " - " + allSklepyList.get(i).getSklep().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public List<String> getAllSklepySymbolName() {
        ArrayList<String> list = new ArrayList<String>();
        List<Sklepy> allSklepyList = this.sklepyDao.getAllSklepy();
        int iSize = allSklepyList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allSklepyList.get(i).getSklep().toString() + " - " + allSklepyList.get(i).getOpis().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public List<Sklepy> getAllSklepyExcept(List<String> excludedList) {
        List<Sklepy> allSklepyList = null;
        allSklepyList = excludedList.size() > 0 ? this.sklepyDao.getAllSklepyExcept(excludedList) : this.sklepyDao.getAllSklepy();
        return allSklepyList;
    }

    public List<String> getAllAccountCode() {
        ArrayList<String> list = new ArrayList<String>();
        List<PlanKontWF> allPlanKontWFList = this.planKontWFDao.getAllPlanKontWF();
        int iSize = allPlanKontWFList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allPlanKontWFList.get(i).getCode().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getSklepyForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllSklepy());
        return sResult;
    }

    public List<String> getAllMPKCode() {
        ArrayList<String> list = new ArrayList<String>();
        List<MPK> allMPKList = this.mpkDao.getAllMPK();
        int iSize = allMPKList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allMPKList.get(i).getMpk().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public List<String> getAllMPK() {
        ArrayList<String> list = new ArrayList<String>();
        List<MPK> allMPKList = this.mpkDao.getAllMPK();
        int iSize = allMPKList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allMPKList.get(i).getOpis().toString() + " - " + allMPKList.get(i).getMpk().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public List<String> getAllOpisyPBUCode() {
        ArrayList<String> list = new ArrayList<String>();
        List<OpisyPBU> allOpisyPBUList = this.opisyPBUDao.getAllOpisyPBU();
        int iSize = allOpisyPBUList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allOpisyPBUList.get(i).getValue().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getMPKForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllMPK());
        return sResult;
    }

    public List<String> getAllCurrency() {
        ArrayList<String> list = new ArrayList<String>();
        List<Currency> allCurrencyList = this.currencyDao.getAllCurrency();
        int iSize = allCurrencyList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allCurrencyList.get(i).getCode();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getCurrencyForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllCurrency());
        return sResult;
    }

    public List<String> getAllCategory() {
        ArrayList<String> list = new ArrayList<String>();
        List<Category> allCategoryList = this.categoryDao.getAllCategory();
        int iSize = allCategoryList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allCategoryList.get(i).getName();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getCategoryForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllCategory());
        return sResult;
    }

    public List<String> getAllVAT() {
        ArrayList<String> list = new ArrayList<String>();
        List<VAT> allVATList = this.vatDao.getAllVAT();
        int iSize = allVATList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allVATList.get(i).getDescription().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getVATForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllVAT());
        return sResult;
    }

    public List<String> getAllKodProjektu(String sFindValue) {
        ArrayList<String> list = new ArrayList<String>();
        List<KodProjektu> allKodProjektuList = this.kodProjektuDao.getAllKodProjektuByVal(sFindValue);
        int iSize = allKodProjektuList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTempKod = allKodProjektuList.get(i).getKodProjektu().toString();
            StringBuffer sb = new StringBuffer();
            sb.append(sTempKod);
            list.add(sb.toString());
        }
        return list;
    }

    public List<String> getAllKodProjektu() {
        ArrayList<String> list = new ArrayList<String>();
        List<KodProjektu> allKodProjektuList = this.kodProjektuDao.getAllKodProjektu();
        int iSize = allKodProjektuList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTempKod = allKodProjektuList.get(i).getKodProjektu().toString();
            String sTempOpis = allKodProjektuList.get(i).getOpis().toString();
            StringBuffer sb = new StringBuffer();
            sb.append(sTempKod);
            sb.append(" - ");
            sb.append(sTempOpis);
            log.trace((Object)sb.toString());
            list.add(sb.toString());
        }
        return list;
    }

    public String getKodInwestForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllKodProjektu());
        return sResult;
    }

    private List<String> getAllJednostki() {
        ArrayList<String> list = new ArrayList<String>();
        List<Jednostki> allJednostkiList = this.jednostkiDao.getAllJednostki();
        int iSize = allJednostkiList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allJednostkiList.get(i).getWartosc().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getJednostkiForZamowienia() {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllJednostki());
        return sResult;
    }

    private List<String> getAllProjekty(String sValue) {
        ArrayList<String> list = new ArrayList<String>();
        List<Projekt> allProjektList = this.projektDao.getProjekty(sValue);
        int iSize = allProjektList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allProjektList.get(i).getProjekt().toString();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }

    public String getProjektForZamowienia(String sValue) {
        String sResult = "";
        sResult = Functions.changeListToString(this.getAllProjekty(sValue));
        return sResult;
    }

    public List<String> getAllAddresses() {
        ArrayList<String> list = new ArrayList<String>();
        List<Addresses> allAddressesList = this.addressesDao.getAllAddresses();
        int iSize = allAddressesList.size();
        for (int i = 0; i < iSize; ++i) {
            String sTemp = allAddressesList.get(i).getName() + ", " + allAddressesList.get(i).getStreet() + ", " + allAddressesList.get(i).getTown();
            log.trace((Object)sTemp);
            list.add(sTemp);
        }
        return list;
    }
}

