/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.util.extension.P0015.getDataMethods;

import com.suncode.plugin.lm.DirectDB.copyInitData.UserInitData;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.UserInitDataDao;
import com.suncode.plugin.lm.util.extension.P0015.getDataMethods.DBObjects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DBUserInitData
extends DBObjects {
    public static Logger log = Logger.getLogger((String)"DBUserInitData");
    @Autowired
    private UserInitDataDao userInitDataDao;

    public String saveToDB(int iLine, String sValue, String sErrorMessage, String sColSeparator) {
        log.debug((Object)"DBUserInitData - saveToDB (string)");
        String[] sTabValue = sValue.split(sColSeparator);
        Long lBudgetId = null;
        if (sTabValue.length > 1) {
            UserInitData userInitData = new UserInitData(iLine, sTabValue[0], sTabValue[1], sTabValue[2]);
            lBudgetId = this.userInitDataDao.addToTable(userInitData);
            log.debug((Object)lBudgetId);
        }
        return "OK";
    }

    public String saveToDB(int iLine, String[] sTabValue) {
        log.debug((Object)"DBUserInitData - saveToDB (table)");
        Long lBudgetId = null;
        if (sTabValue.length > 1) {
            UserInitData userInitData = new UserInitData(iLine, iLine, sTabValue[0], sTabValue[1], sTabValue[2]);
            lBudgetId = this.userInitDataDao.addToTable(userInitData);
            log.debug((Object)lBudgetId);
        }
        return "OK";
    }

    public UserInitData getAccountById(Long lId) {
        log.debug((Object)"DBUserInitData - getAccountById (table)");
        UserInitData userInitData = new UserInitData();
        userInitData = this.userInitDataDao.getValueById(lId);
        return userInitData;
    }

    public int updateDB(int iLine, String[] sTabValue) {
        log.debug((Object)"DBUserInitData - updateDB (table) - START");
        if (sTabValue.length > 1) {
            UserInitData userInitData = null;
            List<UserInitData> result = this.userInitDataDao.getUserInitDataByNr(iLine);
            if (result == null || result.size() == 0) {
                userInitData = new UserInitData(iLine, iLine, sTabValue[0], sTabValue[1], sTabValue[2]);
                this.userInitDataDao.addToTable(userInitData);
            } else {
                userInitData = result.get(0);
                userInitData.setNr(iLine);
                userInitData.setLogin(sTabValue[0]);
                userInitData.setKonto(sTabValue[1]);
                userInitData.setPbu(sTabValue[2]);
                this.userInitDataDao.updateUserInitData(userInitData);
            }
        } else {
            log.error((Object)"DBUserInitData - can't add row (no input data)");
            return 1;
        }
        log.debug((Object)"DBUserInitData - updateDB (table) - END");
        return 0;
    }

    public int deleteElementFromDB(int iNr) {
        int iResult = 0;
        log.debug((Object)"DBUserInitData - saveToDB (table) - START");
        boolean bDel = true;
        while (bDel) {
            List<UserInitData> result;
            UserInitData userInitData = null;
            if ((result = this.userInitDataDao.getUserInitDataByNr(iNr++)) != null && result.size() != 0) {
                userInitData = result.get(0);
                Long lId = (long)userInitData.getId();
                this.userInitDataDao.deleteValueByNr(lId);
                continue;
            }
            bDel = false;
        }
        log.debug((Object)"DBUserInitData - saveToDB (table) - END");
        return iResult;
    }

    public Map<String, String> getElementFromDBByLogin(String sLogin) {
        log.trace((Object)"****************** getElementFromDBByLogin **********************");
        HashMap<String, String> mList = new HashMap<String, String>();
        List<UserInitData> result = this.userInitDataDao.getUserInitDataByLogin(sLogin);
        if (result != null && result.size() != 0) {
            String sTempKonto = result.get(0).getKonto().toString();
            if (sTempKonto == null) {
                sTempKonto = "";
            }
            mList.put("konto", sTempKonto);
            String sTempPBU = result.get(0).getPbu().toString();
            if (sTempPBU == null) {
                sTempPBU = "";
            }
            mList.put("pbu", sTempPBU);
        }
        return mList;
    }
}

