/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.util.extension.P0015.ckd_pw;

import com.plusmpm.CUF.util.DataChoosers.ExecuteQueryDataChooser;
import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.suncode.plugin.lm.DirectDB.copyInitData.MPK;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.MPKDao;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PWTools {
    public static Logger log = Logger.getLogger(PWTools.class);
    @Autowired
    private MPKDao mpkDao;
    private static SQLFinder finder = FinderFactory.getSQLFinder();
    private static ProcessService processService = ServiceFactory.getProcessService();
    public static String _closed_ls = "Zamkniete-LS";
    public static String _closed = "Zamkniete";
    public static String _closed_fv = "Zamkniete-faktura";
    public static String _closed_canceled = "Zamkniete-anulowane";
    public static String _status_for_cancel = "Anulacja faktury";
    public static String _lsDocClassName = "CKD - Listy sporne";
    public static String _lsFileDesc = "List sporny dla dostawcy";
    public static String _fvDocClassName = "CKD \u2013 Faktury sprzeda\u017cy";
    public static String _fvFileDesc = "Faktura sprzeda\u017cy";
    public static String _fvCorFileDesc = "Faktura koryguj\u0105ca";

    public static boolean hasUserRole(String sRole, String sUser, String sSklep) {
        if (sSklep.indexOf(45) > 0) {
            sSklep = sSklep.split(" - ")[1];
        }
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", "ckd_check_user_role");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("user", sUser);
        criteria.put("role", sRole);
        criteria.put("sklep", sSklep);
        List result = dc.getDataChooserResult(0, 50, sRole, "DESC", criteria, customKeys);
        return result.size() > 0;
    }

    public Map<String, Object> translateDoss(JSONObject doss) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            log.debug((Object)"translateDoss - naglowek zwrotu ");
            JSONObject recs = doss.getJSONObject("rec");
            Iterator it = recs.keys();
            if (it.hasNext()) {
                JSONObject rec = recs.getJSONObject((String)it.next());
                Object numrecmagObject = rec.opt("numrecmag");
                String numrecmagString = "";
                numrecmagString = numrecmagObject instanceof Integer ? String.valueOf((Integer)numrecmagObject) : (String)numrecmagObject;
                log.debug((Object)("translateDoss - nr bonu wyscia: " + numrecmagString));
                result.put("nr_bonu_wyjsciazamowienia", rec.getString("numcde").trim());
                result.put("nr_odbioru", numrecmagString.trim());
                result.put("data_zamowienia", Functions.getDate(DossierTranslator.changeStringToDate(rec.getString("datcde")), "yyyy-MM-dd"));
                result.put("nr_dostawcy_ipao", rec.getString("codfou").trim());
                result.put("dostawca", rec.getString("nomfou28"));
                if (rec.has("waluta")) {
                    result.put("waluta", rec.getString("waluta"));
                }
                if (rec.has("dzial")) {
                    String sDzialNo = rec.getString("dzial");
                    MPK tmp_mpk = this.mpkDao.getMPKByNrCkd(sDzialNo);
                    Object sDzial = "";
                    sDzial = tmp_mpk == null ? sDzialNo : tmp_mpk.getMpk() + " - " + tmp_mpk.getOpis();
                    result.put("dzial", sDzial);
                }
                result.put("data_waloryzacji", Functions.getDate(DossierTranslator.changeStringToDate(rec.getString("datvalrec")), "yyyy-MM-dd"));
            }
            log.debug((Object)"translateDoss - linie zwrotu ");
            JSONObject ordersLinesJSON = null;
            if (doss.optJSONObject("linie_rec") != null) {
                ordersLinesJSON = doss.getJSONObject("linie_rec");
                Iterator it_zam = ordersLinesJSON.keys();
                int lp = 0;
                while (it_zam.hasNext()) {
                    String sOrder_no = (String)it_zam.next();
                    JSONObject orderJSON = null;
                    if (ordersLinesJSON.optJSONObject(sOrder_no) == null) continue;
                    orderJSON = ordersLinesJSON.getJSONObject(sOrder_no);
                    Iterator itLines = orderJSON.keys();
                    while (itLines.hasNext()) {
                        double wartosc_walo;
                        double cena_z_zamowienia;
                        double ilosc_zwalo;
                        ++lp;
                        String current_line = (String)itLines.next();
                        JSONObject lineJSON = orderJSON.getJSONObject(current_line);
                        if (result.containsKey("id_linii")) {
                            result.put("id_linii", String.valueOf(result.get("id_linii")) + ";" + String.valueOf(sOrder_no) + "_" + current_line);
                            result.put("lp", String.valueOf(result.get("lp")) + ";" + String.valueOf(lp));
                            result.put("referencja_lm", String.valueOf(result.get("referencja_lm")) + ";" + lineJSON.getString("numart").trim());
                            result.put("opis", String.valueOf(result.get("opis")) + ";" + lineJSON.getString("desart").trim());
                            result.put("ilosc_wz", String.valueOf(result.get("ilosc_wz")) + ";" + String.valueOf(lineJSON.getDouble("qteartvalo")));
                            result.put("uszkodzenia", String.valueOf(result.get("uszkodzenia")) + ";" + String.valueOf(lineJSON.getDouble("qteartcasse")));
                            ilosc_zwalo = lineJSON.getDouble("qteartref");
                            result.put("ilosc_zwalo", String.valueOf(result.get("ilosc_zwalo")) + ";" + String.valueOf(ilosc_zwalo));
                            cena_z_zamowienia = Functions.RoundValue(lineJSON.getDouble("priachrec"), 2);
                            result.put("cena_z_zamowienia", String.valueOf(result.get("cena_z_zamowienia")) + ";" + String.valueOf(cena_z_zamowienia));
                            wartosc_walo = Functions.RoundValue(ilosc_zwalo * cena_z_zamowienia, 2);
                            result.put("wartosc_waloryzacji", String.valueOf(result.get("wartosc_waloryzacji")) + ";" + wartosc_walo);
                            result.put("stawka_vat", String.valueOf(result.get("stawka_vat")) + ";" + lineJSON.getString("vat").trim());
                            continue;
                        }
                        result.put("id_linii", String.valueOf(sOrder_no) + "_" + current_line);
                        result.put("lp", String.valueOf(lp));
                        result.put("referencja_lm", lineJSON.getString("numart").trim());
                        result.put("opis", lineJSON.getString("desart").trim());
                        result.put("ilosc_wz", String.valueOf(lineJSON.getDouble("qteartvalo")));
                        result.put("uszkodzenia", String.valueOf(lineJSON.getDouble("qteartcasse")));
                        ilosc_zwalo = lineJSON.getDouble("qteartref");
                        result.put("ilosc_zwalo", String.valueOf(ilosc_zwalo));
                        cena_z_zamowienia = Functions.RoundValue(lineJSON.getDouble("priachrec"), 2);
                        result.put("cena_z_zamowienia", String.valueOf(cena_z_zamowienia));
                        wartosc_walo = Functions.RoundValue(ilosc_zwalo * cena_z_zamowienia, 2);
                        result.put("wartosc_waloryzacji", String.valueOf(wartosc_walo));
                        result.put("stawka_vat", lineJSON.getString("vat").trim());
                    }
                }
            } else {
                result.put("id_linii", "");
                result.put("lp", "");
                result.put("referencja_lm", "");
                result.put("opis", "");
                result.put("ilosc_wz", "");
                result.put("uszkodzenia", "");
                result.put("ilosc_zwalo", "");
                result.put("cena_z_zamowienia", "");
                result.put("wartosc_waloryzacji", "");
                result.put("stawka_vat", "");
            }
        }
        catch (Exception e) {
            log.error((Object)("translateDoss - blad pobierania danych: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return result;
    }

    public static Map<String, Object> setAddictionalAmounds(Map<String, Object> processmap, Map<String, Object> ws_data) throws Exception {
        String[] tmp;
        String[] colIDs = new String[]{"rabat", "id_linii"};
        List tab_wal_mapa = DynamicTableFunctions.convertFromMapToListOfMaps(processmap, (String[])colIDs);
        ArrayList tab_vat = new ArrayList();
        String[] vat_keys = null;
        String sDefVat = SystemProperties.getString((String)"CKD_VAT_RATES");
        vat_keys = sDefVat != null && !sDefVat.isEmpty() ? sDefVat.split(";") : (tmp = new String[]{"23", "8", "5", "0", "zw"});
        for (String key : vat_keys) {
            HashMap<String, String> line = new HashMap<String, String>();
            line.put("zb_stawka_vat", key);
            line.put("zb_kwota_netto", "0");
            line.put("zb_kwota_vat", "0");
            line.put("zb_kwota_brutto", "0");
            tab_vat.add(line);
        }
        Object sCenaFra = "";
        Object sWartoscFra = "";
        Object sVat = "";
        Object sBrutto = "";
        Object sRabat = "";
        if (!StringUtils.isBlank((CharSequence)((String)ws_data.get("id_linii")))) {
            String[] sIds = ((String)ws_data.get("id_linii")).split(";");
            String[] sCenaZam = ((String)ws_data.get("cena_z_zamowienia")).split(";");
            String[] sIloscZwalo = ((String)ws_data.get("ilosc_zwalo")).split(";");
            String[] sStawka = ((String)ws_data.get("stawka_vat")).split(";");
            for (int i = 0; i < sIds.length; ++i) {
                String string = sIds[i];
                double rabat = 0.0;
                for (Map poz : tab_wal_mapa) {
                    if (string.compareToIgnoreCase((String)poz.get("id_linii")) != 0) continue;
                    rabat = Functions.changeStringToDouble((String)poz.get("rabat"));
                }
                double ilosc = Functions.changeStringToDouble(sIloscZwalo[i]);
                double cena_zam = Functions.changeStringToDouble(sCenaZam[i]);
                double cena_fak = Functions.RoundValue(cena_zam * (100.0 - rabat) / 100.0, 2);
                double wartosc_fak = Functions.RoundValue(ilosc * cena_fak, 2);
                double stawka = 0.0;
                try {
                    stawka = Functions.changeStringToDouble(sStawka[i]);
                }
                catch (Exception e) {
                    log.debug((Object)"Stawka nieliczbowa przyjmuje 0");
                }
                double vat = Functions.RoundValue(wartosc_fak * (stawka / 100.0), 2);
                if (wartosc_fak < 0.0) {
                    vat = -1.0 * Functions.RoundValue(-1.0 * wartosc_fak * (stawka / 100.0), 2);
                }
                sCenaFra = (String)sCenaFra + cena_fak + ";";
                sWartoscFra = (String)sWartoscFra + wartosc_fak + ";";
                sVat = (String)sVat + vat + ";";
                sBrutto = (String)sBrutto + Functions.RoundValue(wartosc_fak + vat, 2) + ";";
                sRabat = (String)sRabat + rabat + ";";
                for (Map map : tab_vat) {
                    if (((String)map.get("zb_stawka_vat")).compareToIgnoreCase(sStawka[i]) != 0) continue;
                    map.put("zb_kwota_netto", String.valueOf(Functions.RoundValue(Double.valueOf((String)map.get("zb_kwota_netto")) + wartosc_fak, 2)));
                }
            }
            for (Map map : tab_vat) {
                double stawka = 0.0;
                if (((String)map.get("zb_stawka_vat")).compareToIgnoreCase("zw") != 0) {
                    stawka = Double.parseDouble((String)map.get("zb_stawka_vat"));
                }
                double netto = Double.valueOf((String)map.get("zb_kwota_netto"));
                double kwota_vat = Functions.RoundValue(netto * stawka / 100.0, 2);
                map.put("zb_kwota_vat", String.valueOf(kwota_vat));
                map.put("zb_kwota_brutto", String.valueOf(Functions.RoundValue(kwota_vat + netto, 2)));
            }
            sCenaFra = ((String)sCenaFra).substring(0, ((String)sCenaFra).length() - 1);
            sWartoscFra = ((String)sWartoscFra).substring(0, ((String)sWartoscFra).length() - 1);
            sVat = ((String)sVat).substring(0, ((String)sVat).length() - 1);
            sBrutto = ((String)sBrutto).substring(0, ((String)sBrutto).length() - 1);
            sRabat = ((String)sRabat).substring(0, ((String)sRabat).length() - 1);
        }
        ws_data.put("cena_fakturowania", sCenaFra);
        ws_data.put("wartosc_faktury_sprzedazy", sWartoscFra);
        ws_data.put("kwota_vat", sVat);
        ws_data.put("kwota_brutto", sBrutto);
        ws_data.put("rabat", sRabat);
        ws_data.put("suma_ilosc_wz", Functions.sumColumn((String)processmap.get("ilosc_wz")));
        ws_data.put("suma_uszkodzenia", Functions.sumColumn((String)processmap.get("uszkodzenia")));
        ws_data.put("suma_ilosc_zwalo", Functions.sumColumn((String)processmap.get("ilosc_zwalo")));
        ws_data.put("suma_waloryzacji", Functions.sumColumn((String)processmap.get("wartosc_waloryzacji")));
        String[] vatIDs = new String[]{"zb_stawka_vat", "zb_kwota_netto", "zb_kwota_vat", "zb_kwota_brutto"};
        ws_data.putAll(DynamicTableFunctions.convertFromListOfMapsToMap(tab_vat, (String[])vatIDs));
        ws_data.put("suma_netto_fra", Functions.sumColumn((String)ws_data.get("zb_kwota_netto")));
        ws_data.put("suma_vat", Functions.sumColumn((String)ws_data.get("zb_kwota_vat")));
        ws_data.put("suma_brutto", Functions.sumColumn((String)ws_data.get("zb_kwota_brutto")));
        return ws_data;
    }

    public static boolean setProcessContextMap(SharkTransaction st, String sProcessId, Map processCtx) throws Exception {
        log.trace((Object)("************************* setProcessContextMap(SharkTransaction, sProcessId=" + sProcessId + ", Map) ********************"));
        boolean status = false;
        ExecutionAdministration ea = null;
        try {
            String username = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfProcess wfProcess = ea.getProcess(st, sProcessId);
            status = SharkFunctions.SetProcessContext((SharkTransaction)st, (WfProcess)wfProcess, (Map)processCtx);
            processService.setProcessContext(sProcessId, processCtx);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (st != null && ea != null) {
                ea.disconnect(st);
            }
        }
        return status;
    }

    public static String getIdRec(String sSklep) {
        String sResult = "";
        String sDate = Functions.getCurrentDate("yyyy");
        sSklep = sSklep.split(" - ")[0];
        sSklep = sSklep.substring(0, 5);
        StringBuffer sb = new StringBuffer();
        sb.append("CKD_PW");
        sb.append(sDate);
        sb.append("_");
        sb.append(sSklep);
        String sValue = sb.toString();
        log.trace((Object)("** CKD ** getIdRec pobueram wartosc sequencera " + sValue));
        String sVal = Functions.generateNextValue(sValue, 5);
        sb.delete(0, sb.length());
        sb.append(sDate);
        sb.append("-");
        sb.append(sSklep);
        sb.append("-");
        sb.append(sVal);
        sResult = sb.toString();
        log.trace((Object)("** CKD ** getIdRec nadano nr dla procesu PW " + sResult));
        return sResult;
    }

    public static String getFvNr(boolean is_correct, String sDate, String sSklep) {
        String sResult = "";
        String sYear = sDate.split("-")[0];
        StringBuffer sb = new StringBuffer();
        if (is_correct) {
            sb.append("CKD_PW_KorFV_");
        } else {
            sb.append("CKD_PW_FV_");
        }
        sb.append(sYear);
        sb.append(sSklep);
        String sValue = sb.toString();
        log.trace((Object)("** CKD ** getFvNr pobueram wartosc sequencera " + sValue));
        String sVal = Functions.generateValue(sYear, sSklep, sValue, 3);
        sb.delete(0, sb.length());
        sb.append(sVal);
        if (is_correct) {
            sb.append("/KCK/N/");
        } else {
            sb.append("/CK/N/");
        }
        sb.append(sSklep);
        sb.append("/");
        sb.append(sYear);
        sResult = sb.toString();
        log.trace((Object)("** CKD ** getFvNr nadano nr faktury " + sResult));
        return sResult;
    }

    public static String getInvoiceDate(String sProcessid) {
        String sQuery = "select variablevaluevchar from activitydata where activity in (select objectid from  activities where id like '%_" + sProcessid + "_4_pw_ksiegowosc_fakturowanie' order by activated asc limit 2) and variabledefinitionid = 'data_wystawienia_faktury' and variablevaluevchar!=''";
        log.debug((Object)("Query: " + sQuery));
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(sQuery);
        builder.addScalar("variablevaluevchar", (Type)StandardBasicTypes.STRING);
        List data = finder.find(builder);
        String sList = "";
        if (data.size() > 0) {
            sList = (String)((Map)data.get(0)).get("variablevaluevchar");
        }
        return sList;
    }

    public static Map<String, String> getCustomerDataByNip(String sNip) {
        Map<String, String> contractor = new HashMap<String, String>();
        ArrayList results = new ArrayList();
        String query = "select name as nazwa, oracle_no as nr_oracle, customer_no as nr_klienta, site_code as siedziba, payment_terms as termin_platnosci from pm_custom_contractors where upper(nip) = '" + sNip.toUpperCase() + "' and upper(customer_class) in ('XXLMPL_DOSTAWCY', 'XXLMPL_INTERCO') and name like 'AR_%'";
        log.debug((Object)("Query: " + query));
        try {
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery(query);
            List finder_results = finder.find(builder);
            if (results.size() > 0) {
                for (Map wiersz : finder_results) {
                    HashMap<String, String> oneResult = new HashMap<String, String>();
                    for (String key : wiersz.keySet()) {
                        oneResult.put(key, (String)wiersz.get(key));
                    }
                    results.add(oneResult);
                }
            }
            if (results.size() == 1) {
                contractor = (Map)results.get(0);
            } else {
                log.debug((Object)("Odnaleziono " + results.size() + ". Nie ustawiam numeru klienta."));
            }
        }
        catch (Exception e) {
            log.error((Object)("WYst\u0105pi\u0142 b\u0142\u0105d podczas wyszukwiania nabywcy: " + e.getMessage()), (Throwable)e);
        }
        return contractor;
    }
}

