/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.util.extension.P0015;

import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.transaction.SharkTransactional;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Tools_ProcessManager {
    public static Logger log = Logger.getLogger(Tools_ProcessManager.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;

    @SharkTransactional
    public void acceptAllActivities(String sProcessId, Map<String, Object> valuesToSet) throws Exception {
        log.info((Object)("ZAMYKANIE ZADAN procesu : " + sProcessId));
        try {
            this.acceptActivity(sProcessId, null, valuesToSet);
            log.debug((Object)("ZAMYKANIE ZADAN procesu zakonczone sukcesem : " + sProcessId));
        }
        catch (Exception e) {
            log.error((Object)("ZAMYKANIE ZADAN: Nie udalo sie zamknac zadania procesu " + sProcessId + " :" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public void acceptActivity(String sProcessId, String sActivityName, Map<String, Object> valuesToSet) throws Exception {
        log.info((Object)("Akceptacja zadania " + sActivityName + " procesu: " + sProcessId));
        try {
            SystemParameterService systemParameterService = ServiceFactory.getSystemParameterService();
            SystemParameter buforUserNameParam = systemParameterService.getParameter("Bufor.username");
            AssignmentService assignmentService = ServiceFactory.getAssignmentService();
            List openedActivities = this.activityFinder.findOpenedActivities(sProcessId);
            for (int z = 0; z < openedActivities.size(); ++z) {
                Activity activity = (Activity)openedActivities.get(z);
                if (sActivityName != null && !StringUtils.isEmpty((String)sActivityName) && activity.getName().compareToIgnoreCase(sActivityName) != 0) continue;
                Map mProcessMap = this.processService.getProcessContext(sProcessId);
                Set<String> keys = valuesToSet.keySet();
                for (String key : keys) {
                    mProcessMap.put(key, valuesToSet.get(key));
                }
                String approverLogin = "admin";
                assignmentService.assignActivityToUser(activity.getProcessId(), activity.getActivityId(), approverLogin);
                String executor = "admin";
                String actionName = valuesToSet.get("akcja") == null ? "" : valuesToSet.get("akcja").toString();
                AcceptationDefinition acceptation = new AcceptationDefinition(activity.getProcessId(), activity.getActivityId(), executor, actionName);
                acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
                acceptation.setContextMap(mProcessMap);
                this.activityService.acceptActivity(acceptation);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public synchronized void updateAllOpenedActivities(String processId, Map<String, Object> var_to_put) throws Exception {
        List openedActivities = this.activityFinder.findOpenedActivities(processId);
        for (Activity wfActivity : openedActivities) {
            String activityId = wfActivity.getActivityId();
            log.debug((Object)"Aktualizowane zadanie to: ".concat(activityId));
            Map activityContext = this.activityService.getActivityContext(processId, activityId);
            activityContext.putAll(var_to_put);
            this.activityService.setActivityContext(processId, activityId, activityContext);
        }
        Map processContext = this.processService.getProcessContext(processId);
        processContext.putAll(var_to_put);
        this.processService.setProcessContext(processId, processContext);
    }

    public synchronized boolean updateAllActivitiesAndProcess(SharkTransaction st, String processId, Map<String, Object> var_to_put) throws Exception {
        WfActivity[] wfActivities;
        String[] states = new String[]{"closed.completed", "open.running", "open.not_running.not_started"};
        for (WfActivity wfActivity : wfActivities = SharkFunctions.getWfActivities((SharkTransaction)st, (String)processId, (String[])states)) {
            String activityId = wfActivity.key(st);
            if (activityId.indexOf(processId) < 0) continue;
            log.debug((Object)"Aktualizowane zadanie to: ".concat(activityId));
            Map processContext = SharkClientFunctions.getActivityContextMap((SharkTransaction)st, (String)processId, (String)activityId);
            processContext.putAll(var_to_put);
            SharkClientFunctions.setActivityContextMap((SharkTransaction)st, (String)processId, (String)activityId, (Map)processContext);
        }
        Map processContext = SharkClientFunctions.getProcessContextMap((SharkTransaction)st, (String)processId);
        processContext.putAll(var_to_put);
        return SharkClientFunctions.setProcessContextMap((SharkTransaction)st, (String)processId, (Map)processContext);
    }

    public synchronized boolean updateActivitiyAndProcess(SharkTransaction st, String processId, String sActivityName, Map<String, Object> var_to_put) throws Exception {
        WfActivity[] wfActivities;
        String[] states = new String[]{"closed.completed", "open.running", "open.not_running.not_started"};
        for (WfActivity wfActivity : wfActivities = SharkFunctions.getWfActivities((SharkTransaction)st, (String)processId, (String[])states)) {
            String activityId = wfActivity.key(st);
            if (activityId.indexOf(processId) < 0 || activityId.indexOf(sActivityName) < 0) continue;
            log.debug((Object)"Aktualizowane zadanie to: ".concat(activityId));
            Map processContext = SharkClientFunctions.getActivityContextMap((SharkTransaction)st, (String)processId, (String)activityId);
            processContext.putAll(var_to_put);
            SharkClientFunctions.setActivityContextMap((SharkTransaction)st, (String)processId, (String)activityId, (Map)processContext);
        }
        Map processContext = SharkClientFunctions.getProcessContextMap((SharkTransaction)st, (String)processId);
        processContext.putAll(var_to_put);
        return SharkClientFunctions.setProcessContextMap((SharkTransaction)st, (String)processId, (Map)processContext);
    }
}

