/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.VAT;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.VATDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="VATDao")
public class VATDaoImpl
extends HibernateEditableDao<VAT, Long>
implements VATDao {
    public static Logger log = Logger.getLogger((String)"VATDaoImpl");

    @Override
    @Transactional
    public VAT getValueById(Long lId) throws HibernateException {
        log.debug((Object)"************************* getVATById ********************");
        Session session = null;
        VAT vat = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            vat = (VAT)session.get(VAT.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return vat;
    }

    @Override
    @Transactional
    public List<VAT> getVATByNr(int nr) throws HibernateException {
        log.debug((Object)"************************* getVATByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from VAT ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        log.debug((Object)("************************* deleteAccountTableById **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            VAT vat = (VAT)session.get(VAT.class, (Serializable)lId);
            if (vat != null) {
                session.delete((Object)vat);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateVAT(VAT vat) throws HibernateException {
        log.debug((Object)"************************* updateVAT ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)vat);
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<VAT> getAllVAT() {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from VAT )";
            log.debug((Object)("Query: " + sQuery));
            result = session.createQuery("from VAT").list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public VAT getVATValueByCode(String sCode) throws HibernateException {
        log.debug((Object)"************************* getVATValueByCode ********************");
        Session session = null;
        VAT result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from VAT ac where upper(ac.description) = :sCode";
            result = (VAT)session.createQuery(sQuery).setParameter("sCode", (Object)sCode).uniqueResult();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

