/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.Sklepy;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SklepyDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="SklepyDao")
public class SklepyDaoImpl
extends HibernateEditableDao<Sklepy, Long>
implements SklepyDao {
    public Logger log = Logger.getLogger(SklepyDaoImpl.class);

    @Override
    @Transactional
    public Sklepy getValueById(Long lId) throws HibernateException {
        this.log.debug((Object)"************************* getSklepyById ********************");
        Session session = null;
        Sklepy sklepy = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            sklepy = (Sklepy)session.get(Sklepy.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return sklepy;
    }

    @Override
    @Transactional
    public List<Sklepy> getSklepyByNr(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getSklepyByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Sklepy ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Sklepy getSklepBySymbol(String sSymbol) throws HibernateException {
        this.log.debug((Object)"************************* getSklepyBySymbol ********************");
        Session session = null;
        Sklepy result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Sklepy ac where ac.sklep = :sSymbol";
            result = (Sklepy)session.createQuery(sQuery).setParameter("sSymbol", (Object)sSymbol).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Object getShopBySymbol(String sSymbol) throws HibernateException {
        this.log.debug((Object)"************************* getSklepBySymbol ********************");
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "select opis from Sklepy where sklep = :sSklep";
            result = session.createQuery(sQuery).setParameter("sSklep", (Object)sSymbol).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        this.log.debug((Object)("************************* deleteAccountTableById **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            Sklepy sklepy = (Sklepy)session.get(Sklepy.class, (Serializable)lId);
            if (sklepy != null) {
                session.delete((Object)sklepy);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateSklepy(Sklepy sklepy) throws HibernateException {
        this.log.debug((Object)"************************* changeSklepy ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)sklepy);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<Sklepy> getAllSklepy() {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from Sklepy )";
            this.log.debug((Object)("Query: " + sQuery));
            result = session.createQuery("from Sklepy").list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<Sklepy> getAllSklepyExcept(List<String> excluded) {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from Sklepy where sklep not in ( :excluded )";
            this.log.debug((Object)("Query: " + sQuery));
            result = session.createQuery(sQuery).setParameterList("excluded", excluded).list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Sklepy getSklepyByNrCkd(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getSklepyByNrCkd ********************");
        Session session = null;
        Sklepy result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Sklepy ac where ac.ckd = :ckd";
            result = (Sklepy)session.createQuery(sQuery).setParameter("ckd", (Object)String.valueOf(nr)).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<Sklepy> getAllSklepyForCkd() throws HibernateException {
        this.log.debug((Object)"************************* getAllSklepyForCkd ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Sklepy ac where ac.ckd <> ''";
            result = session.createQuery(sQuery).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

