/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.SendToOracle;
import com.suncode.plugin.lm.DirectDB.copyInitData.SendToOraclePrimaryKey;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SendToOracleDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="SendToOracleDao")
public class SendToOracleDaoImpl
extends HibernateEditableDao<SendToOracle, SendToOraclePrimaryKey>
implements SendToOracleDao {
    public static Logger log = Logger.getLogger(SendToOracleDaoImpl.class);

    @Override
    @Transactional
    public void addToTable(SendToOracle sendToOracle) throws HibernateException {
        log.trace((Object)"************************* addToTable ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.save((Object)sendToOracle);
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(SendToOracle sendToOracle) throws HibernateException {
        log.trace((Object)"************************* deleteValue **************");
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.delete((Object)sendToOracle);
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public List<SendToOracle> getAllSendToOracle() throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from SendToOracle").list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<SendToOracle> getAllSendToOracleByCategoryAndCurrency(String sCategory, String sCurrency, String sOperation) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from SendToOracle where sCategory = :category and sCurrency = :currency and upper(sOperation) = upper(:sOperation)").setParameter("category", (Object)sCategory).setParameter("currency", (Object)sCurrency).setParameter("sOperation", (Object)sOperation).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<SendToOracle> getAllSendToOracleByCategoryAndCurrencyAndDate(String sCategory, String sCurrency, String sOperation, Date sSendDate) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from SendToOracle where sCategory = :category and sCurrency = :currency and upper(sOperation) = upper(:sOperation) and dGenerateDate = :generateDate").setParameter("category", (Object)sCategory).setParameter("currency", (Object)sCurrency).setParameter("sOperation", (Object)sOperation).setParameter("generateDate", (Object)sSendDate).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public int checkIfExistSendToOracleByCategoryAndOperation(String sCategory, String sOperation) throws HibernateException {
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select count(sProcessId) from SendToOracle where sCategory = :category and upper(sOperation) = upper(:sOperation)").setParameter("category", (Object)sCategory).setParameter("sOperation", (Object)sOperation).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        String sTemp = String.valueOf(result);
        int iResult = Integer.valueOf(sTemp);
        return iResult;
    }

    @Override
    @Transactional
    public int checkIfExistSendToOracleByCategoryAndOperationAndDate(String sCategory, String sOperation, Date dGenDate) throws HibernateException {
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select count(sProcessId) from SendToOracle where sCategory = :category and upper(sOperation) = upper(:sOperation) and dGenerateDate = :generateDate").setParameter("category", (Object)sCategory).setParameter("sOperation", (Object)sOperation).setParameter("generateDate", (Object)dGenDate).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        String sTemp = String.valueOf(result);
        int iResult = Integer.valueOf(sTemp);
        return iResult;
    }

    @Override
    @Transactional
    public List<String> getAllCategorySendToOracle() throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCategory from SendToOracle").list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<String> getAllCategorySendToOracleWithDate(Date dGenDate) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCategory from SendToOracle where dGenerateDate = :generateDate").setParameter("generateDate", (Object)dGenDate).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<String> getAllCurrencySendToOracle(String category) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCurrency from SendToOracle where sCategory = :sCategory").setParameter("sCategory", (Object)category).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
            throw he;
        }
        return result;
    }

    @Override
    @Transactional
    public List<String> getAllCurrencySendToOracleWithDate(String category, Date dGenDate) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCurrency from SendToOracle where sCategory = :sCategory and dGenerateDate = :generateDate").setParameter("sCategory", (Object)category).setParameter("generateDate", (Object)dGenDate).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
            throw he;
        }
        return result;
    }
}

