/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.Projekt;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.ProjektDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="ProjektDao")
public class ProjektDaoImpl
extends HibernateEditableDao<Projekt, Long>
implements ProjektDao {
    public Logger log = Logger.getLogger(ProjektDaoImpl.class);

    @Override
    @Transactional
    public Projekt getValueById(Long lId) throws HibernateException {
        this.log.debug((Object)"************************* getProjektById ********************");
        Session session = null;
        Projekt projekt = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            projekt = (Projekt)session.get(Projekt.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return projekt;
    }

    @Override
    @Transactional
    public List<Projekt> getProjektByNr(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getProjektByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Projekt ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        this.log.debug((Object)("************************* deleteProjektByNr **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            Projekt projekt = (Projekt)session.get(Projekt.class, (Serializable)lId);
            if (projekt != null) {
                session.delete((Object)projekt);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateProjekt(Projekt projekt) throws HibernateException {
        this.log.debug((Object)"************************* updateProjekt ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)projekt);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<Projekt> getProjekty(String sValue) throws HibernateException {
        this.log.debug((Object)"************************* getProjekty ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from Projekt d where d.projekt like :value ").setParameter("value", (Object)sValue).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

