/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.OracleHistory;
import com.suncode.plugin.lm.DirectDB.copyInitData.OracleHistoryPrimaryKey;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.OracleHistoryDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="OracleHistoryDao")
public class OracleHistoryDaoImpl
extends HibernateEditableDao<OracleHistory, OracleHistoryPrimaryKey>
implements OracleHistoryDao {
    public static Logger log = Logger.getLogger(OracleHistoryDaoImpl.class);

    @Override
    @Transactional
    public void addToTable(OracleHistory oracleHistory) throws HibernateException {
        log.trace((Object)"************************* addToTable ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.save((Object)oracleHistory);
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(OracleHistory oracleHistory) throws HibernateException {
        log.trace((Object)"************************* deleteValue **************");
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.delete((Object)oracleHistory);
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public List<OracleHistory> getAllOracleHistory() throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from OracleHistory").list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<OracleHistory> getAllOracleHistoryByCategoryAndCurrency(String sCategory, String sCurrency, String sOperation) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from OracleHistory where sCategory = :category and sCurrency = :currency and upper(sOperation) = upper(:sOperation)").setParameter("category", (Object)sCategory).setParameter("currency", (Object)sCurrency).setParameter("sOperation", (Object)sOperation).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<OracleHistory> getAllOracleHistoryByCategoryAndCurrencyAndDate(String sCategory, String sCurrency, String sOperation, Date sSendDate) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from OracleHistory where sCategory = :category and sCurrency = :currency and upper(sOperation) = upper(:sOperation) and dGenerateDate = :generateDate").setParameter("category", (Object)sCategory).setParameter("currency", (Object)sCurrency).setParameter("sOperation", (Object)sOperation).setParameter("generateDate", (Object)sSendDate).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public int checkIfExistOracleHistoryByCategoryAndOperation(String sCategory, String sOperation) throws HibernateException {
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select count(sProcessId) from OracleHistory where sCategory = :category and upper(sOperation) = upper(:sOperation)").setParameter("category", (Object)sCategory).setParameter("sOperation", (Object)sOperation).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        String sTemp = String.valueOf(result);
        int iResult = Integer.valueOf(sTemp);
        return iResult;
    }

    @Override
    @Transactional
    public int checkIfExistOracleHistoryByProcessIdAndOperation(String sProcessId, String sOperation) throws HibernateException {
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select count(sProcessId) from OracleHistory where sProcessId = :processId and sOperation =:operation ").setParameter("processId", (Object)sProcessId).setParameter("operation", (Object)sOperation).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        String sTemp = String.valueOf(result);
        int iResult = Integer.valueOf(sTemp);
        return iResult;
    }

    @Override
    @Transactional
    public int checkIfExistOracleHistoryByCategoryAndOperationAndDate(String sCategory, String sOperation, Date dGenDate) throws HibernateException {
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select count(sProcessId) from OracleHistory where sCategory = :category and upper(sOperation) = upper(:sOperation) and dGenerateDate = :generateDate").setParameter("category", (Object)sCategory).setParameter("sOperation", (Object)sOperation).setParameter("generateDate", (Object)dGenDate).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        String sTemp = String.valueOf(result);
        int iResult = Integer.valueOf(sTemp);
        return iResult;
    }

    @Override
    @Transactional
    public List<String> getAllCategoryOracleHistory() throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCategory from OracleHistory").list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<String> getAllCategoryOracleHistoryWithDate(Date dGenDate) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCategory from OracleHistory where dGenerateDate = :generateDate").setParameter("generateDate", (Object)dGenDate).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<String> getAllCurrencyOracleHistory(String category) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCurrency from OracleHistory where sCategory = :sCategory").setParameter("sCategory", (Object)category).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<String> getAllCurrencyOracleHistoryWithDate(String category, Date dGenDate) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select distinct sCurrency from OracleHistory where sCategory = :sCategory and dGenerateDate = :generateDate").setParameter("sCategory", (Object)category).setParameter("generateDate", (Object)dGenDate).list();
            session.flush();
        }
        catch (HibernateException he) {
            log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

