/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.MPK;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.MPKDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="MPKDao")
public class MPKDaoImpl
extends HibernateEditableDao<MPK, Long>
implements MPKDao {
    public Logger log = Logger.getLogger(MPKDaoImpl.class);

    @Override
    @Transactional
    public MPK getValueById(Long lId) throws HibernateException {
        this.log.debug((Object)"************************* getMPKById ********************");
        Session session = null;
        MPK mpk = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            mpk = (MPK)session.get(MPK.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return mpk;
    }

    @Override
    @Transactional
    public List<MPK> getMPKByNr(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getMPKByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from MPK ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public MPK getMPKBySymbol(String sSymbol) throws HibernateException {
        this.log.debug((Object)"************************* getMPKBySymbol ********************");
        Session session = null;
        MPK result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from MPK ac where ac.mpk = :sSymbol";
            result = (MPK)session.createQuery(sQuery).setParameter("sSymbol", (Object)sSymbol).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Object getMPKByNrMPK(String sSymbol) throws HibernateException {
        this.log.debug((Object)"************************* getMPKByNrMPK ********************");
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "select opis from MPK ac where ac.mpk = :sSymbol";
            result = session.createQuery(sQuery).setParameter("sSymbol", (Object)sSymbol).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        this.log.debug((Object)("************************* deleteMPKByNr **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            MPK mpk = (MPK)session.get(MPK.class, (Serializable)lId);
            if (mpk != null) {
                session.delete((Object)mpk);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateMPK(MPK mpk) throws HibernateException {
        this.log.debug((Object)"************************* updateMPK ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)mpk);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<MPK> getAllMPK() {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from MPK )";
            this.log.debug((Object)("Query: " + sQuery));
            result = session.createQuery("from MPK").list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public MPK getMPKByNrCkd(String nr) throws HibernateException {
        this.log.debug((Object)"************************* getMPKByNrCkd ********************");
        Session session = null;
        MPK result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from MPK ac where ac.ckd = :ckd";
            result = (MPK)session.createQuery(sQuery).setParameter("ckd", (Object)nr).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

