/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.Currency;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.CurrencyDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="CurrencyDao")
public class CurrencyDaoImpl
extends HibernateEditableDao<Currency, Long>
implements CurrencyDao {
    public Logger log = Logger.getLogger(CurrencyDaoImpl.class);

    @Override
    @Transactional
    public Currency getValueById(Long lId) throws HibernateException {
        this.log.debug((Object)"************************* getCurrencyById ********************");
        Session session = null;
        Currency currency = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            currency = (Currency)session.get(Currency.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return currency;
    }

    @Override
    @Transactional
    public List<Currency> getCurrencyByNr(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getCurrencyByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Currency ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        this.log.debug((Object)("************************* deleteCurrencyById **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            Currency currency = (Currency)session.get(Currency.class, (Serializable)lId);
            if (currency != null) {
                session.delete((Object)currency);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateCurrency(Currency currency) throws HibernateException {
        this.log.debug((Object)"************************* updateCurrency ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)currency);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<Currency> getAllCurrency() {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from Currency )";
            this.log.debug((Object)("Query: " + sQuery));
            result = session.createQuery("from Currency").list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

