/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.Category;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.CategoryDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="CategoryDao")
public class CategoryDaoImpl
extends HibernateEditableDao<Category, Long>
implements CategoryDao {
    public Logger log = Logger.getLogger(CategoryDaoImpl.class);

    @Override
    @Transactional
    public Category getValueById(Long lId) throws HibernateException {
        this.log.debug((Object)"************************* getCategoryById ********************");
        Session session = null;
        Category category = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            category = (Category)session.get(Category.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return category;
    }

    @Override
    @Transactional
    public List<Category> getCategoryByNr(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getCategoryByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Category ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        this.log.debug((Object)("************************* deleteCategoryByNr **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            Category category = (Category)session.get(Category.class, (Serializable)lId);
            if (category != null) {
                session.delete((Object)category);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateCategory(Category category) throws HibernateException {
        this.log.debug((Object)"************************* updateCategory ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)category);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<Category> getAllCategory() {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from Category )";
            this.log.debug((Object)("Query: " + sQuery));
            result = session.createQuery("from Category").list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Category getCategoryByName(String sName) throws HibernateException {
        this.log.debug((Object)"************************* getCategoryByName ********************");
        sName = sName.toUpperCase();
        Session session = null;
        Category result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Category ac where upper(ac.name) = :sName";
            result = (Category)session.createQuery(sQuery).setParameter("sName", (Object)sName).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Category getCategoryByCode(String sName) throws HibernateException {
        this.log.debug((Object)"************************* getCategoryByCode ********************");
        Session session = null;
        Category result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Category ac where ac.code = :sName";
            result = (Category)session.createQuery(sQuery).setParameter("sName", (Object)sName).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

