/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.lm.DirectDB.copyInitData.dao;

import com.suncode.plugin.lm.DirectDB.copyInitData.Addresses;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.AddressesDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="AddressesDao")
public class AddressesDaoImpl
extends HibernateEditableDao<Addresses, Long>
implements AddressesDao {
    public Logger log = Logger.getLogger(AddressesDaoImpl.class);

    @Override
    @Transactional
    public Addresses getValueById(Long lId) throws HibernateException {
        this.log.debug((Object)"************************* getAddressesById ********************");
        Session session = null;
        Addresses addresses = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            addresses = (Addresses)session.get(Addresses.class, (Serializable)lId);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return addresses;
    }

    @Override
    @Transactional
    public List<Addresses> getAddressesByNr(int nr) throws HibernateException {
        this.log.debug((Object)"************************* getAddressesByNr ********************");
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Addresses ac where ac.nr = :iNr";
            result = session.createQuery(sQuery).setParameter("iNr", (Object)nr).list();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteValueByNr(Long lId) throws HibernateException {
        this.log.debug((Object)("************************* deleteAddressesByNr **Id = " + lId + " **************"));
        boolean bResult = true;
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            Addresses addresses = (Addresses)session.get(Addresses.class, (Serializable)lId);
            if (addresses != null) {
                session.delete((Object)addresses);
            } else {
                bResult = false;
            }
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return bResult;
    }

    @Override
    @Transactional
    public void updateAddresses(Addresses addresses) throws HibernateException {
        this.log.debug((Object)"************************* updateAddresses ********************");
        Session session = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            session.update((Object)addresses);
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
    }

    @Override
    @Transactional
    public List<Addresses> getAllAddresses() {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = " from Addresses )";
            this.log.debug((Object)("Query: " + sQuery));
            result = session.createQuery("from Addresses").list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public Addresses getAddressesByLocalization(String sLocalization) throws HibernateException {
        this.log.debug((Object)"************************* getAddressesByLocalization ********************");
        Session session = null;
        Addresses result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            String sQuery = "from Addresses ac where ac.localization = :sLocalization";
            result = (Addresses)session.createQuery(sQuery).setParameter("sLocalization", (Object)sLocalization).uniqueResult();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

