/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.lm.applications.saleinvoices;

import com.plusmpm.CUF.util.DataChoosers.ExecuteQueryDataChooser;
import com.suncode.cuf.math.MathFunctions;
import com.suncode.lm.ClientTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FSTools {
    private static Logger log = Logger.getLogger(FSTools.class);
    public static final String PACKAGE_ID = "LM";
    public static final String FS_DOCUMENT_CLASS_NAME = "Faktury sprzeda\u017cy";
    public static final String TEMP_PATH = "/home/suncode/temp/";
    public static final String CLAUSE_SPLIT_PAYMENT = "W przypadku, je\u015bli przedmiotem transakcji, kt\u00f3r\u0105 dokumentuje niniejsza faktura, s\u0105 towary lub us\u0142ugi wymienione w za\u0142\u0105czniku nr 15 do ustawy z dnia 11 marca 2004 r. o podatku od towar\u00f3w i us\u0142ug, p\u0142atno\u015b\u0107 za te towary lub us\u0142ugi powinna zosta\u0107 dokonana w spos\u00f3b wykorzystuj\u0105cy \"mechanizm podzielonej p\u0142atno\u015bci\".";

    public static String changeVatRateFormat(String inVatRates) {
        if (StringUtils.isNotBlank((String)inVatRates)) {
            String[] vatRates = ((String)inVatRates).split(";");
            inVatRates = "";
            for (String vatRate : vatRates) {
                inVatRates = (String)inVatRates + FSTools.getVatRate(vatRate) + ";";
            }
            inVatRates = ((String)inVatRates).substring(0, ((String)inVatRates).length() - 1);
        }
        return inVatRates;
    }

    public static String roundColumn(String values, int accuracy) {
        String[] sAmount = ((String)values).split(";");
        values = "";
        for (String amount : sAmount) {
            double tmp = 0.0;
            if (amount.compareToIgnoreCase("") != 0) {
                tmp = MathFunctions.round((double)Double.valueOf(amount), (int)accuracy);
            }
            values = (String)values + String.valueOf(tmp) + ";";
        }
        values = ((String)values).substring(0, ((String)values).length() - 1);
        return values;
    }

    public static String getPaymentTermsForDocument(String sPaymentCode) {
        int paymentDays = ClientTools.changeStringToInteger(FSTools.getPaymentDays(sPaymentCode));
        return paymentDays == 1 ? String.valueOf(paymentDays) + " dzie\u0144" : String.valueOf(paymentDays) + " dni";
    }

    public static String getPaymentDays(String paymentCode) {
        return paymentCode.contains(" d") ? paymentCode.substring(0, paymentCode.indexOf(" ")) : paymentCode.substring(1, paymentCode.length());
    }

    public static String getVatRate(String code) {
        double dVatRate = 0.0;
        try {
            dVatRate = Double.valueOf(code);
            code = code.concat("%");
        }
        catch (Exception e) {
            log.debug((Object)"Stawka nieliczbowa. Nie dodaje znaku %");
        }
        return code;
    }

    public static Map<String, String> getEanData(String ean) {
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        String queryName = "fs_ean_data";
        log.debug((Object)("NameForQuery: " + queryName));
        log.debug((Object)("Szukam danych fs_ean_data: " + ean));
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", queryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("ean", ean);
        HashMap<String, String> oneResult = new HashMap<String, String>();
        List results = dc.getDataChooserResult(0, 50, null, "DESC", criteria, customKeys);
        if (results != null && results.size() > 0) {
            oneResult.putAll((Map)results.get(0));
        }
        return oneResult;
    }
}

