/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.lm.applications.saleinvoices;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.cuf.math.MathFunctions;
import com.suncode.lm.ClientTools;
import com.suncode.lm.Value2Txt;
import com.suncode.lm.applications.saleinvoices.FSTools;
import com.suncode.lm.applications.saleinvoices.VatRatesComparator;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Application
public class FSGenerateDocument {
    public static Logger log = Logger.getLogger(FSGenerateDocument.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("sale-invoice-generator-application")).name("Generowanie faktury sprzeda\u017cy")).description("Generowanie faktury sprzeda\u017cy")).category(new Category[]{Categories.CLIENT})).parameter().id("document_number").name("application.parameter.document_number.name").description("application.parameter.document_number.desc").type((Type)Types.STRING).create()).parameter().id("file_id").name("application.parameter.file_id.name").description("application.parameter.file_id.desc").type((Type)Types.VARIABLE).create()).parameter().id("zmiana_netto").name("application.parameter.zmiana_netto.name").description("application.parameter.zmiana_netto.desc").type((Type)Types.VARIABLE).create()).parameter().id("zmiana_brutto").name("application.parameter.zmiana_brutto.name").description("application.parameter.zmiana_brutto.desc").type((Type)Types.VARIABLE).create()).parameter().id("zmiana_vat").name("application.parameter.zmiana_vat.name").description("application.parameter.zmiana_vat.desc").type((Type)Types.VARIABLE).create()).parameter().id("doc_type_code").name("application.parameter.doc_type_code.name").description("application.parameter.doc_type_code.desc").type((Type)Types.STRING).create()).parameter().id("status").name("application.parameter.status.name").description("application.parameter.status.desc").type((Type)Types.VARIABLE).create()).parameter().id("action").name("application.parameter.action.name").description("application.parameter.action.desc").type((Type)Types.VARIABLE).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ApplicationContext appContext, @Param String doc_type_code, @Param Variable action, @Param String document_number, @Param Variable file_id, @Param Variable zmiana_netto, @Param Variable zmiana_brutto, @Param Variable zmiana_vat, @Param Variable status) throws Exception {
        String sProcessId = appContext.getProcessId();
        String sActivityId = appContext.getActivityId();
        String sAction = action.toString();
        log.info((Object)("FSGenerateDocument - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            String row;
            ProcessService processService = ServiceFactory.getProcessService();
            ActivityService activityService = ServiceFactory.getActivityService();
            Map mappings = activityService.getActivityContext(sProcessId, sActivityId);
            String currency = (String)mappings.get("waluta");
            log.debug((Object)("Kod dokumentu ****************" + doc_type_code));
            String sNip = (String)mappings.get("nip");
            if (sNip.startsWith("PL")) {
                mappings.put("nip", sNip.substring(2));
            }
            if (doc_type_code.startsWith("UA")) {
                FSGenerateDocument.setDataByEan(mappings);
            }
            Double netSum = (Double)mappings.get("suma_netto");
            Double vatSum = (Double)mappings.get("suma_vat");
            Double grossSum = (Double)mappings.get("suma_brutto");
            Double netPlnSum = (Double)mappings.get("suma_netto_pln");
            Double vatPlnSum = (Double)mappings.get("suma_vat_pln");
            Double grossPlnSum = (Double)mappings.get("suma_brutto_pln");
            mappings.put("suma_netto", ClientTools.changeDoubleFormat(String.valueOf(netSum)));
            mappings.put("suma_vat", ClientTools.changeDoubleFormat(String.valueOf(vatSum)));
            mappings.put("suma_brutto", ClientTools.changeDoubleFormat(String.valueOf(grossSum)));
            mappings.put("suma_netto_pln", ClientTools.changeDoubleFormat(String.valueOf(netPlnSum)));
            mappings.put("suma_vat_pln", ClientTools.changeDoubleFormat(String.valueOf(vatPlnSum)));
            mappings.put("suma_brutto_pln", ClientTools.changeDoubleFormat(String.valueOf(grossPlnSum)));
            Double dGrossDifference = 0.0;
            Double dPlnGrossDifference = 0.0;
            String platnoscSlownie = "do zap\u0142aty";
            String oryginalDocNumber = (String)mappings.get("nr_dokumentu_oryginalnego");
            if (doc_type_code.startsWith("FK") || doc_type_code.compareToIgnoreCase("U") == 0 && StringUtils.isNotBlank((String)oryginalDocNumber)) {
                String[] colIDs = new String[]{"tab1_stawka_vat", "tab1_wartosc_netto", "tab1_kwota_vat", "tab1_wartosc_brutto"};
                String[] vatIDs = new String[]{"zb_stawka_vat_kor", "zb_kwota_netto_kor", "zb_kwota_vat_kor", "zb_kwota_brutto_kor"};
                String correctionVatRates = (String)mappings.get("tab1_stawka_vat");
                FSGenerateDocument.setVatTableData(mappings, vatIDs, colIDs, correctionVatRates);
                mappings.put("tab1_cena_netto", ClientTools.changeDoubleFormat((String)mappings.get("tab1_cena_netto")));
                mappings.put("tab1_wartosc_netto", ClientTools.changeDoubleFormat((String)mappings.get("tab1_wartosc_netto")));
                mappings.put("tab1_stawka_vat", FSTools.changeVatRateFormat((String)mappings.get("tab1_stawka_vat")));
                mappings.put("tab1_kwota_vat", ClientTools.changeDoubleFormat(FSTools.roundColumn((String)mappings.get("tab1_kwota_vat"), 2)));
                mappings.put("tab1_wartosc_brutto", ClientTools.changeDoubleFormat(FSTools.roundColumn((String)mappings.get("tab1_wartosc_brutto"), 2)));
                row = FSGenerateDocument.setRowId((String)mappings.get("tab1_opis_pozycji"));
                mappings.put("tab1_row_id", row);
                Map correctedContext = SharkClientFunctions.getProcessContextMap((String)((String)mappings.get("pid_kopiowanego_dok")));
                if (correctedContext != null && !correctedContext.isEmpty()) {
                    Double correctedNetSum = (Double)correctedContext.get("suma_netto");
                    Double correctedVatSum = (Double)correctedContext.get("suma_vat");
                    Double correctedGrossSum = (Double)correctedContext.get("suma_brutto");
                    Double correctedPlnNetSum = (Double)correctedContext.get("suma_netto_pln");
                    Double correctedPlnVatSum = (Double)correctedContext.get("suma_vat_pln");
                    Double correctedPlnGrossSum = (Double)correctedContext.get("suma_brutto_pln");
                    Double dNettDifference = MathFunctions.round((double)MathFunctions.subtract((double)netSum, (double)correctedNetSum), (int)2);
                    Double dVatDifference = MathFunctions.round((double)MathFunctions.subtract((double)vatSum, (double)correctedVatSum), (int)2);
                    dGrossDifference = MathFunctions.round((double)MathFunctions.subtract((double)grossSum, (double)correctedGrossSum), (int)2);
                    Double dNettPlnDifference = MathFunctions.round((double)MathFunctions.subtract((double)netPlnSum, (double)correctedPlnNetSum), (int)2);
                    Double dPlnVatDifference = MathFunctions.round((double)MathFunctions.subtract((double)vatPlnSum, (double)correctedPlnVatSum), (int)2);
                    dPlnGrossDifference = MathFunctions.round((double)MathFunctions.subtract((double)grossPlnSum, (double)correctedPlnGrossSum), (int)2);
                    mappings.put("zmiana_netto", ClientTools.changeDoubleFormat(String.valueOf(dNettDifference)));
                    mappings.put("zmiana_vat", ClientTools.changeDoubleFormat(String.valueOf(dVatDifference)));
                    mappings.put("zmiana_brutto", ClientTools.changeDoubleFormat(String.valueOf(dGrossDifference)));
                    mappings.put("zmiana_netto_pln", ClientTools.changeDoubleFormat(String.valueOf(dNettPlnDifference)));
                    mappings.put("zmiana_vat_pln", ClientTools.changeDoubleFormat(String.valueOf(dPlnVatDifference)));
                    mappings.put("zmiana_brutto_pln", ClientTools.changeDoubleFormat(String.valueOf(dPlnGrossDifference)));
                    mappings.put("kwota_slownie", Value2Txt.formStringWithCurrency(dGrossDifference, currency));
                    mappings.put("suma_netto_kor", ClientTools.changeDoubleFormat(String.valueOf(correctedNetSum)));
                    mappings.put("suma_vat_kor", ClientTools.changeDoubleFormat(String.valueOf(correctedVatSum)));
                    mappings.put("suma_brutto_kor", ClientTools.changeDoubleFormat(String.valueOf(correctedGrossSum)));
                    mappings.put("suma_netto_kor_pln", ClientTools.changeDoubleFormat(String.valueOf(correctedPlnNetSum)));
                    mappings.put("suma_vat_kor_pln", ClientTools.changeDoubleFormat(String.valueOf(correctedPlnVatSum)));
                    mappings.put("suma_brutto_kor_pln", ClientTools.changeDoubleFormat(String.valueOf(correctedPlnGrossSum)));
                    mappings.put("data_kursu_kor", correctedContext.get("data_kursu").toString());
                    mappings.put("waluta_kor", correctedContext.get("waluta").toString());
                    mappings.put("kurs_waluty_kor", correctedContext.get("kurs_waluty").toString());
                    mappings.put("data_dok_korygowanego", (String)correctedContext.get("data_wystawienia_faktury"));
                    if (dGrossDifference <= 0.0) {
                        mappings.put("kwota_slownie", Value2Txt.formStringWithCurrency(MathFunctions.round((double)MathFunctions.multiply((double)dGrossDifference, (double)-1.0), (int)2), currency));
                        platnoscSlownie = "do zwrotu";
                    }
                    String clause = dGrossDifference < 0.0 ? "\"Niniejsza faktura koryguj\u0105ca stanowi potwierdzenie dokonania uzgodnie\u0144 obni\u017cenia podstawy opodatkowania pomi\u0119dzy stronami. Za dat\u0119 dokonania uzgodnie\u0144 uwa\u017ca si\u0119 dzie\u0144 wystawienia faktury koryguj\u0105cej.\"" : "";
                    mappings.put("klauzula_na_minus", clause);
                    zmiana_netto.setValue((Object)dNettDifference);
                    zmiana_vat.setValue((Object)dVatDifference);
                    zmiana_brutto.setValue((Object)dGrossDifference);
                }
            }
            if (doc_type_code.compareToIgnoreCase("O") != 0 && doc_type_code.compareToIgnoreCase("U") != 0) {
                String positionVatRates = (String)mappings.get("tab2_stawka_vat");
                mappings.put("tab2_stawka_vat", FSTools.changeVatRateFormat(positionVatRates));
                String[] colIDs = new String[]{"tab2_stawka_vat", "tab2_wartosc_netto", "tab2_kwota_vat", "tab2_wartosc_brutto"};
                String[] vatIDs = new String[]{"zb_stawka_vat", "zb_kwota_netto", "zb_kwota_vat", "zb_kwota_brutto"};
                FSGenerateDocument.setVatTableData(mappings, vatIDs, colIDs, positionVatRates);
                mappings.put("tab2_cena_netto", ClientTools.changeDoubleFormat((String)mappings.get("tab2_cena_netto")));
                mappings.put("tab2_wartosc_netto", ClientTools.changeDoubleFormat((String)mappings.get("tab2_wartosc_netto")));
                mappings.put("tab2_kwota_vat", ClientTools.changeDoubleFormat(FSTools.roundColumn((String)mappings.get("tab2_kwota_vat"), 2)));
                mappings.put("tab2_wartosc_brutto", ClientTools.changeDoubleFormat(FSTools.roundColumn((String)mappings.get("tab2_wartosc_brutto"), 2)));
                row = FSGenerateDocument.setRowId((String)mappings.get("tab2_opis_pozycji"));
                mappings.put("tab2_row_id", row);
                String sSplitPayment = (String)mappings.get("split_payment");
                if (StringUtils.isNotBlank((String)sSplitPayment) && sSplitPayment.compareToIgnoreCase("TAK") == 0) {
                    log.debug((Object)"Zaznaczam split payment");
                    mappings.put("split_payment", "W przypadku, je\u015bli przedmiotem transakcji, kt\u00f3r\u0105 dokumentuje niniejsza faktura, s\u0105 towary lub us\u0142ugi wymienione w za\u0142\u0105czniku nr 15 do ustawy z dnia 11 marca 2004 r. o podatku od towar\u00f3w i us\u0142ug, p\u0142atno\u015b\u0107 za te towary lub us\u0142ugi powinna zosta\u0107 dokonana w spos\u00f3b wykorzystuj\u0105cy \"mechanizm podzielonej p\u0142atno\u015bci\".".replace("\\", ""));
                } else if (sSplitPayment == null && positionVatRates.contains("Od.ob")) {
                    mappings.put("split_payment", "Podmiotem zobowi\u0105zanym do rozliczenia podatku VAT jest nabywca, zgodnie z   Art. 17 ust. 1 pkt. 7 Ustawy z dnia 11 marca 2004 r. o podatku od towar\u00f3w i us\u0142ug z p\u00f3\u017aniejszymi zmianami. \"odwrotne obci\u0105\u017cenie\", \"reverse charge\".");
                } else {
                    mappings.put("split_payment", "");
                }
            } else {
                String platnosc_zwrot = "Kwota do zap\u0142aty";
                StringBuilder sb = new StringBuilder();
                String order = (String)mappings.get("nr_zamowienia");
                if (StringUtils.isNotBlank((String)order)) {
                    sb.append("Nr zam\u00f3wienia ");
                    sb.append(order);
                }
                mappings.put("zamowienie", sb.toString());
                if (doc_type_code.compareToIgnoreCase("U") == 0 && StringUtils.isNotBlank((String)oryginalDocNumber)) {
                    if (dGrossDifference <= 0.0) {
                        dGrossDifference = MathFunctions.round((double)MathFunctions.multiply((double)dGrossDifference, (double)-1.0), (int)2);
                        dPlnGrossDifference = MathFunctions.round((double)MathFunctions.multiply((double)dPlnGrossDifference, (double)-1.0), (int)2);
                        platnosc_zwrot = "Kwota do zwrotu";
                    }
                    mappings.put("suma_brutto", ClientTools.changeDoubleFormat(String.valueOf(dGrossDifference)));
                    mappings.put("suma_brutto_pln", ClientTools.changeDoubleFormat(String.valueOf(dPlnGrossDifference)));
                }
                mappings.put("platnosc_zwrot", platnosc_zwrot);
            }
            mappings.put("platnosc_slownie", platnoscSlownie);
            log.debug((Object)("Numer dokumentu: " + document_number));
            mappings.put("nr_dokumentu", document_number);
            String contractNumber = (String)mappings.get("nr_umowy");
            String contractDate = (String)mappings.get("data_umowy");
            if (StringUtils.isBlank((String)contractNumber)) {
                mappings.put("nr_umowy", "-");
            }
            if (StringUtils.isBlank((String)contractDate)) {
                mappings.put("data_umowy", "-");
            }
            String paymentForm = (String)mappings.get("forma_platnonsci");
            StringBuilder descriptionOfPaymentForm = new StringBuilder();
            if (paymentForm.compareToIgnoreCase("przelew") == 0) {
                descriptionOfPaymentForm.append("Powy\u017csz\u0105 kwot\u0119 prosimy wp\u0142aci\u0107 przelewem na nasze konto nr ");
                descriptionOfPaymentForm.append(mappings.get("konto_bankowe").toString());
            }
            mappings.put("opis_formy_platnosci", descriptionOfPaymentForm.toString());
            String sPaymentCode = (String)mappings.get("termin_platnosci");
            mappings.put("termin_platnosci", FSTools.getPaymentTermsForDocument(sPaymentCode));
            log.debug((Object)"Zako\u0144czono ustalanie danych potrzebnych do uzupelnienia szablonu.");
            HashMap<String, Object> optionalParameters = new HashMap<String, Object>();
            FSGenerateDocument.setOptionalParameters(doc_type_code, optionalParameters);
            StringBuilder templateName = new StringBuilder();
            templateName.append("szablon_");
            templateName.append(doc_type_code.toLowerCase().replace("ar", "fs").replace("ap", "fs").replace("fk", "k"));
            if (currency.compareToIgnoreCase("pln") != 0) {
                templateName.append("_waluta");
            }
            String docxPath = "";
            try {
                log.debug((Object)("Pobieram szablon o nazwie: " + String.valueOf(templateName)));
                DocumentTemplateService documentTemplateService = ServiceFactory.getDocumentTemplateService();
                DocumentTemplateTable dtt = documentTemplateService.getByName(templateName.toString(), new String[0]);
                docxPath = dtt.getTemplatePath();
            }
            catch (Exception e) {
                log.error((Object)("Nie udalo si\u0119 pobra\u0107 szablonu: " + e.getMessage()), (Throwable)e);
                throw new Exception("Nie powiod\u0142o si\u0119 pobranie szablonu o nazwie: " + templateName.toString());
            }
            Long docId = null;
            if (!StringUtils.isNotBlank((String)docxPath)) {
                throw new Exception("Nie odnaleziono szablonu o nazwie: " + templateName.toString());
            }
            docId = PrepeareDoc.createPdfAndSaveInArchive((String)docxPath, (String)"Faktury sprzeda\u017cy", (Map)mappings, (String)sProcessId, optionalParameters);
            if (docId == null || docId == -1L) {
                throw new Exception("Wyst\u0105pi\u0142 b\u0142\u0105d podczas generowania dokumentu.");
            }
            DocumentService documentService = ServiceFactory.getDocumentService();
            WfDocument document = documentService.getDocument(docId);
            documentService.attachDocumentToProcess(document, "admin", sProcessId, sActivityId);
            status.setValue((Object)"Wystawiono fv");
            file_id.setValue((Object)String.valueOf(docId));
            if (doc_type_code.startsWith("FK")) {
                String correctingProcessId = (String)mappings.get("pid_kopiowanego_dok");
                log.debug((Object)("Faktura korygujaca. Wyszukuje proces o id: " + correctingProcessId + " i uzupelniam status korygowania nr dokumentu"));
                Map correctingProcessContext = processService.getProcessContext(correctingProcessId);
                if (correctingProcessContext != null && correctingProcessContext.size() > 0) {
                    correctingProcessContext.put("status_korygowania", document_number);
                    processService.setProcessContext(correctingProcessId, correctingProcessContext);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("FSGenerateDocument - Generowanie dokumentu nie powiod\u0142o si\u0119 - processid: " + sProcessId + ": " + e.getMessage()), (Throwable)e);
            sAction = "blad";
            ClientTools.addCommentToActivity(sProcessId, sActivityId, "Generowanie dokumentu zako\u0144czone niepowodzeniem: " + e.getMessage());
        }
        finally {
            action.setValue((Object)sAction);
        }
    }

    private static void setVatTableData(Map<String, Object> map, String[] vatIDs, String[] colIDs, String sVatRates) {
        HashSet<String> vatKeys = new HashSet<String>(Arrays.asList(sVatRates.split(";")));
        ArrayList<String> vatKeysList = new ArrayList<String>(vatKeys);
        Collections.sort(vatKeysList, new VatRatesComparator());
        ArrayList<Map<String, String>> vatTable = new ArrayList<Map<String, String>>();
        for (String vatKey : vatKeysList) {
            Map<String, String> line = new HashMap<String, String>();
            line.put(vatIDs[0], FSTools.getVatRate(vatKey));
            line.put(vatIDs[1], "0");
            line.put(vatIDs[2], "0");
            line.put(vatIDs[3], "0");
            vatTable.add(line);
        }
        List vatTableBeforeChanges = DynamicTableFunctions.convertFromMapToListOfMaps(map, (String[])colIDs);
        for (Map lineBeforeChanges : vatTableBeforeChanges) {
            String vateRate = FSTools.getVatRate((String)lineBeforeChanges.get(colIDs[0]));
            for (Map map2 : vatTable) {
                if (((String)map2.get(vatIDs[0])).compareToIgnoreCase(vateRate) != 0) continue;
                Double netValue = ClientTools.changeStringToDouble((String)lineBeforeChanges.get(colIDs[1]));
                Double vatValue = ClientTools.changeStringToDouble((String)lineBeforeChanges.get(colIDs[2]));
                Double grossValue = ClientTools.changeStringToDouble((String)lineBeforeChanges.get(colIDs[3]));
                map2.put(vatIDs[1], ClientTools.changeDoubleFormat(String.valueOf(MathFunctions.round((double)MathFunctions.add((double)ClientTools.changeStringToDouble((String)map2.get(vatIDs[1])), (double)netValue), (int)2))));
                map2.put(vatIDs[2], String.valueOf(MathFunctions.add((double)ClientTools.changeStringToDouble((String)map2.get(vatIDs[2])), (double)vatValue)));
                map2.put(vatIDs[3], String.valueOf(MathFunctions.add((double)ClientTools.changeStringToDouble((String)map2.get(vatIDs[3])), (double)grossValue)));
            }
        }
        for (Map<String, String> line : vatTable) {
            line.put(vatIDs[2], ClientTools.changeDoubleFormat(String.valueOf(MathFunctions.round((double)ClientTools.changeStringToDouble((String)line.get(vatIDs[2])), (int)2))));
            line.put(vatIDs[3], ClientTools.changeDoubleFormat(String.valueOf(MathFunctions.round((double)ClientTools.changeStringToDouble((String)line.get(vatIDs[3])), (int)2))));
        }
        map.putAll(DynamicTableFunctions.convertFromListOfMapsToMap(vatTable, (String[])vatIDs));
    }

    private static String setRowId(String dataToSplit) {
        String[] tab = dataToSplit.split(";");
        int i = 0;
        StringBuilder sbRowId = new StringBuilder();
        while (i != tab.length) {
            ++i;
            if (sbRowId.length() != 0) {
                sbRowId.append(";");
            }
            sbRowId.append(String.valueOf(i));
        }
        return sbRowId.toString();
    }

    private static void setDataByEan(Map<String, Object> map) throws Exception {
        StringBuilder sbNettoWeightOfItem = new StringBuilder();
        StringBuilder sbBruttoWeightOfItem = new StringBuilder();
        StringBuilder sbNettoWeight = new StringBuilder();
        StringBuilder sbBruttoWeight = new StringBuilder();
        StringBuilder sbDescrition = new StringBuilder();
        double netWeightSum = 0.0;
        double grossWeightSum = 0.0;
        String[] colIDs = new String[]{"tab2_ean", "tab2_opis_pozycji", "tab2_ilosc"};
        List mapBeforeChanges = DynamicTableFunctions.convertFromMapToListOfMaps(map, (String[])colIDs);
        int i = 0;
        for (Map oneRow : mapBeforeChanges) {
            try {
                ++i;
                Map<String, String> eanData = FSTools.getEanData((String)oneRow.get("tab2_ean"));
                double quantity = ClientTools.changeStringToDouble((String)oneRow.get("tab2_ilosc"));
                double netWeightOfItem = ClientTools.changeStringToDouble(eanData.get("waga_netto").replace(",", "."));
                double grossWeightOfItem = ClientTools.changeStringToDouble(eanData.get("waga_brutto").replace(",", "."));
                double netWeight = MathFunctions.round((double)MathFunctions.multiply((double)quantity, (double)netWeightOfItem), (int)2);
                double grossWeight = MathFunctions.round((double)MathFunctions.multiply((double)quantity, (double)grossWeightOfItem), (int)2);
                netWeightSum = MathFunctions.round((double)MathFunctions.add((double)netWeightSum, (double)netWeight), (int)2);
                grossWeightSum = MathFunctions.round((double)MathFunctions.add((double)grossWeightSum, (double)grossWeight), (int)2);
                if (i > 1) {
                    sbNettoWeightOfItem.append(";");
                    sbBruttoWeightOfItem.append(";");
                    sbNettoWeight.append(";");
                    sbBruttoWeight.append(";");
                    sbDescrition.append(";");
                }
                sbNettoWeightOfItem.append(String.valueOf(netWeightOfItem));
                sbBruttoWeightOfItem.append(String.valueOf(grossWeightOfItem));
                sbNettoWeight.append(String.valueOf(netWeight));
                sbBruttoWeight.append(String.valueOf(grossWeight));
                sbDescrition.append((String)oneRow.get("tab2_opis_pozycji"));
                sbDescrition.append(eanData.get("opis"));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new Exception("Nie uda\u0142o si\u0119 ustali\u0107 danych pozycji na podstawie EAN: " + (String)oneRow.get("tab2_ean") + ". Najprawdopodobniej brakuje produktu w bazie.");
            }
        }
        map.put("waga_netto", ClientTools.changeDoubleFormat(String.valueOf(netWeightSum)));
        map.put("waga_brutto", ClientTools.changeDoubleFormat(String.valueOf(grossWeightSum)));
        map.put("waga_netto_item", ClientTools.changeDoubleFormat(sbNettoWeightOfItem.toString()));
        map.put("waga_brutto_item", ClientTools.changeDoubleFormat(sbBruttoWeightOfItem.toString()));
        map.put("laczna_waga_netto", ClientTools.changeDoubleFormat(sbNettoWeight.toString()));
        map.put("laczna_waga_brutto", ClientTools.changeDoubleFormat(sbBruttoWeight.toString()));
        map.put("tab2_opis_pozycji", sbDescrition.toString());
    }

    private static void setOptionalParameters(String documentTypeCode, Map<String, Object> optionalParameters) {
        ArrayList<Boolean> lWhichTables = new ArrayList<Boolean>();
        ArrayList<Boolean> lWhichHeaders = new ArrayList<Boolean>();
        lWhichTables.add(false);
        lWhichHeaders.add(false);
        if (documentTypeCode.startsWith("FS") || documentTypeCode.startsWith("ZAL") || documentTypeCode.startsWith("AR") || documentTypeCode.startsWith("AP") || documentTypeCode.startsWith("M") || documentTypeCode.startsWith("OF")) {
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
        } else if (documentTypeCode.startsWith("FKK")) {
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
        } else if (documentTypeCode.startsWith("FK")) {
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
        } else if (documentTypeCode.startsWith("UA")) {
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
        }
        if (documentTypeCode.startsWith("FZK")) {
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
        }
        lWhichTables.add(false);
        lWhichHeaders.add(false);
        optionalParameters.put("variablesMarker", "@");
        optionalParameters.put("whichTables", lWhichTables);
        optionalParameters.put("whichHeaders", lWhichHeaders);
    }
}

